/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.CachePublicKeyProvider;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClearKeysCacheResource {
    protected AdminPermissionEvaluator auth;
    protected RealmModel realm;
    private AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;

    public ClearKeysCacheResource(KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
        this.session = session;
    }

    @POST
    public void clearKeysCache() {
        this.auth.realm().requireManageRealm();
        CachePublicKeyProvider cache = (CachePublicKeyProvider)this.session.getProvider(CachePublicKeyProvider.class);
        if (cache != null) {
            cache.clearCache();
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }
}

