/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.component.ComponentModel;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.managers.UserStorageSyncManager;
import org.keycloak.storage.user.SynchronizationResult;

public class UserStorageProviderResource {
    private static final Logger logger = Logger.getLogger(UserStorageProviderResource.class);
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public UserStorageProviderResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
    }

    @GET
    @Path(value="{id}/name")
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, String> getSimpleName(@PathParam(value="id") String id) {
        this.auth.users().requireQuery();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a UserStorageProvider");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", model.getId());
        data.put("name", model.getName());
        return data;
    }

    @POST
    @Path(value="{id}/sync")
    @NoCache
    @Produces(value={"application/json"})
    public SynchronizationResult syncUsers(@PathParam(value="id") String id, @QueryParam(value="action") String action) {
        SynchronizationResult syncResult;
        this.auth.users().requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a UserStorageProvider");
        }
        UserStorageProviderModel providerModel = new UserStorageProviderModel(model);
        logger.debug((Object)"Syncing users");
        UserStorageSyncManager syncManager = new UserStorageSyncManager();
        if ("triggerFullSync".equals(action)) {
            syncResult = UserStorageSyncManager.syncAllUsers((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), (String)this.realm.getId(), (UserStorageProviderModel)providerModel);
        } else if ("triggerChangedUsersSync".equals(action)) {
            syncResult = UserStorageSyncManager.syncChangedUsers((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), (String)this.realm.getId(), (UserStorageProviderModel)providerModel);
        } else {
            if (action == null || action == "") {
                logger.debug((Object)"Missing action");
                throw new BadRequestException("Missing action");
            }
            logger.debug((Object)("Unknown action: " + action));
            throw new BadRequestException("Unknown action: " + action);
        }
        HashMap<String, String> eventRep = new HashMap<String, String>();
        eventRep.put("action", action);
        eventRep.put("result", (String)syncResult);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(eventRep).success();
        return syncResult;
    }

    @POST
    @Path(value="{id}/remove-imported-users")
    @NoCache
    public void removeImportedUsers(@PathParam(value="id") String id) {
        this.auth.users().requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a UserStorageProvider");
        }
        this.session.users().removeImportedUsers(this.realm, id);
    }

    @POST
    @Path(value="{id}/unlink-users")
    @NoCache
    public void unlinkUsers(@PathParam(value="id") String id) {
        this.auth.users().requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a UserStorageProvider");
        }
        this.session.users().unlinkUsers(this.realm, id);
    }

    @POST
    @Path(value="{parentId}/mappers/{id}/sync")
    @NoCache
    @Produces(value={"application/json"})
    public SynchronizationResult syncMapperData(@PathParam(value="parentId") String parentId, @PathParam(value="id") String mapperId, @QueryParam(value="direction") String direction) {
        SynchronizationResult syncResult;
        this.auth.users().requireManage();
        ComponentModel parentModel = this.realm.getComponent(parentId);
        if (parentModel == null) {
            throw new NotFoundException("Parent model not found");
        }
        ComponentModel mapperModel = this.realm.getComponent(mapperId);
        if (mapperModel == null) {
            throw new NotFoundException("Mapper model not found");
        }
        LDAPStorageProvider ldapProvider = (LDAPStorageProvider)this.session.getProvider(UserStorageProvider.class, parentModel);
        LDAPStorageMapper mapper = (LDAPStorageMapper)this.session.getProvider(LDAPStorageMapper.class, mapperModel);
        ServicesLogger.LOGGER.syncingDataForMapper(mapperModel.getName(), mapperModel.getProviderId(), direction);
        if ("fedToKeycloak".equals(direction)) {
            syncResult = mapper.syncDataFromFederationProviderToKeycloak(this.realm);
        } else if ("keycloakToFed".equals(direction)) {
            syncResult = mapper.syncDataFromKeycloakToFederationProvider(this.realm);
        } else {
            throw new BadRequestException("Unknown direction: " + direction);
        }
        HashMap<String, String> eventRep = new HashMap<String, String>();
        eventRep.put("action", direction);
        eventRep.put("result", (String)syncResult);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(eventRep).success();
        return syncResult;
    }
}

