/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;

public interface PolicyStore {
    public Policy create(ResourceServer var1, AbstractPolicyRepresentation var2);

    public void delete(RealmModel var1, String var2);

    public Policy findById(RealmModel var1, ResourceServer var2, String var3);

    public Policy findByName(ResourceServer var1, String var2);

    public List<Policy> findByResourceServer(ResourceServer var1);

    public List<Policy> find(RealmModel var1, ResourceServer var2, Map<Policy.FilterOption, String[]> var3, Integer var4, Integer var5);

    default public List<Policy> findByResource(ResourceServer resourceServer, Resource resource) {
        LinkedList<Policy> result = new LinkedList<Policy>();
        this.findByResource(resourceServer, resource, result::add);
        return result;
    }

    public void findByResource(ResourceServer var1, Resource var2, Consumer<Policy> var3);

    default public List<Policy> findByResourceType(ResourceServer resourceServer, String resourceType) {
        LinkedList<Policy> result = new LinkedList<Policy>();
        this.findByResourceType(resourceServer, resourceType, result::add);
        return result;
    }

    public void findByResourceType(ResourceServer var1, String var2, Consumer<Policy> var3);

    public List<Policy> findByScopes(ResourceServer var1, List<Scope> var2);

    default public List<Policy> findByScopes(ResourceServer resourceServer, Resource resource, List<Scope> scopes) {
        LinkedList<Policy> result = new LinkedList<Policy>();
        this.findByScopes(resourceServer, resource, scopes, result::add);
        return result;
    }

    public void findByScopes(ResourceServer var1, Resource var2, List<Scope> var3, Consumer<Policy> var4);

    public List<Policy> findByType(ResourceServer var1, String var2);

    public List<Policy> findDependentPolicies(ResourceServer var1, String var2);
}

