/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.ExpirableEntity;
import org.keycloak.models.map.common.UpdatableEntity;

@DeepCloner.Root
public interface MapRootAuthenticationSessionEntity
extends AbstractEntity,
UpdatableEntity,
ExpirableEntity {
    public String getRealmId();

    public void setRealmId(String var1);

    public Long getTimestamp();

    public void setTimestamp(Long var1);

    public Set<MapAuthenticationSessionEntity> getAuthenticationSessions();

    public void setAuthenticationSessions(Set<MapAuthenticationSessionEntity> var1);

    public Optional<MapAuthenticationSessionEntity> getAuthenticationSession(String var1);

    public void addAuthenticationSession(MapAuthenticationSessionEntity var1);

    public Boolean removeAuthenticationSession(String var1);

    public static abstract class AbstractRootAuthenticationSessionEntity
    extends UpdatableEntity.Impl
    implements MapRootAuthenticationSessionEntity {
        private String id;

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            if (this.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            this.id = id;
            this.updated |= id != null;
        }

        @Override
        public Optional<MapAuthenticationSessionEntity> getAuthenticationSession(String tabId) {
            Set<MapAuthenticationSessionEntity> authenticationSessions = this.getAuthenticationSessions();
            if (authenticationSessions == null || authenticationSessions.isEmpty()) {
                return Optional.empty();
            }
            return authenticationSessions.stream().filter(as -> Objects.equals(as.getTabId(), tabId)).findFirst();
        }

        @Override
        public Boolean removeAuthenticationSession(String tabId) {
            Set<MapAuthenticationSessionEntity> authenticationSessions = this.getAuthenticationSessions();
            boolean removed = authenticationSessions != null && authenticationSessions.removeIf(c -> Objects.equals(c.getTabId(), tabId));
            this.updated |= removed;
            return removed;
        }

        @Override
        public boolean isUpdated() {
            return this.updated || Optional.ofNullable(this.getAuthenticationSessions()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated);
        }

        @Override
        public void clearUpdatedFlag() {
            this.updated = false;
            Optional.ofNullable(this.getAuthenticationSessions()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
        }
    }
}

