/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.keys;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jboss.logging.Logger;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.models.KeycloakSession;

public class MapPublicKeyStorageProvider
implements PublicKeyStorageProvider {
    private static final Logger log = Logger.getLogger(MapPublicKeyStorageProvider.class);
    private final KeycloakSession session;
    private final Map<String, FutureTask<Map<String, KeyWrapper>>> tasksInProgress;

    public MapPublicKeyStorageProvider(KeycloakSession session, Map<String, FutureTask<Map<String, KeyWrapper>>> tasksInProgress) {
        this.session = session;
        this.tasksInProgress = tasksInProgress;
    }

    public KeyWrapper getPublicKey(String modelKey, String kid, PublicKeyLoader loader) {
        return this.getPublicKey(modelKey, kid, null, loader);
    }

    public KeyWrapper getFirstPublicKey(String modelKey, String algorithm, PublicKeyLoader loader) {
        return this.getPublicKey(modelKey, null, algorithm, loader);
    }

    private KeyWrapper getPublicKey(String modelKey, String kid, String algorithm, PublicKeyLoader loader) {
        Map<String, KeyWrapper> currentKeys;
        WrapperCallable wrapperCallable = new WrapperCallable(modelKey, loader);
        FutureTask<Map<String, KeyWrapper>> task = new FutureTask<Map<String, KeyWrapper>>(wrapperCallable);
        FutureTask<Map<String, KeyWrapper>> existing = this.tasksInProgress.putIfAbsent(modelKey, task);
        if (existing == null) {
            task.run();
        } else {
            task = existing;
        }
        try {
            KeyWrapper publicKey;
            currentKeys = task.get();
            KeyWrapper keyWrapper = publicKey = algorithm != null ? this.getPublicKeyByAlg(currentKeys, algorithm) : this.getPublicKey(currentKeys, kid);
            if (publicKey != null) {
                KeyWrapper keyWrapper2 = publicKey;
                return keyWrapper2;
            }
        }
        catch (ExecutionException ee) {
            throw new RuntimeException("Error when loading public keys: " + ee.getMessage(), ee);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Error. Interrupted when loading public keys", ie);
        }
        finally {
            if (existing == null) {
                this.tasksInProgress.remove(modelKey);
            }
        }
        Set<Object> availableKids = currentKeys == null ? Collections.emptySet() : currentKeys.keySet();
        log.warnf("PublicKey wasn't found in the storage. Requested kid: '%s' . Available kids: '%s'", (Object)kid, availableKids);
        return null;
    }

    private KeyWrapper getPublicKey(Map<String, KeyWrapper> publicKeys, String kid) {
        if (kid == null && !publicKeys.isEmpty()) {
            return publicKeys.values().iterator().next();
        }
        return publicKeys.get(kid);
    }

    private KeyWrapper getPublicKeyByAlg(Map<String, KeyWrapper> publicKeys, String algorithm) {
        if (algorithm == null) {
            return null;
        }
        for (KeyWrapper keyWrapper : publicKeys.values()) {
            if (!algorithm.equals(keyWrapper.getAlgorithmOrDefault())) continue;
            return keyWrapper;
        }
        return null;
    }

    public void close() {
    }

    private class WrapperCallable
    implements Callable<Map<String, KeyWrapper>> {
        private final String modelKey;
        private final PublicKeyLoader delegate;

        public WrapperCallable(String modelKey, PublicKeyLoader delegate) {
            this.modelKey = modelKey;
            this.delegate = delegate;
        }

        @Override
        public Map<String, KeyWrapper> call() throws Exception {
            Map publicKeys = this.delegate.loadKeys();
            if (log.isDebugEnabled()) {
                log.debugf("Public keys retrieved successfully for model %s. New kids: %s", (Object)this.modelKey, (Object)publicKeys.keySet().toString());
            }
            return publicKeys;
        }
    }
}

