/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import org.keycloak.models.OTPPolicy;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntityImpl;

@DeepCloner.Root
public interface MapOTPPolicyEntity
extends UpdatableEntity {
    public static MapOTPPolicyEntity fromModel(OTPPolicy model) {
        if (model == null) {
            return null;
        }
        MapOTPPolicyEntityImpl entity = new MapOTPPolicyEntityImpl();
        entity.setOtpPolicyAlgorithm(model.getAlgorithm());
        entity.setOtpPolicyDigits(model.getDigits());
        entity.setOtpPolicyInitialCounter(model.getInitialCounter());
        entity.setOtpPolicyLookAheadWindow(model.getLookAheadWindow());
        entity.setOtpPolicyType(model.getType());
        entity.setOtpPolicyPeriod(model.getPeriod());
        return entity;
    }

    public static OTPPolicy toModel(MapOTPPolicyEntity entity) {
        if (entity == null) {
            return null;
        }
        OTPPolicy model = new OTPPolicy();
        Integer otpPolicyDigits = entity.getOtpPolicyDigits();
        model.setDigits(otpPolicyDigits == null ? 0 : otpPolicyDigits);
        model.setAlgorithm(entity.getOtpPolicyAlgorithm());
        Integer otpPolicyInitialCounter = entity.getOtpPolicyInitialCounter();
        model.setInitialCounter(otpPolicyInitialCounter == null ? 0 : otpPolicyInitialCounter);
        Integer otpPolicyLookAheadWindow = entity.getOtpPolicyLookAheadWindow();
        model.setLookAheadWindow(otpPolicyLookAheadWindow == null ? 0 : otpPolicyLookAheadWindow);
        model.setType(entity.getOtpPolicyType());
        Integer otpPolicyPeriod = entity.getOtpPolicyPeriod();
        model.setPeriod(otpPolicyPeriod == null ? 0 : otpPolicyPeriod);
        return model;
    }

    public Integer getOtpPolicyInitialCounter();

    public void setOtpPolicyInitialCounter(Integer var1);

    public Integer getOtpPolicyDigits();

    public void setOtpPolicyDigits(Integer var1);

    public Integer getOtpPolicyLookAheadWindow();

    public void setOtpPolicyLookAheadWindow(Integer var1);

    public Integer getOtpPolicyPeriod();

    public void setOtpPolicyPeriod(Integer var1);

    public String getOtpPolicyType();

    public void setOtpPolicyType(String var1);

    public String getOtpPolicyAlgorithm();

    public void setOtpPolicyAlgorithm(String var1);
}

