/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.singleUseObject;

import java.util.Collections;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.models.ActionTokenKeyModel;
import org.keycloak.models.ActionTokenStoreProvider;
import org.keycloak.models.ActionTokenValueModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.map.common.ExpirationUtils;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectAdapter;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntity;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntityImpl;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;

public class MapSingleUseObjectProvider
implements ActionTokenStoreProvider,
SingleUseObjectProvider {
    private static final Logger LOG = Logger.getLogger(MapSingleUseObjectProvider.class);
    private final KeycloakSession session;
    protected final MapKeycloakTransaction<MapSingleUseObjectEntity, ActionTokenValueModel> actionTokenStoreTx;

    public MapSingleUseObjectProvider(KeycloakSession session, MapStorage<MapSingleUseObjectEntity, ActionTokenValueModel> storage) {
        this.session = session;
        this.actionTokenStoreTx = storage.createTransaction(session);
        session.getTransactionManager().enlistAfterCompletion(this.actionTokenStoreTx);
    }

    private ActionTokenValueModel singleUseEntityToAdapter(MapSingleUseObjectEntity origEntity) {
        if (ExpirationUtils.isExpired(origEntity, false)) {
            this.actionTokenStoreTx.delete(origEntity.getId());
            return null;
        }
        return new MapSingleUseObjectAdapter(this.session, origEntity);
    }

    public void put(ActionTokenKeyModel actionTokenKey, Map<String, String> notes) {
        if (actionTokenKey == null || actionTokenKey.getUserId() == null || actionTokenKey.getActionId() == null || actionTokenKey.getActionVerificationNonce() == null) {
            return;
        }
        LOG.tracef("put(%s, %s, %s)%s", new Object[]{actionTokenKey.getUserId(), actionTokenKey.getActionId(), actionTokenKey.getActionVerificationNonce(), StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(ActionTokenValueModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{actionTokenKey.getUserId()})).compare(ActionTokenValueModel.SearchableFields.ACTION_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{actionTokenKey.getActionId()})).compare(ActionTokenValueModel.SearchableFields.ACTION_VERIFICATION_NONCE, ModelCriteriaBuilder.Operator.EQ, new Object[]{actionTokenKey.getActionVerificationNonce().toString()});
        ActionTokenValueModel existing = this.actionTokenStoreTx.read(QueryParameters.withCriteria(mcb)).findFirst().map(this::singleUseEntityToAdapter).orElse(null);
        if (existing == null) {
            MapSingleUseObjectEntityImpl actionTokenStoreEntity = new MapSingleUseObjectEntityImpl();
            actionTokenStoreEntity.setUserId(actionTokenKey.getUserId());
            actionTokenStoreEntity.setActionId(actionTokenKey.getActionId());
            actionTokenStoreEntity.setActionVerificationNonce(actionTokenKey.getActionVerificationNonce().toString());
            actionTokenStoreEntity.setExpiration(TimeAdapter.fromSecondsToMilliseconds(actionTokenKey.getExpiration()));
            actionTokenStoreEntity.setNotes(notes);
            LOG.debugf("Adding used action token to actionTokens cache: %s", (Object)actionTokenKey.toString());
            this.actionTokenStoreTx.create(actionTokenStoreEntity);
        }
    }

    public ActionTokenValueModel get(ActionTokenKeyModel key) {
        if (key == null || key.getUserId() == null || key.getActionId() == null || key.getActionVerificationNonce() == null) {
            return null;
        }
        LOG.tracef("get(%s, %s, %s)%s", new Object[]{key.getUserId(), key.getActionId(), key.getActionVerificationNonce(), StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(ActionTokenValueModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{key.getUserId()})).compare(ActionTokenValueModel.SearchableFields.ACTION_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{key.getActionId()})).compare(ActionTokenValueModel.SearchableFields.ACTION_VERIFICATION_NONCE, ModelCriteriaBuilder.Operator.EQ, new Object[]{key.getActionVerificationNonce().toString()});
        return this.actionTokenStoreTx.read(QueryParameters.withCriteria(mcb)).findFirst().map(this::singleUseEntityToAdapter).orElse(null);
    }

    public ActionTokenValueModel remove(ActionTokenKeyModel key) {
        ActionTokenValueModel actionToken;
        if (key == null || key.getUserId() == null || key.getActionId() == null || key.getActionVerificationNonce() == null) {
            return null;
        }
        LOG.tracef("remove(%s, %s, %s)%s", new Object[]{key.getUserId(), key.getActionId(), key.getActionVerificationNonce(), StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(ActionTokenValueModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{key.getUserId()})).compare(ActionTokenValueModel.SearchableFields.ACTION_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{key.getActionId()})).compare(ActionTokenValueModel.SearchableFields.ACTION_VERIFICATION_NONCE, ModelCriteriaBuilder.Operator.EQ, new Object[]{key.getActionVerificationNonce().toString()});
        MapSingleUseObjectEntity mapSingleUseObjectEntity = this.actionTokenStoreTx.read(QueryParameters.withCriteria(mcb)).findFirst().orElse(null);
        if (mapSingleUseObjectEntity != null && (actionToken = this.singleUseEntityToAdapter(mapSingleUseObjectEntity)) != null) {
            this.actionTokenStoreTx.delete(mapSingleUseObjectEntity.getId());
            return actionToken;
        }
        return null;
    }

    public void put(String key, long lifespanSeconds, Map<String, String> notes) {
        LOG.tracef("put(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity singleUseEntity = this.getWithExpiration(key);
        if (singleUseEntity != null) {
            throw new ModelDuplicateException("Single-use object entity exists: " + singleUseEntity.getObjectKey());
        }
        singleUseEntity = new MapSingleUseObjectEntityImpl();
        singleUseEntity.setObjectKey(key);
        singleUseEntity.setExpiration(Time.currentTimeMillis() + TimeAdapter.fromSecondsToMilliseconds(lifespanSeconds));
        singleUseEntity.setNotes(notes);
        this.actionTokenStoreTx.create(singleUseEntity);
    }

    public Map<String, String> get(String key) {
        LOG.tracef("get(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity actionToken = this.getWithExpiration(key);
        if (actionToken != null) {
            Map<String, String> notes = actionToken.getNotes();
            return notes == null ? Collections.emptyMap() : Collections.unmodifiableMap(notes);
        }
        return null;
    }

    public Map<String, String> remove(String key) {
        LOG.tracef("remove(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity singleUseEntity = this.getWithExpiration(key);
        if (singleUseEntity != null) {
            Map<String, String> notes = singleUseEntity.getNotes();
            if (this.actionTokenStoreTx.delete(singleUseEntity.getId())) {
                return notes == null ? Collections.emptyMap() : Collections.unmodifiableMap(notes);
            }
        }
        return null;
    }

    public boolean replace(String key, Map<String, String> notes) {
        LOG.tracef("replace(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity singleUseEntity = this.getWithExpiration(key);
        if (singleUseEntity != null) {
            singleUseEntity.setNotes(notes);
            return true;
        }
        return false;
    }

    public boolean putIfAbsent(String key, long lifespanInSeconds) {
        LOG.tracef("putIfAbsent(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity singleUseEntity = this.getWithExpiration(key);
        if (singleUseEntity != null) {
            return false;
        }
        singleUseEntity = new MapSingleUseObjectEntityImpl();
        singleUseEntity.setObjectKey(key);
        singleUseEntity.setExpiration(Time.currentTimeMillis() + TimeAdapter.fromSecondsToMilliseconds(lifespanInSeconds));
        this.actionTokenStoreTx.create(singleUseEntity);
        return true;
    }

    public boolean contains(String key) {
        LOG.tracef("contains(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity actionToken = this.getWithExpiration(key);
        return actionToken != null;
    }

    public void close() {
    }

    private MapSingleUseObjectEntity getWithExpiration(String key) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        MapSingleUseObjectEntity singleUseEntity = this.actionTokenStoreTx.read(QueryParameters.withCriteria(mcb = mcb.compare(ActionTokenValueModel.SearchableFields.OBJECT_KEY, ModelCriteriaBuilder.Operator.EQ, new Object[]{key}))).findFirst().orElse(null);
        if (singleUseEntity != null) {
            if (ExpirationUtils.isExpired(singleUseEntity, false)) {
                this.actionTokenStoreTx.delete(singleUseEntity.getId());
            } else {
                return singleUseEntity;
            }
        }
        return null;
    }
}

