/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import org.keycloak.models.ActionTokenValueModel;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.storage.SearchableModelField;

public class SingleUseObjectModelCriteriaBuilder
implements ModelCriteriaBuilder {
    private String userId;
    private String actionId;
    private String actionVerificationNonce;
    private String objectKey;

    public SingleUseObjectModelCriteriaBuilder() {
    }

    public SingleUseObjectModelCriteriaBuilder(String userId, String actionId, String actionVerificationNonce, String objectKey) {
        this.userId = userId;
        this.actionId = actionId;
        this.actionVerificationNonce = actionVerificationNonce;
        this.objectKey = objectKey;
    }

    public ModelCriteriaBuilder compare(SearchableModelField modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        if (modelField == ActionTokenValueModel.SearchableFields.USER_ID) {
            this.userId = value[0].toString();
        } else if (modelField == ActionTokenValueModel.SearchableFields.ACTION_ID) {
            this.actionId = value[0].toString();
        } else if (modelField == ActionTokenValueModel.SearchableFields.ACTION_VERIFICATION_NONCE) {
            this.actionVerificationNonce = value[0].toString();
        } else if (modelField == ActionTokenValueModel.SearchableFields.OBJECT_KEY) {
            this.objectKey = value[0].toString();
        }
        return new SingleUseObjectModelCriteriaBuilder(this.userId, this.actionId, this.actionVerificationNonce, this.objectKey);
    }

    public ModelCriteriaBuilder and(ModelCriteriaBuilder[] builders) {
        String userId = null;
        String actionId = null;
        String actionVerificationNonce = null;
        String objectKey = null;
        for (ModelCriteriaBuilder builder : builders) {
            SingleUseObjectModelCriteriaBuilder suoMcb = (SingleUseObjectModelCriteriaBuilder)builder;
            if (suoMcb.userId != null) {
                userId = suoMcb.userId;
            }
            if (suoMcb.actionId != null) {
                actionId = suoMcb.actionId;
            }
            if (suoMcb.actionVerificationNonce != null) {
                actionVerificationNonce = suoMcb.actionVerificationNonce;
            }
            if (suoMcb.objectKey == null) continue;
            objectKey = suoMcb.objectKey;
        }
        return new SingleUseObjectModelCriteriaBuilder(userId, actionId, actionVerificationNonce, objectKey);
    }

    public ModelCriteriaBuilder or(ModelCriteriaBuilder[] builders) {
        throw new IllegalStateException("SingleUseObjectModelCriteriaBuilder does not support OR operation.");
    }

    public ModelCriteriaBuilder not(ModelCriteriaBuilder builder) {
        throw new IllegalStateException("SingleUseObjectModelCriteriaBuilder does not support NOT operation.");
    }

    public boolean isValid() {
        return this.userId != null && this.actionId != null && this.actionVerificationNonce != null || this.objectKey != null;
    }

    public String getKey() {
        if (this.objectKey != null) {
            return this.objectKey;
        }
        return this.userId + ":" + this.actionId + ":" + this.actionVerificationNonce;
    }
}

