/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedMap;

public class MultivaluedTreeMap<K, V>
implements QuarkusMultivaluedMap<K, V>,
Serializable {
    private static final long serialVersionUID = -5819694356897323354L;
    private final Map<K, List<V>> map;

    public MultivaluedTreeMap() {
        this.map = new TreeMap<K, List<V>>();
    }

    public MultivaluedTreeMap(Comparator<K> keyComparator) {
        this.map = new TreeMap<K, List<V>>(keyComparator);
    }

    public MultivaluedTreeMap(Map<K, V> map) {
        this();
        for (K key : map.keySet()) {
            this.add(key, map.get(key));
        }
    }

    public void add(K key, V value) {
        List<V> list = this.getOrCreate(key);
        list.add(value);
    }

    public V getFirst(K key) {
        Object list = this.get(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (V)list.get(0);
    }

    public void putSingle(K key, V value) {
        List<V> list = this.getOrCreate(key);
        list.clear();
        list.add(value);
    }

    private List<V> getOrCreate(K key) {
        List<V> list = this.get(key);
        if (list == null) {
            list = this.createValueList(key);
            this.map.put(key, list);
        }
        return list;
    }

    private List<V> createValueList(K key) {
        return new ArrayList(1);
    }

    private List<V> createValueList(List<V> values) {
        return new ArrayList<V>(values);
    }

    public MultivaluedTreeMap<K, V> clone() {
        return MultivaluedTreeMap.clone(this);
    }

    public static <K, V> MultivaluedTreeMap<K, V> clone(MultivaluedMap<K, V> src) {
        MultivaluedTreeMap<K, V> clone = new MultivaluedTreeMap<K, V>();
        MultivaluedTreeMap.copy(src, clone);
        return clone;
    }

    public static <K, V> void copy(MultivaluedMap<K, V> src, MultivaluedMap<K, V> dest) {
        for (Object key : src.keySet()) {
            List value = (List)src.get(key);
            ArrayList newValue = new ArrayList(value);
            dest.put(key, newValue);
        }
    }

    public static <K, V> void addAll(MultivaluedMap<K, V> src, MultivaluedMap<K, V> dest) {
        for (Object key : src.keySet()) {
            List srcList = (List)src.get(key);
            ArrayList destList = (ArrayList)dest.get(key);
            if (destList == null) {
                destList = new ArrayList(srcList.size());
                dest.put(key, destList);
            }
            destList.addAll(srcList);
        }
    }

    public String toString() {
        return "[" + MultivaluedTreeMap.toString(this, ",") + "]";
    }

    public static String toString(MultivaluedMap<?, ?> map, String delimiter) {
        StringBuilder result = new StringBuilder();
        MultivaluedMap<?, ?> params = map;
        String delim = "";
        for (Object name : params.keySet()) {
            for (Object value : (List)params.get(name)) {
                result.append(delim);
                if (name == null) {
                    result.append("null");
                } else {
                    result.append(name.toString());
                }
                if (value != null) {
                    result.append('=');
                    result.append(value.toString());
                }
                delim = delimiter;
            }
        }
        return result.toString();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public List<V> get(Object key) {
        return this.map.get(key);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public List<V> put(K key, List<V> value) {
        if (value != null) {
            value = this.createValueList(value);
        }
        return this.map.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends List<V>> t) {
        for (Map.Entry<K, List<V>> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Collection<List<V>> values() {
        return this.map.values();
    }

    public void addAll(K key, V ... newValues) {
        for (V value : newValues) {
            this.add(key, value);
        }
    }

    public void addAll(K key, List<V> valueList) {
        for (V value : valueList) {
            this.add(key, value);
        }
    }

    public void addFirst(K key, V value) {
        Object list = this.get(key);
        if (list == null) {
            this.add(key, value);
            return;
        }
        list.add(0, value);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<K, V> omap) {
        if (this == omap) {
            return true;
        }
        if (!this.keySet().equals(omap.keySet())) {
            return false;
        }
        for (Map.Entry<K, List<V>> e : this.entrySet()) {
            List olist = (List)omap.get(e.getKey());
            if (e.getValue().size() != olist.size()) {
                return false;
            }
            for (V v : e.getValue()) {
                if (olist.contains(v)) continue;
                return false;
            }
        }
        return true;
    }

    public void forEach(BiConsumer<? super K, ? super List<V>> action) {
        this.map.forEach(action);
    }
}

