/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultKVSecretEngine;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvListSecretsData;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretV1;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretV2;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretV2Data;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretV2WriteBody;
import io.quarkus.vault.runtime.client.secretengine.VaultInternalKvV1SecretEngine;
import io.quarkus.vault.runtime.client.secretengine.VaultInternalKvV2SecretEngine;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class VaultKvManager
implements VaultKVSecretEngine {
    @Inject
    private VaultAuthManager vaultAuthManager;
    @Inject
    private VaultConfigHolder vaultConfigHolder;
    @Inject
    private VaultInternalKvV1SecretEngine vaultInternalKvV1SecretEngine;
    @Inject
    private VaultInternalKvV2SecretEngine vaultInternalKvV2SecretEngine;

    private VaultBootstrapConfig getConfig() {
        return this.vaultConfigHolder.getVaultBootstrapConfig();
    }

    @Override
    public Map<String, String> readSecret(String path) {
        String clientToken = this.vaultAuthManager.getClientToken();
        String mount = this.getConfig().kvSecretEngineMountPath;
        if (this.isV1()) {
            VaultKvSecretV1 secretV1 = this.vaultInternalKvV1SecretEngine.getSecret(clientToken, mount, path);
            return (Map)secretV1.data;
        }
        VaultKvSecretV2 secretV2 = this.vaultInternalKvV2SecretEngine.getSecret(clientToken, mount, path);
        return ((VaultKvSecretV2Data)secretV2.data).data;
    }

    @Override
    public void writeSecret(String path, Map<String, String> secret) {
        String clientToken = this.vaultAuthManager.getClientToken();
        String mount = this.getConfig().kvSecretEngineMountPath;
        if (this.isV1()) {
            this.vaultInternalKvV1SecretEngine.writeSecret(clientToken, mount, path, secret);
        } else {
            VaultKvSecretV2WriteBody body = new VaultKvSecretV2WriteBody();
            body.data = secret;
            this.vaultInternalKvV2SecretEngine.writeSecret(clientToken, mount, path, body);
        }
    }

    @Override
    public void deleteSecret(String path) {
        String clientToken = this.vaultAuthManager.getClientToken();
        String mount = this.getConfig().kvSecretEngineMountPath;
        if (this.isV1()) {
            this.vaultInternalKvV1SecretEngine.deleteSecret(clientToken, mount, path);
        } else {
            this.vaultInternalKvV2SecretEngine.deleteSecret(clientToken, mount, path);
        }
    }

    @Override
    public List<String> listSecrets(String path) {
        String clientToken = this.vaultAuthManager.getClientToken();
        String mount = this.getConfig().kvSecretEngineMountPath;
        return ((VaultKvListSecretsData)(this.isV1() ? this.vaultInternalKvV1SecretEngine.listSecrets((String)clientToken, (String)mount, (String)path) : this.vaultInternalKvV2SecretEngine.listSecrets((String)clientToken, (String)mount, (String)path)).data).keys;
    }

    private boolean isV1() {
        return this.getConfig().kvSecretEngineVersion == 1;
    }
}

