/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.transit;

import io.quarkus.vault.transit.VaultTransitKeyVersion;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class VaultTransitKeyDetail<KEYVER extends VaultTransitKeyVersion> {
    private String name;
    private String detail;
    private boolean deletionAllowed;
    private boolean derived;
    private boolean exportable;
    private boolean allowPlaintextBackup;
    private Map<String, KEYVER> versions;
    private int latestVersion;
    private int minAvailableVersion;
    private int minDecryptionVersion;
    private int minEncryptionVersion;
    private boolean supportsEncryption;
    private boolean supportsDecryption;
    private boolean supportsDerivation;
    private boolean supportsSigning;
    private String type;

    public String getName() {
        return this.name;
    }

    public VaultTransitKeyDetail<KEYVER> setName(String name) {
        this.name = name;
        return this;
    }

    public String getDetail() {
        return this.detail;
    }

    public VaultTransitKeyDetail<KEYVER> setDetail(String detail) {
        this.detail = detail;
        return this;
    }

    public boolean isDeletionAllowed() {
        return this.deletionAllowed;
    }

    public VaultTransitKeyDetail<KEYVER> setDeletionAllowed(boolean deletionAllowed) {
        this.deletionAllowed = deletionAllowed;
        return this;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public VaultTransitKeyDetail<KEYVER> setDerived(boolean derived) {
        this.derived = derived;
        return this;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public VaultTransitKeyDetail<KEYVER> setExportable(boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    public boolean isAllowPlaintextBackup() {
        return this.allowPlaintextBackup;
    }

    public VaultTransitKeyDetail<KEYVER> setAllowPlaintextBackup(boolean allowPlaintextBackup) {
        this.allowPlaintextBackup = allowPlaintextBackup;
        return this;
    }

    @Deprecated
    public Map<String, Integer> getKeys() {
        return this.versions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (int)((VaultTransitKeyVersion)entry.getValue()).getCreationTime().toEpochSecond()));
    }

    public Map<String, KEYVER> getVersions() {
        return this.versions;
    }

    public VaultTransitKeyDetail<KEYVER> setVersions(Map<String, KEYVER> versions) {
        this.versions = versions;
        return this;
    }

    public int getLatestVersion() {
        return this.latestVersion;
    }

    public VaultTransitKeyDetail<KEYVER> setLatestVersion(int latestVersion) {
        this.latestVersion = latestVersion;
        return this;
    }

    public int getMinAvailableVersion() {
        return this.minAvailableVersion;
    }

    public VaultTransitKeyDetail<KEYVER> setMinAvailableVersion(int minAvailableVersion) {
        this.minAvailableVersion = minAvailableVersion;
        return this;
    }

    public int getMinDecryptionVersion() {
        return this.minDecryptionVersion;
    }

    public VaultTransitKeyDetail<KEYVER> setMinDecryptionVersion(int minDecryptionVersion) {
        this.minDecryptionVersion = minDecryptionVersion;
        return this;
    }

    public int getMinEncryptionVersion() {
        return this.minEncryptionVersion;
    }

    public VaultTransitKeyDetail<KEYVER> setMinEncryptionVersion(int minEncryptionVersion) {
        this.minEncryptionVersion = minEncryptionVersion;
        return this;
    }

    public boolean isSupportsEncryption() {
        return this.supportsEncryption;
    }

    public VaultTransitKeyDetail<KEYVER> setSupportsEncryption(boolean supportsEncryption) {
        this.supportsEncryption = supportsEncryption;
        return this;
    }

    public boolean isSupportsDecryption() {
        return this.supportsDecryption;
    }

    public VaultTransitKeyDetail<KEYVER> setSupportsDecryption(boolean supportsDecryption) {
        this.supportsDecryption = supportsDecryption;
        return this;
    }

    public boolean isSupportsDerivation() {
        return this.supportsDerivation;
    }

    public VaultTransitKeyDetail<KEYVER> setSupportsDerivation(boolean supportsDerivation) {
        this.supportsDerivation = supportsDerivation;
        return this;
    }

    public boolean isSupportsSigning() {
        return this.supportsSigning;
    }

    public VaultTransitKeyDetail<KEYVER> setSupportsSigning(boolean supportsSigning) {
        this.supportsSigning = supportsSigning;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public VaultTransitKeyDetail<KEYVER> setType(String type) {
        this.type = type;
        return this;
    }
}

