/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.util.StringUtil;
import liquibase.util.TableOutput;

public class ChecksShowCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "show"};
    private static final String PRIORITY_HEADER = "#";
    private static final int[] maxWidths = new int[]{3, 30, 64, 30, 8, 30, 9};
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        String string = commandResultsBuilder.getCommandScope().getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksShowCommandStep.checkFileArgExistence(string, "checks settings", false);
        String string2 = System.lineSeparator() + "Generating report on current configuration of checks using settings in: " + (StringUtil.isEmpty(string) ? "liquibase.checks-settings.conf" : string) + System.lineSeparator();
        Scope.getCurrentScope().getUI().sendMessage(string2);
        ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string, true);
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("List available checks, their configuration options, and current settings");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    public static void writeTableToOutput(CommandResultsBuilder object, String list, boolean bl2) {
        List<AbstractLiquibaseRule> list2 = ChecksShowCommandStep.listAllRules();
        String string = ((CommandResultsBuilder)object).getCommandScope().getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
        list = new CheckSettingsConfigHelper((String)((Object)list), string).read(list2);
        list = ChecksShowCommandStep.createTableWithData(list2, (CheckSettingsConfig)((Object)list), bl2);
        object = ChecksShowCommandStep.createOutputWriter((CommandResultsBuilder)object);
        TableOutput.formatOutput(list, maxWidths, true, (Writer)object);
    }

    private static Optional<AbstractLiquibaseRule> findParentRule(List<AbstractLiquibaseRule> list, AbstractConfigurableRule object) {
        object = ((AbstractConfigurableRule)object).isConfigurable() ? (((DynamicRule)(object = (DynamicRule)object)).isCopy() ? ((DynamicRule)object).getParentRuleId() : ((AbstractConfigurableRule)object).getId()) : ((AbstractConfigurableRule)object).getId();
        return list.stream().filter(arg_0 -> ChecksShowCommandStep.lambda$findParentRule$1((UUID)object, arg_0)).findFirst();
    }

    private static List<List<String>> createTableWithData(List<AbstractLiquibaseRule> list, CheckSettingsConfig iterator, boolean bl2) {
        ArrayList<List<String>> arrayList;
        block6: {
            block5: {
                arrayList = new ArrayList<List<String>>();
                arrayList.add(Arrays.asList(PRIORITY_HEADER, "Check Name", "Short Name", "Description", "Enabled", "Customization", "Severity"));
                if (iterator == null) break block5;
                for (AbstractConfigurableRule abstractConfigurableRule : ((CheckSettingsConfig)((Object)iterator)).getRules()) {
                    Optional<AbstractLiquibaseRule> optional = ChecksShowCommandStep.findParentRule(list, abstractConfigurableRule);
                    if (optional.isPresent()) {
                        optional = optional.get();
                        String string = "<None>";
                        String string2 = ((AbstractLiquibaseRule)((Object)optional)).getShortName();
                        if (abstractConfigurableRule.isConfigurable()) {
                            string = ((DynamicRule)abstractConfigurableRule).prettyPrintParameters();
                            string2 = ((DynamicRule)abstractConfigurableRule).getShortName();
                        }
                        arrayList.add(Arrays.asList(String.valueOf(((AbstractLiquibaseRule)((Object)optional)).getPriority()), ((AbstractLiquibaseRule)((Object)optional)).getName(), string2, ((AbstractLiquibaseRule)((Object)optional)).getDescription(), Boolean.toString(abstractConfigurableRule.isEnabled()), string, Integer.toString(abstractConfigurableRule.getSeverity().getExitValue())));
                        continue;
                    }
                    Scope.getCurrentScope().getLog(ChecksShowCommandStep.class).fine("Customized rule with ID " + abstractConfigurableRule.getId() + " does not match any rules loaded in the system, and will not be shown.");
                }
                break block6;
            }
            if (!bl2) break block6;
            for (AbstractLiquibaseRule abstractLiquibaseRule : list) {
                String string = "<None>";
                if (abstractLiquibaseRule.isConfigurable()) {
                    string = abstractLiquibaseRule.prettyPrintParameters();
                }
                arrayList.add(Arrays.asList(String.valueOf(abstractLiquibaseRule.getPriority()), abstractLiquibaseRule.getName(), abstractLiquibaseRule.getShortName(), abstractLiquibaseRule.getDescription(), String.valueOf(abstractLiquibaseRule.hasDefaultParameterValues()), string, Integer.toString(abstractLiquibaseRule.getSeverity().getExitValue())));
            }
        }
        return arrayList;
    }

    private static Writer createOutputWriter(CommandResultsBuilder object) {
        String string = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        object = ((CommandResultsBuilder)object).getOutputStream();
        return new OutputStreamWriter((OutputStream)object, string);
    }

    private static /* synthetic */ boolean lambda$findParentRule$1(UUID uUID, AbstractLiquibaseRule abstractLiquibaseRule) {
        return abstractLiquibaseRule.getId().equals(uUID);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
    }
}

