/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.schema;

import io.quarkus.datasource.runtime.DatabaseSchemaProvider;
import io.quarkus.runtime.LaunchMode;
import java.io.StringWriter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToWriter;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.SchemaMigrator;
import org.hibernate.tool.schema.spi.SchemaValidator;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.jboss.logging.Logger;

public class SchemaManagementIntegrator
implements Integrator,
DatabaseSchemaProvider {
    private static final Logger log = Logger.getLogger(SchemaManagementIntegrator.class);
    private static final Map<String, Holder> metadataMap = new ConcurrentHashMap<String, Holder>();
    private static final Map<String, String> datasourceToPuMap = new ConcurrentHashMap<String, String>();
    private static final Map<SessionFactoryImplementor, String> nameCache = Collections.synchronizedMap(new IdentityHashMap());

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        String name = SchemaManagementIntegrator.defaultName(sessionFactory);
        metadataMap.put(name, new Holder(metadata, sessionFactory, serviceRegistry));
        nameCache.put(sessionFactory, name);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        String name = nameCache.remove(sessionFactory);
        if (name != null) {
            metadataMap.remove(name);
        }
    }

    public static void clearDsMap() {
        datasourceToPuMap.clear();
    }

    public static void mapDatasource(String datasource, String pu) {
        datasourceToPuMap.put(datasource, pu);
    }

    static String defaultName(SessionFactoryImplementor sf) {
        String name = sf.getName();
        if (name != null) {
            return name;
        }
        Object persistenceUnitName = sf.getProperties().get("hibernate.ejb.persistenceUnitName");
        if (persistenceUnitName != null) {
            return persistenceUnitName.toString();
        }
        return "<default>";
    }

    public static void recreateDatabases() {
        if (!LaunchMode.current().isDevOrTest()) {
            throw new IllegalStateException("Can only be used in dev or test mode");
        }
        for (String val : metadataMap.keySet()) {
            SchemaManagementIntegrator.recreateDatabase(val);
        }
    }

    public static void recreateDatabase(String name) {
        if (!LaunchMode.current().isDevOrTest()) {
            throw new IllegalStateException("Can only be used in dev or test mode");
        }
        Holder holder = metadataMap.get(name);
        ServiceRegistryImplementor serviceRegistry = holder.sessionFactory.getServiceRegistry();
        SimpleExecutionOptions executionOptions = new SimpleExecutionOptions((ServiceRegistry)serviceRegistry);
        Object schemaGenerationDatabaseAction = executionOptions.getConfigurationValues().get("javax.persistence.schema-generation.database.action");
        if (schemaGenerationDatabaseAction != null && !schemaGenerationDatabaseAction.toString().equals("none")) {
            SchemaManagementTool schemaManagementTool = (SchemaManagementTool)serviceRegistry.getService(SchemaManagementTool.class);
            SchemaDropper schemaDropper = schemaManagementTool.getSchemaDropper(executionOptions.getConfigurationValues());
            schemaDropper.doDrop(holder.metadata, (ExecutionOptions)executionOptions, (SourceDescriptor)new SimpleSourceDescriptor(), (TargetDescriptor)new SimpleTargetDescriptor());
            schemaManagementTool.getSchemaCreator(executionOptions.getConfigurationValues()).doCreation(holder.metadata, (ExecutionOptions)executionOptions, (SourceDescriptor)new SimpleSourceDescriptor(), (TargetDescriptor)new SimpleTargetDescriptor());
        }
        holder.sessionFactory.getCache().evictAll();
        holder.sessionFactory.getCache().evictQueries();
    }

    public static void runPostBootValidation(String name) {
        if (!LaunchMode.current().isDevOrTest()) {
            throw new IllegalStateException("Can only be used in dev or test mode");
        }
        try {
            Holder val = metadataMap.get(name);
            if (val == null) {
                return;
            }
            ServiceRegistryImplementor serviceRegistry = val.sessionFactory.getServiceRegistry();
            SchemaManagementTool schemaManagementTool = (SchemaManagementTool)serviceRegistry.getService(SchemaManagementTool.class);
            SimpleExecutionOptions executionOptions = new SimpleExecutionOptions((ServiceRegistry)serviceRegistry);
            SchemaValidator validator = schemaManagementTool.getSchemaValidator(executionOptions.getConfigurationValues());
            try {
                validator.doValidation(val.metadata, (ExecutionOptions)executionOptions);
            }
            catch (SchemaManagementException e) {
                log.error((Object)("Failed to validate Schema: " + e.getMessage()));
                SchemaMigrator migrator = schemaManagementTool.getSchemaMigrator(executionOptions.getConfigurationValues());
                final StringWriter writer = new StringWriter();
                migrator.doMigration(val.metadata, (ExecutionOptions)executionOptions, new TargetDescriptor(){

                    public EnumSet<TargetType> getTargetTypes() {
                        return EnumSet.of(TargetType.SCRIPT);
                    }

                    public ScriptTargetOutput getScriptTargetOutput() {
                        return new ScriptTargetOutputToWriter(writer){

                            public void accept(String command) {
                                super.accept(command);
                            }
                        };
                    }
                });
                log.error((Object)("The following SQL may resolve the database issues, as generated by the Hibernate schema migration tool. WARNING: You must manually verify this SQL is correct, this is a best effort guess, do not copy/paste it without verifying that it does what you expect.\n\n" + writer.toString()));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to run post-boot validation", t);
        }
    }

    public void resetDatabase(String dbName) {
        String name = datasourceToPuMap.get(dbName);
        if (name == null) {
            return;
        }
        SchemaManagementIntegrator.recreateDatabase(name);
    }

    public void resetAllDatabases() {
        SchemaManagementIntegrator.recreateDatabases();
    }

    private static class SimpleTargetDescriptor
    implements TargetDescriptor {
        private SimpleTargetDescriptor() {
        }

        public EnumSet<TargetType> getTargetTypes() {
            return EnumSet.of(TargetType.DATABASE);
        }

        public ScriptTargetOutput getScriptTargetOutput() {
            return null;
        }
    }

    private static class SimpleSourceDescriptor
    implements SourceDescriptor {
        private SimpleSourceDescriptor() {
        }

        public SourceType getSourceType() {
            return SourceType.METADATA;
        }

        public ScriptSourceInput getScriptSourceInput() {
            return null;
        }
    }

    private static class SimpleExecutionOptions
    implements ExecutionOptions {
        private final Map<?, ?> configurationValues;

        public SimpleExecutionOptions(ServiceRegistry serviceRegistry) {
            this.configurationValues = ((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings();
        }

        public Map<?, ?> getConfigurationValues() {
            return this.configurationValues;
        }

        public boolean shouldManageNamespaces() {
            return false;
        }

        public ExceptionHandler getExceptionHandler() {
            return new ExceptionHandler(){

                public void handleException(CommandAcceptanceException exception) {
                    log.error((Object)"Failed to recreate schema", (Throwable)exception);
                }
            };
        }
    }

    static class Holder {
        final Metadata metadata;
        final SessionFactoryImplementor sessionFactory;
        final SessionFactoryServiceRegistry serviceRegistry;

        Holder(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
            this.metadata = metadata;
            this.sessionFactory = sessionFactory;
            this.serviceRegistry = serviceRegistry;
        }
    }
}

