/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractGeneratedRsaKeyProviderFactory;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.ImportedRsaKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedRsaEncKeyProviderFactory
extends AbstractGeneratedRsaKeyProviderFactory {
    private static final Logger logger = Logger.getLogger(GeneratedRsaEncKeyProviderFactory.class);
    public static final String ID = "rsa-enc-generated";
    private static final String HELP_TEXT = "Generates RSA keys for key encryption and creates a self-signed certificate";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = AbstractGeneratedRsaKeyProviderFactory.rsaKeyConfigurationBuilder().property(Attributes.KEY_SIZE_PROPERTY).property(Attributes.RS_ENC_ALGORITHM_PROPERTY).build();

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        model.put("keyUse", KeyUse.ENC.name());
        return new ImportedRsaKeyProvider(session.getContext().getRealm(), model);
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return ID;
    }

    @Override
    protected boolean isValidKeyUse(KeyUse keyUse) {
        return keyUse.equals((Object)KeyUse.ENC);
    }

    @Override
    protected boolean isSupportedRsaAlgorithm(String algorithm) {
        return algorithm.equals("RSA1_5") || algorithm.equals("RSA-OAEP") || algorithm.equals("RSA-OAEP-256");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

