/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.utils.OAuth2Code;
import org.keycloak.services.managers.UserSessionCrossDCManager;
import org.keycloak.utils.LockObjectsForModification;

public class OAuth2CodeParser {
    private static final Logger logger = Logger.getLogger(OAuth2CodeParser.class);
    private static final Pattern DOT = Pattern.compile("\\.");

    public static String persistCode(KeycloakSession session, AuthenticatedClientSessionModel clientSession, OAuth2Code codeData) {
        SingleUseObjectProvider codeStore = (SingleUseObjectProvider)session.getProvider(SingleUseObjectProvider.class);
        String key = codeData.getId();
        if (key == null) {
            throw new IllegalStateException("ID not present in the data");
        }
        Map<String, String> serialized = codeData.serializeCode();
        codeStore.put(key, (long)clientSession.getUserSession().getRealm().getAccessCodeLifespan(), serialized);
        return key + "." + clientSession.getUserSession().getId() + "." + clientSession.getClient().getId();
    }

    public static ParseResult parseCode(KeycloakSession session, String code, RealmModel realm, EventBuilder event) {
        String codeUUID;
        ParseResult result = new ParseResult(code);
        String[] parsed = DOT.split(code, 3);
        if (parsed.length < 3) {
            logger.warn((Object)"Invalid format of the code");
            return result.illegalCode();
        }
        String userSessionId = parsed[1];
        String clientUUID = parsed[2];
        event.detail("code_id", userSessionId);
        event.session(userSessionId);
        try {
            codeUUID = parsed[0];
        }
        catch (IllegalArgumentException re) {
            logger.warn((Object)"Invalid format of the UUID in the code");
            return result.illegalCode();
        }
        UserSessionModel userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)session, () -> new UserSessionCrossDCManager(session).getUserSessionWithClient(realm, userSessionId, clientUUID));
        if (userSession == null && (userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)session, () -> session.sessions().getUserSession(realm, userSessionId))) == null) {
            return result.illegalCode();
        }
        result.clientSession = userSession.getAuthenticatedClientSessionByClient(clientUUID);
        SingleUseObjectProvider codeStore = (SingleUseObjectProvider)session.getProvider(SingleUseObjectProvider.class);
        Map codeData = codeStore.remove(codeUUID);
        if (codeData == null) {
            logger.warnf("Code '%s' already used for userSession '%s' and client '%s'.", (Object)codeUUID, (Object)userSessionId, (Object)clientUUID);
            return result.illegalCode();
        }
        logger.tracef("Successfully verified code '%s'. User session: '%s', client: '%s'", (Object)codeUUID, (Object)userSessionId, (Object)clientUUID);
        result.codeData = OAuth2Code.deserializeCode(codeData);
        int currentTime = Time.currentTime();
        if (currentTime > result.codeData.getExpiration()) {
            return result.expiredCode();
        }
        return result;
    }

    public static class ParseResult {
        private final String code;
        private OAuth2Code codeData;
        private AuthenticatedClientSessionModel clientSession;
        private boolean isIllegalCode = false;
        private boolean isExpiredCode = false;

        private ParseResult(String code, OAuth2Code codeData, AuthenticatedClientSessionModel clientSession) {
            this.code = code;
            this.codeData = codeData;
            this.clientSession = clientSession;
            this.isIllegalCode = false;
            this.isExpiredCode = false;
        }

        private ParseResult(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public OAuth2Code getCodeData() {
            return this.codeData;
        }

        public AuthenticatedClientSessionModel getClientSession() {
            return this.clientSession;
        }

        public boolean isIllegalCode() {
            return this.isIllegalCode;
        }

        public boolean isExpiredCode() {
            return this.isExpiredCode;
        }

        private ParseResult illegalCode() {
            this.isIllegalCode = true;
            return this;
        }

        private ParseResult expiredCode() {
            this.isExpiredCode = true;
            return this;
        }
    }
}

