/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.common.util.PemUtils;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.KeyStoreConfig;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.util.CertificateInfoHelper;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.JsonSerialization;

public class ClientAttributeCertificateResource {
    public static final String CERTIFICATE_PEM = "Certificate PEM";
    public static final String PUBLIC_KEY_PEM = "Public Key PEM";
    public static final String JSON_WEB_KEY_SET = "JSON Web Key Set";
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    protected ClientModel client;
    protected KeycloakSession session;
    protected AdminEventBuilder adminEvent;
    protected String attributePrefix;

    public ClientAttributeCertificateResource(RealmModel realm, AdminPermissionEvaluator auth, ClientModel client, KeycloakSession session, String attributePrefix, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.client = client;
        this.session = session;
        this.attributePrefix = attributePrefix;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public CertificateRepresentation getKeyInfo() {
        this.auth.clients().requireView(this.client);
        CertificateRepresentation info = CertificateInfoHelper.getCertificateFromClient(this.client, this.attributePrefix);
        return info;
    }

    @POST
    @NoCache
    @Path(value="generate")
    @Produces(value={"application/json"})
    public CertificateRepresentation generate() {
        this.auth.clients().requireConfigure(this.client);
        CertificateRepresentation info = KeycloakModelUtils.generateKeyPairCertificate((String)this.client.getClientId());
        CertificateInfoHelper.updateClientModelCertificateInfo(this.client, info, this.attributePrefix);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(info).success();
        return info;
    }

    @POST
    @Path(value="upload")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public CertificateRepresentation uploadJks(MultipartFormDataInput input) throws IOException {
        this.auth.clients().requireConfigure(this.client);
        try {
            CertificateRepresentation info = this.getCertFromRequest(input);
            CertificateInfoHelper.updateClientModelCertificateInfo(this.client, info, this.attributePrefix);
            this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(info).success();
            return info;
        }
        catch (IllegalStateException ise) {
            throw new ErrorResponseException("certificate-not-found", "Certificate or key with given alias not found in the keystore", Response.Status.BAD_REQUEST);
        }
    }

    @POST
    @Path(value="upload-certificate")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public CertificateRepresentation uploadJksCertificate(MultipartFormDataInput input) throws IOException {
        this.auth.clients().requireConfigure(this.client);
        try {
            CertificateRepresentation info = this.getCertFromRequest(input);
            info.setPrivateKey(null);
            CertificateInfoHelper.updateClientModelCertificateInfo(this.client, info, this.attributePrefix);
            this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(info).success();
            return info;
        }
        catch (IllegalStateException ise) {
            throw new ErrorResponseException("certificate-not-found", "Certificate or key with given alias not found in the keystore", Response.Status.BAD_REQUEST);
        }
    }

    private CertificateRepresentation getCertFromRequest(MultipartFormDataInput input) throws IOException {
        this.auth.clients().requireManage(this.client);
        CertificateRepresentation info = new CertificateRepresentation();
        Map uploadForm = input.getFormDataMap();
        List keystoreFormatPart = (List)uploadForm.get("keystoreFormat");
        if (keystoreFormatPart == null) {
            throw new BadRequestException();
        }
        String keystoreFormat = ((InputPart)keystoreFormatPart.get(0)).getBodyAsString();
        List inputParts = (List)uploadForm.get("file");
        if (keystoreFormat.equals(CERTIFICATE_PEM)) {
            String pem = StreamUtil.readString((InputStream)((InputStream)((InputPart)inputParts.get(0)).getBody(InputStream.class, null)));
            pem = PemUtils.removeBeginEnd((String)pem);
            KeycloakModelUtils.getCertificate((String)pem);
            info.setCertificate(pem);
            return info;
        }
        if (keystoreFormat.equals(PUBLIC_KEY_PEM)) {
            String pem = StreamUtil.readString((InputStream)((InputStream)((InputPart)inputParts.get(0)).getBody(InputStream.class, null)));
            KeycloakModelUtils.getPublicKey((String)pem);
            info.setPublicKey(pem);
            return info;
        }
        if (keystoreFormat.equals(JSON_WEB_KEY_SET)) {
            InputStream stream = (InputStream)((InputPart)inputParts.get(0)).getBody(InputStream.class, null);
            JSONWebKeySet keySet = (JSONWebKeySet)JsonSerialization.readValue((InputStream)stream, JSONWebKeySet.class);
            JWK publicKeyJwk = JWKSUtils.getKeyForUse((JSONWebKeySet)keySet, (JWK.Use)JWK.Use.SIG);
            if (publicKeyJwk == null) {
                throw new IllegalStateException("Certificate not found for use sig");
            }
            PublicKey publicKey = JWKParser.create((JWK)publicKeyJwk).toPublicKey();
            String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
            info.setPublicKey(publicKeyPem);
            info.setKid(publicKeyJwk.getKeyId());
            return info;
        }
        String keyAlias = ((InputPart)((List)uploadForm.get("keyAlias")).get(0)).getBodyAsString();
        List keyPasswordPart = (List)uploadForm.get("keyPassword");
        char[] keyPassword = keyPasswordPart != null ? ((InputPart)keyPasswordPart.get(0)).getBodyAsString().toCharArray() : null;
        List storePasswordPart = (List)uploadForm.get("storePassword");
        char[] storePassword = storePasswordPart != null ? ((InputPart)storePasswordPart.get(0)).getBodyAsString().toCharArray() : null;
        PrivateKey privateKey = null;
        X509Certificate certificate = null;
        try {
            KeyStore keyStore = null;
            keyStore = keystoreFormat.equals("JKS") ? KeyStore.getInstance("JKS") : KeyStore.getInstance(keystoreFormat, BouncyIntegration.PROVIDER);
            keyStore.load((InputStream)((InputPart)inputParts.get(0)).getBody(InputStream.class, null), storePassword);
            try {
                privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword);
            }
            catch (Exception exception) {
                // empty catch block
            }
            certificate = (X509Certificate)keyStore.getCertificate(keyAlias);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (privateKey != null) {
            String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
            info.setPrivateKey(privateKeyPem);
        }
        if (certificate != null) {
            String certPem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
            info.setCertificate(certPem);
        }
        return info;
    }

    @POST
    @NoCache
    @Path(value="/download")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/json"})
    public byte[] getKeystore(KeyStoreConfig config) {
        this.auth.clients().requireView(this.client);
        if (config.getFormat() != null && !config.getFormat().equals("JKS") && !config.getFormat().equals("PKCS12")) {
            throw new NotAcceptableException("Only support jks or pkcs12 format.");
        }
        CertificateRepresentation info = CertificateInfoHelper.getCertificateFromClient(this.client, this.attributePrefix);
        String privatePem = info.getPrivateKey();
        String certPem = info.getCertificate();
        if (privatePem == null && certPem == null) {
            throw new NotFoundException("keypair not generated for client");
        }
        if (privatePem != null && config.getKeyPassword() == null) {
            throw new ErrorResponseException("password-missing", "Need to specify a key password for jks download", Response.Status.BAD_REQUEST);
        }
        if (config.getStorePassword() == null) {
            throw new ErrorResponseException("password-missing", "Need to specify a store password for jks download", Response.Status.BAD_REQUEST);
        }
        byte[] rtn = this.getKeystore(config, privatePem, certPem);
        return rtn;
    }

    @POST
    @NoCache
    @Path(value="/generate-and-download")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/json"})
    public byte[] generateAndGetKeystore(KeyStoreConfig config) {
        this.auth.clients().requireConfigure(this.client);
        if (config.getFormat() != null && !config.getFormat().equals("JKS") && !config.getFormat().equals("PKCS12")) {
            throw new NotAcceptableException("Only support jks or pkcs12 format.");
        }
        if (config.getKeyPassword() == null) {
            throw new ErrorResponseException("password-missing", "Need to specify a key password for jks generation and download", Response.Status.BAD_REQUEST);
        }
        if (config.getStorePassword() == null) {
            throw new ErrorResponseException("password-missing", "Need to specify a store password for jks generation and download", Response.Status.BAD_REQUEST);
        }
        CertificateRepresentation info = KeycloakModelUtils.generateKeyPairCertificate((String)this.client.getClientId());
        byte[] rtn = this.getKeystore(config, info.getPrivateKey(), info.getCertificate());
        info.setPrivateKey(null);
        CertificateInfoHelper.updateClientModelCertificateInfo(this.client, info, this.attributePrefix);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(info).success();
        return rtn;
    }

    private byte[] getKeystore(KeyStoreConfig config, String privatePem, String certPem) {
        try {
            String format = config.getFormat();
            KeyStore keyStore = format.equals("JKS") ? KeyStore.getInstance("JKS") : KeyStore.getInstance(format, BouncyIntegration.PROVIDER);
            keyStore.load(null, null);
            String keyAlias = config.getKeyAlias();
            if (keyAlias == null) {
                keyAlias = this.client.getClientId();
            }
            if (privatePem != null) {
                PrivateKey privateKey = PemUtils.decodePrivateKey((String)privatePem);
                X509Certificate clientCert = PemUtils.decodeCertificate((String)certPem);
                Certificate[] chain = new Certificate[]{clientCert};
                keyStore.setKeyEntry(keyAlias, privateKey, config.getKeyPassword().trim().toCharArray(), chain);
            } else {
                X509Certificate clientCert = PemUtils.decodeCertificate((String)certPem);
                keyStore.setCertificateEntry(keyAlias, clientCert);
            }
            if (config.isRealmCertificate() == null || config.isRealmCertificate().booleanValue()) {
                KeyManager keys = this.session.keys();
                String kid = keys.getActiveRsaKey(this.realm).getKid();
                Certificate certificate = keys.getRsaCertificate(this.realm, kid);
                String certificateAlias = config.getRealmAlias();
                if (certificateAlias == null) {
                    certificateAlias = this.realm.getName();
                }
                keyStore.setCertificateEntry(certificateAlias, certificate);
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            keyStore.store(stream, config.getStorePassword().trim().toCharArray());
            stream.flush();
            stream.close();
            byte[] rtn = stream.toByteArray();
            return rtn;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

