/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ScopeMappedClientResource {
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;
    protected ScopeContainerModel scopeContainer;
    protected KeycloakSession session;
    protected ClientModel scopedClient;
    protected AdminEventBuilder adminEvent;

    public ScopeMappedClientResource(RealmModel realm, AdminPermissionEvaluator auth, ScopeContainerModel scopeContainer, KeycloakSession session, ClientModel scopedClient, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck managePermission, AdminPermissionEvaluator.RequirePermissionCheck viewPermission) {
        this.realm = realm;
        this.auth = auth;
        this.scopeContainer = scopeContainer;
        this.session = session;
        this.scopedClient = scopedClient;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_SCOPE_MAPPING);
        this.managePermission = managePermission;
        this.viewPermission = viewPermission;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getClientScopeMappings() {
        this.viewPermission.require();
        return KeycloakModelUtils.getClientScopeMappingsStream((ClientModel)this.scopedClient, (ScopeContainerModel)this.scopeContainer).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getAvailableClientScopeMappings() {
        this.viewPermission.require();
        return this.scopedClient.getRolesStream().filter(((Predicate<RoleModel>)arg_0 -> ((ScopeContainerModel)this.scopeContainer).hasDirectScope(arg_0)).negate()).filter(this.auth.roles()::canMapClientScope).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getCompositeClientScopeMappings(@QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.viewPermission.require();
        Function<RoleModel, RoleRepresentation> toBriefRepresentation = briefRepresentation ? ModelToRepresentation::toBriefRepresentation : ModelToRepresentation::toRepresentation;
        return this.scopedClient.getRolesStream().filter(arg_0 -> ((ScopeContainerModel)this.scopeContainer).hasScope(arg_0)).map(toBriefRepresentation);
    }

    @POST
    @Consumes(value={"application/json"})
    public void addClientScopeMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.scopedClient.getRole(role.getName());
            if (roleModel == null) {
                throw new NotFoundException("Role not found");
            }
            this.scopeContainer.addScopeMapping(roleModel);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public void deleteClientScopeMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (roles == null) {
            roles = KeycloakModelUtils.getClientScopeMappingsStream((ClientModel)this.scopedClient, (ScopeContainerModel)this.scopeContainer).peek(arg_0 -> ((ScopeContainerModel)this.scopeContainer).deleteScopeMapping(arg_0)).map(ModelToRepresentation::toBriefRepresentation).collect(Collectors.toList());
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.scopedClient.getRole(role.getName());
                if (roleModel == null) {
                    throw new NotFoundException("Role not found");
                }
                this.scopeContainer.deleteScopeMapping(roleModel);
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }
}

