/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.listener;

import java.util.Objects;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.impl.entries.CounterValue;

public class CounterEventImpl
implements CounterEvent {
    private final long oldValue;
    private final CounterState oldState;
    private final long newValue;
    private final CounterState newState;

    private CounterEventImpl(long oldValue, CounterState oldState, long newValue, CounterState newState) {
        this.oldValue = oldValue;
        this.oldState = Objects.requireNonNull(oldState);
        this.newValue = newValue;
        this.newState = Objects.requireNonNull(newState);
    }

    public static CounterEvent create(long oldValue, long newValue) {
        return new CounterEventImpl(oldValue, CounterState.VALID, newValue, CounterState.VALID);
    }

    public static CounterEvent create(CounterValue oldValue, CounterValue newValue) {
        if (oldValue == null) {
            return new CounterEventImpl(newValue.getValue(), newValue.getState(), newValue.getValue(), newValue.getState());
        }
        return new CounterEventImpl(oldValue.getValue(), oldValue.getState(), newValue.getValue(), newValue.getState());
    }

    public long getOldValue() {
        return this.oldValue;
    }

    public CounterState getOldState() {
        return this.oldState;
    }

    public long getNewValue() {
        return this.newValue;
    }

    public CounterState getNewState() {
        return this.newState;
    }

    public String toString() {
        return "CounterEventImpl{oldValue=" + this.oldValue + ", oldState=" + this.oldState + ", newValue=" + this.newValue + ", newState=" + this.newState + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterEventImpl that = (CounterEventImpl)o;
        return this.oldValue == that.oldValue && this.newValue == that.newValue && this.oldState == that.oldState && this.newState == that.newState;
    }

    public int hashCode() {
        int result = (int)(this.oldValue ^ this.oldValue >>> 32);
        result = 31 * result + this.oldState.hashCode();
        result = 31 * result + (int)(this.newValue ^ this.newValue >>> 32);
        result = 31 * result + this.newState.hashCode();
        return result;
    }
}

