/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.PermissionTicketEntity;
import org.keycloak.authorization.jpa.store.JPAAuthorizationStoreFactory;
import org.keycloak.authorization.jpa.store.PermissionTicketAdapter;
import org.keycloak.authorization.jpa.store.ResourceAdapter;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.jpa.store.ScopeAdapter;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.common.util.Time;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.utils.StreamsUtil;

public class JPAPermissionTicketStore
implements PermissionTicketStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAPermissionTicketStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public long count(ResourceServer resourceServer, Map<PermissionTicket.FilterOption, String> attributes) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(Long.class);
        Root root = querybuilder.from(PermissionTicketEntity.class);
        querybuilder.select((Selection)root.get("id"));
        List<Predicate> predicates = this.getPredicates(builder, (Root<PermissionTicketEntity>)root, resourceServer, attributes);
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        return StreamsUtil.closing((Stream)query.getResultStream()).count();
    }

    private List<Predicate> getPredicates(CriteriaBuilder builder, Root<PermissionTicketEntity> root, ResourceServer resourceServer, Map<PermissionTicket.FilterOption, String> attributes) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (resourceServer != null) {
            predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServer.getId()));
        }
        attributes.forEach((filterOption, value) -> {
            switch (filterOption) {
                case ID: 
                case OWNER: 
                case REQUESTER: {
                    predicates.add(builder.equal((Expression)root.get(filterOption.getName()), value));
                    break;
                }
                case SCOPE_ID: 
                case RESOURCE_ID: 
                case RESOURCE_NAME: 
                case POLICY_ID: {
                    String[] predicateValues = filterOption.getName().split("\\.");
                    predicates.add(root.join(predicateValues[0]).get(predicateValues[1]).in(new Object[]{value}));
                    break;
                }
                case SCOPE_IS_NULL: {
                    if (Boolean.parseBoolean(value)) {
                        predicates.add(builder.isNull((Expression)root.get("scope")));
                        break;
                    }
                    predicates.add(builder.isNotNull((Expression)root.get("scope")));
                    break;
                }
                case GRANTED: {
                    if (Boolean.parseBoolean(value)) {
                        predicates.add(builder.isNotNull((Expression)root.get("grantedTimestamp")));
                        break;
                    }
                    predicates.add(builder.isNull((Expression)root.get("grantedTimestamp")));
                    break;
                }
                case REQUESTER_IS_NULL: {
                    predicates.add(builder.isNull((Expression)root.get("requester")));
                    break;
                }
                case POLICY_IS_NOT_NULL: {
                    predicates.add(builder.isNotNull((Expression)root.get("policy")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported filter [" + filterOption + "]");
                }
            }
        });
        return predicates;
    }

    public PermissionTicket create(ResourceServer resourceServer, Resource resource, Scope scope, String requester) {
        PermissionTicketEntity entity = new PermissionTicketEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setResource(ResourceAdapter.toEntity(this.entityManager, resource));
        entity.setRequester(requester);
        entity.setCreatedTimestamp(Time.currentTimeMillis());
        if (scope != null) {
            entity.setScope(ScopeAdapter.toEntity(this.entityManager, scope));
        }
        entity.setOwner(entity.getResource().getOwner());
        entity.setResourceServer(ResourceServerAdapter.toEntity(this.entityManager, resourceServer));
        this.entityManager.persist((Object)entity);
        this.entityManager.flush();
        PermissionTicketAdapter model = new PermissionTicketAdapter(entity, this.entityManager, this.provider.getStoreFactory());
        return model;
    }

    public void delete(RealmModel realm, String id) {
        PermissionTicketEntity policy = (PermissionTicketEntity)this.entityManager.find(PermissionTicketEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (policy != null) {
            this.entityManager.remove((Object)policy);
        }
    }

    public PermissionTicket findById(RealmModel realm, ResourceServer resourceServer, String id) {
        if (id == null) {
            return null;
        }
        PermissionTicketEntity entity = (PermissionTicketEntity)this.entityManager.find(PermissionTicketEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new PermissionTicketAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public List<PermissionTicket> findByResource(ResourceServer resourceServer, Resource resource) {
        TypedQuery query = this.entityManager.createNamedQuery("findPermissionIdByResource", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("resourceId", (Object)resource.getId());
        query.setParameter("serverId", (Object)(resourceServer == null ? null : resourceServer.getId()));
        List result = query.getResultList();
        LinkedList<PermissionTicket> list = new LinkedList<PermissionTicket>();
        PermissionTicketStore ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        for (String id : result) {
            PermissionTicket ticket = ticketStore.findById(JPAAuthorizationStoreFactory.NULL_REALM, resourceServer, id);
            if (!Objects.nonNull(ticket)) continue;
            list.add(ticket);
        }
        return list;
    }

    public List<PermissionTicket> findByScope(ResourceServer resourceServer, Scope scope) {
        if (scope == null) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager.createNamedQuery("findPermissionIdByScope", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeId", (Object)scope.getId());
        query.setParameter("serverId", (Object)(resourceServer == null ? null : resourceServer.getId()));
        List result = query.getResultList();
        LinkedList<PermissionTicket> list = new LinkedList<PermissionTicket>();
        PermissionTicketStore ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        for (String id : result) {
            PermissionTicket ticket = ticketStore.findById(JPAAuthorizationStoreFactory.NULL_REALM, resourceServer, id);
            if (!Objects.nonNull(ticket)) continue;
            list.add(ticket);
        }
        return list;
    }

    public List<PermissionTicket> find(RealmModel realm, ResourceServer resourceServer, Map<PermissionTicket.FilterOption, String> attributes, Integer firstResult, Integer maxResult) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(PermissionTicketEntity.class);
        Root root = querybuilder.from(PermissionTicketEntity.class);
        querybuilder.select((Selection)root.get("id"));
        List<Predicate> predicates = this.getPredicates(builder, (Root<PermissionTicketEntity>)root, resourceServer, attributes);
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        List result = PaginationUtils.paginateQuery(query, firstResult, maxResult).getResultList();
        LinkedList<PermissionTicket> list = new LinkedList<PermissionTicket>();
        PermissionTicketStore ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        for (String id : result) {
            PermissionTicket ticket = ticketStore.findById(realm, resourceServer, id);
            if (!Objects.nonNull(ticket)) continue;
            list.add(ticket);
        }
        return list;
    }

    public List<PermissionTicket> findGranted(ResourceServer resourceServer, String userId) {
        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
        filters.put(PermissionTicket.FilterOption.GRANTED, Boolean.TRUE.toString());
        filters.put(PermissionTicket.FilterOption.REQUESTER, userId);
        return this.find(JPAAuthorizationStoreFactory.NULL_REALM, resourceServer, filters, null, null);
    }

    public List<PermissionTicket> findGranted(ResourceServer resourceServer, String resourceName, String userId) {
        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
        filters.put(PermissionTicket.FilterOption.RESOURCE_NAME, resourceName);
        filters.put(PermissionTicket.FilterOption.GRANTED, Boolean.TRUE.toString());
        filters.put(PermissionTicket.FilterOption.REQUESTER, userId);
        return this.find(JPAAuthorizationStoreFactory.NULL_REALM, resourceServer, filters, null, null);
    }

    public List<Resource> findGrantedResources(RealmModel realm, String requester, String name, Integer first, Integer max) {
        TypedQuery query = name == null ? this.entityManager.createNamedQuery("findGrantedResources", String.class) : this.entityManager.createNamedQuery("findGrantedResourcesByName", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("requester", (Object)requester);
        if (name != null) {
            query.setParameter("resourceName", (Object)("%" + name.toLowerCase() + "%"));
        }
        List result = PaginationUtils.paginateQuery(query, first, max).getResultList();
        LinkedList<Resource> list = new LinkedList<Resource>();
        ResourceStore resourceStore = this.provider.getStoreFactory().getResourceStore();
        for (String id : result) {
            Resource resource = resourceStore.findById(realm, null, id);
            if (!Objects.nonNull(resource)) continue;
            list.add(resource);
        }
        return list;
    }

    public List<Resource> findGrantedOwnerResources(RealmModel realm, String owner, Integer firstResult, Integer maxResults) {
        TypedQuery query = this.entityManager.createNamedQuery("findGrantedOwnerResources", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("owner", (Object)owner);
        List result = PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultList();
        LinkedList<Resource> list = new LinkedList<Resource>();
        ResourceStore resourceStore = this.provider.getStoreFactory().getResourceStore();
        for (String id : result) {
            Resource resource = resourceStore.findById(realm, null, id);
            if (!Objects.nonNull(resource)) continue;
            list.add(resource);
        }
        return list;
    }
}

