/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.jpa;

import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventStoreProviderFactory;
import org.keycloak.events.jpa.JpaEventStoreProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class JpaEventStoreProviderFactory
implements EventStoreProviderFactory {
    public static final String ID = "jpa";
    private int maxDetailLength;

    public EventStoreProvider create(KeycloakSession session) {
        JpaConnectionProvider connection = (JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class);
        return new JpaEventStoreProvider(session, connection.getEntityManager(), this.maxDetailLength);
    }

    public void init(Config.Scope config) {
        this.maxDetailLength = config.getInt("max-detail-length", Integer.valueOf(0));
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

