/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Nationalized;
import org.keycloak.models.jpa.entities.ClientScopeAttributeEntity;
import org.keycloak.models.jpa.entities.ProtocolMapperEntity;

@Entity
@Table(name="CLIENT_SCOPE", uniqueConstraints={@UniqueConstraint(columnNames={"REALM_ID", "NAME"})})
@NamedQueries(value={@NamedQuery(name="getClientScopeIds", query="select scope.id from ClientScopeEntity scope where scope.realmId = :realm")})
public class ClientScopeEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Column(name="NAME")
    private String name;
    @Nationalized
    @Column(name="DESCRIPTION")
    private String description;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="clientScope")
    Collection<ProtocolMapperEntity> protocolMappers;
    @Column(name="REALM_ID")
    protected String realmId;
    @Column(name="PROTOCOL")
    private String protocol;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="clientScope")
    protected Collection<ClientScopeAttributeEntity> attributes;
    @ElementCollection
    @Column(name="ROLE_ID")
    @CollectionTable(name="CLIENT_SCOPE_ROLE_MAPPING", joinColumns={@JoinColumn(name="SCOPE_ID")})
    private Set<String> scopeMappingIds = new HashSet<String>();

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection<ProtocolMapperEntity> getProtocolMappers() {
        if (this.protocolMappers == null) {
            this.protocolMappers = new LinkedList<ProtocolMapperEntity>();
        }
        return this.protocolMappers;
    }

    public void setProtocolMappers(Collection<ProtocolMapperEntity> protocolMappers) {
        this.protocolMappers = protocolMappers;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Collection<ClientScopeAttributeEntity> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedList<ClientScopeAttributeEntity>();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<ClientScopeAttributeEntity> attributes) {
        this.attributes = attributes;
    }

    public Set<String> getScopeMappingIds() {
        return this.scopeMappingIds;
    }

    public void setScopeMappingIds(Set<String> scopeMappingIds) {
        this.scopeMappingIds = scopeMappingIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ClientScopeEntity)) {
            return false;
        }
        ClientScopeEntity that = (ClientScopeEntity)o;
        return this.id.equals(that.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

