/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.recording;

import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

final class PropertyUtils {
    static final ConcurrentMap<Class<?>, Property[]> CACHE = new ConcurrentHashMap();
    private static final Function<Class<?>, Property[]> FUNCTION = new Function<Class<?>, Property[]>(){

        @Override
        public Property[] apply(Class<?> type) {
            ArrayList<Property> ret = new ArrayList<Property>();
            Method[] methods = type.getMethods();
            HashMap<CallSite, Method> getters = new HashMap<CallSite, Method>();
            HashMap<CallSite, Method> setters = new HashMap<CallSite, Method>();
            for (Method i : methods) {
                String name;
                if (i.getName().startsWith("get") && i.getName().length() > 3 && i.getParameterCount() == 0 && i.getReturnType() != Void.TYPE) {
                    name = Character.toLowerCase(i.getName().charAt(3)) + i.getName().substring(4);
                    Method existingGetter = (Method)getters.get(name);
                    if (existingGetter != null && !existingGetter.getReturnType().isAssignableFrom(i.getReturnType())) continue;
                    getters.put((CallSite)((Object)name), i);
                    continue;
                }
                if (i.getName().startsWith("is") && i.getName().length() > 3 && i.getParameterCount() == 0 && (i.getReturnType() == Boolean.TYPE || i.getReturnType() == Boolean.class)) {
                    name = Character.toLowerCase(i.getName().charAt(2)) + i.getName().substring(3);
                    getters.put((CallSite)((Object)name), i);
                    continue;
                }
                if (!i.getName().startsWith("set") || i.getName().length() <= 3 || i.getParameterCount() != 1) continue;
                name = Character.toLowerCase(i.getName().charAt(3)) + i.getName().substring(4);
                setters.put((CallSite)((Object)name), i);
            }
            HashSet names = new HashSet(getters.keySet());
            names.addAll(setters.keySet());
            for (String i : names) {
                Class<?> st;
                Method get = (Method)getters.get(i);
                Method set = (Method)setters.get(i);
                if (get == null) {
                    ret.add(new Property(i, get, set, set.getParameterTypes()[0]));
                    continue;
                }
                if (set == null) {
                    ret.add(new Property(i, get, set, get.getReturnType()));
                    continue;
                }
                Class<?> gt = get.getReturnType();
                if (gt == (st = set.getParameterTypes()[0])) {
                    ret.add(new Property(i, get, set, gt));
                    continue;
                }
                if (gt.isAssignableFrom(st)) {
                    ret.add(new Property(i, get, set, gt));
                    continue;
                }
                if (!st.isAssignableFrom(gt)) continue;
                ret.add(new Property(i, get, set, st));
            }
            return ret.toArray(new Property[ret.size()]);
        }
    };

    PropertyUtils() {
    }

    public static Property[] getPropertyDescriptors(Object param) {
        return CACHE.computeIfAbsent(param.getClass(), FUNCTION);
    }

    public static class Property {
        final String name;
        final Method readMethod;
        final Method writeMethod;
        final Class<?> propertyType;

        public Property(String name, Method readMethod, Method writeMethod, Class<?> propertyType) {
            this.name = name;
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
            this.propertyType = propertyType;
        }

        public String getName() {
            return this.name;
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public Class<?> getPropertyType() {
            return this.propertyType;
        }

        public Class<?> getDeclaringClass() {
            return this.readMethod != null ? this.readMethod.getDeclaringClass() : this.writeMethod.getDeclaringClass();
        }

        public Object read(Object target) {
            try {
                return this.readMethod.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void write(Object target, Object value) {
            try {
                this.writeMethod.invoke(target, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

