/** SNOWPACK INJECT STYLE: @patternfly/react-styles/css/components/Page/page.css */
function __snowpack__injectStyle(css) {
  const headEl = document.head || document.getElementsByTagName('head')[0];
  const styleEl = document.createElement('style');
  styleEl.type = 'text/css';
  if (styleEl.styleSheet) {
    styleEl.styleSheet.cssText = css;
  } else {
    styleEl.appendChild(document.createTextNode(css));
  }
  headEl.appendChild(styleEl);
}
__snowpack__injectStyle(".pf-c-page__sidebar.pf-m-light {\n  --pf-global--Color--100: var(--pf-global--Color--dark-100);\n  --pf-global--Color--200: var(--pf-global--Color--dark-200);\n  --pf-global--BorderColor--100: var(--pf-global--BorderColor--dark-100);\n  --pf-global--primary-color--100: var(--pf-global--primary-color--dark-100);\n  --pf-global--link--Color: var(--pf-global--link--Color--dark);\n  --pf-global--link--Color--hover: var(--pf-global--link--Color--dark--hover);\n  --pf-global--BackgroundColor--100: var(--pf-global--BackgroundColor--light-100);\n}\n\n.pf-c-page__main-section[class*=pf-m-dark-], .pf-c-page__sidebar-body.pf-m-menu .pf-c-context-selector, .pf-c-page__header {\n  --pf-global--Color--100: var(--pf-global--Color--light-100);\n  --pf-global--Color--200: var(--pf-global--Color--light-200);\n  --pf-global--BorderColor--100: var(--pf-global--BorderColor--light-100);\n  --pf-global--primary-color--100: var(--pf-global--primary-color--light-100);\n  --pf-global--link--Color: var(--pf-global--link--Color--light);\n  --pf-global--link--Color--hover: var(--pf-global--link--Color--light);\n  --pf-global--BackgroundColor--100: var(--pf-global--BackgroundColor--dark-100);\n}\n.pf-c-page__main-section[class*=pf-m-dark-] .pf-c-card, .pf-c-page__sidebar-body.pf-m-menu .pf-c-context-selector .pf-c-card, .pf-c-page__header .pf-c-card {\n  --pf-c-card--BackgroundColor: var(--pf-global--BackgroundColor--dark-transparent-200);\n}\n.pf-c-page__main-section[class*=pf-m-dark-] .pf-c-button, .pf-c-page__sidebar-body.pf-m-menu .pf-c-context-selector .pf-c-button, .pf-c-page__header .pf-c-button {\n  --pf-c-button--m-primary--Color: var(--pf-global--primary-color--dark-100);\n  --pf-c-button--m-primary--hover--Color: var(--pf-global--primary-color--dark-100);\n  --pf-c-button--m-primary--focus--Color: var(--pf-global--primary-color--dark-100);\n  --pf-c-button--m-primary--active--Color: var(--pf-global--primary-color--dark-100);\n  --pf-c-button--m-primary--BackgroundColor: var(--pf-global--BackgroundColor--light-100);\n  --pf-c-button--m-primary--hover--BackgroundColor: var(--pf-global--BackgroundColor--light-300);\n  --pf-c-button--m-primary--focus--BackgroundColor: var(--pf-global--BackgroundColor--light-300);\n  --pf-c-button--m-primary--active--BackgroundColor: var(--pf-global--BackgroundColor--light-300);\n  --pf-c-button--m-secondary--Color: var(--pf-global--Color--light-100);\n  --pf-c-button--m-secondary--hover--Color: var(--pf-global--Color--light-100);\n  --pf-c-button--m-secondary--focus--Color: var(--pf-global--Color--light-100);\n  --pf-c-button--m-secondary--active--Color: var(--pf-global--Color--light-100);\n  --pf-c-button--m-secondary--BorderColor: var(--pf-global--Color--light-100);\n  --pf-c-button--m-secondary--hover--BorderColor: var(--pf-global--Color--light-100);\n  --pf-c-button--m-secondary--focus--BorderColor: var(--pf-global--Color--light-100);\n  --pf-c-button--m-secondary--active--BorderColor: var(--pf-global--Color--light-100);\n}\n\n.pf-c-page__header-tools-item, .pf-c-page__header-tools-group {\n  --pf-hidden-visible--visible--Visibility: visible;\n  --pf-hidden-visible--hidden--Display: none;\n  --pf-hidden-visible--hidden--Visibility: hidden;\n  --pf-hidden-visible--Display: var(--pf-hidden-visible--visible--Display);\n  --pf-hidden-visible--Visibility: var(--pf-hidden-visible--visible--Visibility);\n  display: var(--pf-hidden-visible--Display);\n  visibility: var(--pf-hidden-visible--Visibility);\n}\n.pf-m-hidden.pf-c-page__header-tools-item, .pf-m-hidden.pf-c-page__header-tools-group {\n  --pf-hidden-visible--Display: var(--pf-hidden-visible--hidden--Display);\n  --pf-hidden-visible--Visibility: var(--pf-hidden-visible--hidden--Visibility);\n}\n@media screen and (min-width: 576px) {\n  .pf-m-hidden-on-sm.pf-c-page__header-tools-item, .pf-m-hidden-on-sm.pf-c-page__header-tools-group {\n    --pf-hidden-visible--Display: var(--pf-hidden-visible--hidden--Display);\n    --pf-hidden-visible--Visibility: var(--pf-hidden-visible--hidden--Visibility);\n  }\n  .pf-m-visible-on-sm.pf-c-page__header-tools-item, .pf-m-visible-on-sm.pf-c-page__header-tools-group {\n    --pf-hidden-visible--Display: var(--pf-hidden-visible--visible--Display);\n    --pf-hidden-visible--Visibility: var(--pf-hidden-visible--visible--Visibility);\n  }\n}\n@media screen and (min-width: 768px) {\n  .pf-m-hidden-on-md.pf-c-page__header-tools-item, .pf-m-hidden-on-md.pf-c-page__header-tools-group {\n    --pf-hidden-visible--Display: var(--pf-hidden-visible--hidden--Display);\n    --pf-hidden-visible--Visibility: var(--pf-hidden-visible--hidden--Visibility);\n  }\n  .pf-m-visible-on-md.pf-c-page__header-tools-item, .pf-m-visible-on-md.pf-c-page__header-tools-group {\n    --pf-hidden-visible--Display: var(--pf-hidden-visible--visible--Display);\n    --pf-hidden-visible--Visibility: var(--pf-hidden-visible--visible--Visibility);\n  }\n}\n@media screen and (min-width: 992px) {\n  .pf-m-hidden-on-lg.pf-c-page__header-tools-item, .pf-m-hidden-on-lg.pf-c-page__header-tools-group {\n    --pf-hidden-visible--Display: var(--pf-hidden-visible--hidden--Display);\n    --pf-hidden-visible--Visibility: var(--pf-hidden-visible--hidden--Visibility);\n  }\n  .pf-m-visible-on-lg.pf-c-page__header-tools-item, .pf-m-visible-on-lg.pf-c-page__header-tools-group {\n    --pf-hidden-visible--Display: var(--pf-hidden-visible--visible--Display);\n    --pf-hidden-visible--Visibility: var(--pf-hidden-visible--visible--Visibility);\n  }\n}\n@media screen and (min-width: 1200px) {\n  .pf-m-hidden-on-xl.pf-c-page__header-tools-item, .pf-m-hidden-on-xl.pf-c-page__header-tools-group {\n    --pf-hidden-visible--Display: var(--pf-hidden-visible--hidden--Display);\n    --pf-hidden-visible--Visibility: var(--pf-hidden-visible--hidden--Visibility);\n  }\n  .pf-m-visible-on-xl.pf-c-page__header-tools-item, .pf-m-visible-on-xl.pf-c-page__header-tools-group {\n    --pf-hidden-visible--Display: var(--pf-hidden-visible--visible--Display);\n    --pf-hidden-visible--Visibility: var(--pf-hidden-visible--visible--Visibility);\n  }\n}\n@media screen and (min-width: 1450px) {\n  .pf-m-hidden-on-2xl.pf-c-page__header-tools-item, .pf-m-hidden-on-2xl.pf-c-page__header-tools-group {\n    --pf-hidden-visible--Display: var(--pf-hidden-visible--hidden--Display);\n    --pf-hidden-visible--Visibility: var(--pf-hidden-visible--hidden--Visibility);\n  }\n  .pf-m-visible-on-2xl.pf-c-page__header-tools-item, .pf-m-visible-on-2xl.pf-c-page__header-tools-group {\n    --pf-hidden-visible--Display: var(--pf-hidden-visible--visible--Display);\n    --pf-hidden-visible--Visibility: var(--pf-hidden-visible--visible--Visibility);\n  }\n}\n\n.pf-c-page {\n  --pf-c-page--BackgroundColor: var(--pf-global--BackgroundColor--light-300);\n  --pf-c-page__header--BackgroundColor: var(--pf-global--BackgroundColor--dark-100);\n  --pf-c-page__header--ZIndex: var(--pf-global--ZIndex--md);\n  --pf-c-page__header--MinHeight: 4.75rem;\n  --pf-c-page__header-brand--PaddingLeft: var(--pf-global--spacer--md);\n  --pf-c-page__header-brand--xl--PaddingRight: var(--pf-global--spacer--xl);\n  --pf-c-page__header-brand--xl--PaddingLeft: var(--pf-global--spacer--lg);\n  --pf-c-page__header-sidebar-toggle__c-button--PaddingTop: var(--pf-global--spacer--sm);\n  --pf-c-page__header-sidebar-toggle__c-button--PaddingRight: var(--pf-global--spacer--sm);\n  --pf-c-page__header-sidebar-toggle__c-button--PaddingBottom: var(--pf-global--spacer--sm);\n  --pf-c-page__header-sidebar-toggle__c-button--PaddingLeft: var(--pf-global--spacer--sm);\n  --pf-c-page__header-sidebar-toggle__c-button--MarginRight: var(--pf-global--spacer--md);\n  --pf-c-page__header-sidebar-toggle__c-button--MarginLeft: calc(var(--pf-c-page__header-sidebar-toggle__c-button--PaddingLeft) * -1);\n  --pf-c-page__header-sidebar-toggle__c-button--FontSize: var(--pf-global--FontSize--2xl);\n  --pf-c-page__header-brand-link--c-brand--MaxHeight: 3.75rem;\n  --pf-c-page__header-nav--BackgroundColor: var(--pf-global--BackgroundColor--dark-300);\n  --pf-c-page__header-nav--xl--BackgroundColor: transparent;\n  --pf-c-page__header-nav--xl--PaddingRight: var(--pf-global--spacer--xl);\n  --pf-c-page__header-nav--xl--PaddingLeft: var(--pf-global--spacer--xl);\n  --pf-c-page__header-tools--MarginRight: var(--pf-global--spacer--md);\n  --pf-c-page__header-tools--xl--MarginRight: var(--pf-global--spacer--lg);\n  --pf-c-page__header-tools--c-avatar--MarginLeft: var(--pf-global--spacer--md);\n  --pf-c-page__header-tools-group--MarginLeft: var(--pf-global--spacer--xl);\n  --pf-c-page__header-tools-group--Display: flex;\n  --pf-c-page__header-tools-item--Display: block;\n  --pf-c-page__header-tools-item--c-notification-badge--hover--BackgroundColor: var(--pf-global--BackgroundColor--dark-200);\n  --pf-c-page__header-tools--c-button--notification-badge--m-unread--after--BackgroundColor: var(--pf-global--primary-color--200);\n  --pf-c-page__header-tools--c-button--notification-badge--m-attention--after--BackgroundColor: var(--pf-global--danger-color--200);\n  --pf-c-page__header-tools--c-button--m-selected--notification-badge--m-unread--after--BackgroundColor: var(--pf-global--primary-color--200);\n  --pf-c-page__header-tools--c-button--m-selected--notification-badge--m-attention--after--BackgroundColor: var(--pf-global--danger-color--200);\n  --pf-c-page__header-tools--c-button--m-selected--before--Width: auto;\n  --pf-c-page__header-tools--c-button--m-selected--before--Height: auto;\n  --pf-c-page__header-tools--c-button--m-selected--before--BackgroundColor: var(--pf-global--BackgroundColor--dark-200);\n  --pf-c-page__header-tools--c-button--m-selected--before--BorderRadius: var(--pf-global--BorderRadius--sm);\n  --pf-c-page__header-tools--c-button--m-selected--c-notification-badge--m-unread--after--BorderColor: transparent;\n  --pf-c-page__sidebar--ZIndex: var(--pf-global--ZIndex--sm);\n  --pf-c-page__sidebar--Width: 18.125rem;\n  --pf-c-page__sidebar--BackgroundColor: var(--pf-global--BackgroundColor--dark-300);\n  --pf-c-page__sidebar--m-light--BackgroundColor: var(--pf-global--BackgroundColor--light-100);\n  --pf-c-page__sidebar--BoxShadow: var(--pf-global--BoxShadow--lg-right);\n  --pf-c-page__sidebar--Transition: var(--pf-global--Transition);\n  --pf-c-page__sidebar--TranslateX: -100%;\n  --pf-c-page__sidebar--TranslateZ: 0;\n  --pf-c-page__sidebar--m-expanded--TranslateX: 0;\n  --pf-c-page__sidebar--xl--TranslateX: 0;\n  --pf-c-page__sidebar-body--PaddingTop: var(--pf-global--spacer--sm);\n  --pf-c-page__sidebar-body--PaddingBottom: var(--pf-global--spacer--md);\n  --pf-c-page__sidebar-body--m-menu--PaddingTop: 0;\n  --pf-c-page__sidebar-body--m-menu--PaddingBottom: 0;\n  --pf-c-page__sidebar-body--m-menu--BorderTopColor: var(--pf-global--BackgroundColor--dark-200);\n  --pf-c-page__sidebar-body--m-menu--BorderTopWidth: var(--pf-global--BorderWidth--sm);\n  --pf-c-page__sidebar-body--m-menu--c-context-selector--BorderBottomColor: var(--pf-global--BackgroundColor--dark-200);\n  --pf-c-page__main--ZIndex: var(--pf-global--ZIndex--xs);\n  --pf-c-page__main-section--PaddingTop: var(--pf-global--spacer--md);\n  --pf-c-page__main-section--PaddingRight: var(--pf-global--spacer--md);\n  --pf-c-page__main-section--PaddingBottom: var(--pf-global--spacer--md);\n  --pf-c-page__main-section--PaddingLeft: var(--pf-global--spacer--md);\n  --pf-c-page__main-section--xl--PaddingTop: var(--pf-global--spacer--lg);\n  --pf-c-page__main-section--xl--PaddingRight: var(--pf-global--spacer--lg);\n  --pf-c-page__main-section--xl--PaddingBottom: var(--pf-global--spacer--lg);\n  --pf-c-page__main-section--xl--PaddingLeft: var(--pf-global--spacer--lg);\n  --pf-c-page__main-breadcrumb--main-section--PaddingTop: var(--pf-global--spacer--md);\n  --pf-c-page__main-section--BackgroundColor: var(--pf-global--BackgroundColor--light-300);\n  --pf-c-page__main-section--m-light--BackgroundColor: var(--pf-global--BackgroundColor--light-100);\n  --pf-c-page__main-section--m-light-100--BackgroundColor: var(--pf-global--BackgroundColor--150);\n  --pf-c-page__main-section--m-dark-100--BackgroundColor: var(--pf-global--BackgroundColor--dark-transparent-100);\n  --pf-c-page__main-section--m-dark-200--BackgroundColor: var(--pf-global--BackgroundColor--dark-transparent-200);\n  --pf-c-page__main-breadcrumb--page__main-tabs--PaddingTop: var(--pf-global--spacer--md);\n  --pf-c-page__main-nav--page__main-tabs--PaddingTop: var(--pf-global--spacer--md);\n  --pf-c-page--section--m-limit-width--MaxWidth: calc(125rem - var(--pf-c-page__sidebar--Width));\n  --pf-c-page--section--m-sticky-top--ZIndex: var(--pf-global--ZIndex--md);\n  --pf-c-page--section--m-sticky-top--BoxShadow: var(--pf-global--BoxShadow--sm-bottom);\n  --pf-c-page--section--m-sticky-bottom--ZIndex: var(--pf-global--ZIndex--md);\n  --pf-c-page--section--m-sticky-bottom--BoxShadow: var(--pf-global--BoxShadow--sm-top);\n  --pf-c-page--section--m-shadow-bottom--BoxShadow: var(--pf-global--BoxShadow--sm-bottom);\n  --pf-c-page--section--m-shadow-bottom--ZIndex: var(--pf-global--ZIndex--xs);\n  --pf-c-page--section--m-shadow-top--BoxShadow: var(--pf-global--BoxShadow--sm-top);\n  --pf-c-page--section--m-shadow-top--ZIndex: var(--pf-global--ZIndex--xs);\n  --pf-c-page__main-nav--BackgroundColor: var(--pf-global--BackgroundColor--light-100);\n  --pf-c-page__main-nav--PaddingTop: var(--pf-global--spacer--md);\n  --pf-c-page__main-nav--PaddingRight: 0;\n  --pf-c-page__main-nav--PaddingLeft: 0;\n  --pf-c-page__main-nav--m-sticky-top--PaddingBottom: var(--pf-global--spacer--md);\n  --pf-c-page__main-nav--xl--PaddingRight: var(--pf-global--spacer--sm);\n  --pf-c-page__main-nav--xl--PaddingLeft: var(--pf-global--spacer--sm);\n  --pf-c-page__main-subnav--BackgroundColor: var(--pf-global--BackgroundColor--dark-300);\n  --pf-c-page__main-subnav--BorderTopWidth: var(--pf-global--BorderWidth--sm);\n  --pf-c-page__main-subnav--BorderTopColor: var(--pf-global--palette--black-800);\n  --pf-c-page__main-subnav--BorderLeftWidth: 0;\n  --pf-c-page__main-subnav--BorderLeftColor: var(--pf-global--palette--black-800);\n  --pf-c-page__sidebar--main__main-subnav--BorderLeftWidth: var(--pf-global--BorderWidth--sm);\n  --pf-c-page__sidebar--m-collapsed--main__main-subnav--BorderLeftWidth: 0;\n  --pf-c-page__main-breadcrumb--BackgroundColor: var(--pf-global--BackgroundColor--light-100);\n  --pf-c-page__main-breadcrumb--PaddingTop: var(--pf-global--spacer--md);\n  --pf-c-page__main-breadcrumb--PaddingRight: var(--pf-global--spacer--md);\n  --pf-c-page__main-breadcrumb--PaddingBottom: 0;\n  --pf-c-page__main-breadcrumb--PaddingLeft: var(--pf-global--spacer--md);\n  --pf-c-page__main-breadcrumb--m-sticky-top--PaddingBottom: var(--pf-global--spacer--md);\n  --pf-c-page__main-breadcrumb--xl--PaddingRight: var(--pf-global--spacer--lg);\n  --pf-c-page__main-breadcrumb--xl--PaddingLeft: var(--pf-global--spacer--lg);\n  --pf-c-page__main-tabs--PaddingTop: 0;\n  --pf-c-page__main-tabs--PaddingRight: 0;\n  --pf-c-page__main-tabs--PaddingBottom: 0;\n  --pf-c-page__main-tabs--PaddingLeft: 0;\n  --pf-c-page__main-tabs--BackgroundColor: var(--pf-global--BackgroundColor--light-100);\n  --pf-c-page__main-wizard--BackgroundColor: var(--pf-global--BackgroundColor--light-100);\n  --pf-c-page__main-wizard--BorderTopColor: var(--pf-global--BorderColor--100);\n  --pf-c-page__main-wizard--BorderTopWidth: var(--pf-global--BorderWidth--sm);\n  --pf-c-page__main-wizard--m-light-200--BackgroundColor: var(--pf-global--BackgroundColor--200);\n  display: grid;\n  height: 100%;\n  grid-template-columns: 1fr;\n  grid-template-rows: max-content 1fr;\n  grid-template-areas: \"header\" \"main\";\n  background-color: var(--pf-c-page--BackgroundColor);\n}\n@media (min-width: 1200px) {\n  .pf-c-page {\n    --pf-c-page__header-brand--PaddingLeft: var(--pf-c-page__header-brand--xl--PaddingLeft);\n  }\n}\n@media screen and (min-width: 1200px) {\n  .pf-c-page {\n    --pf-c-page__header-nav--BackgroundColor: var(--pf-c-page__header-nav--xl--BackgroundColor);\n    --pf-c-page__header-nav--PaddingRight: var(--pf-c-page__header-nav--xl--PaddingRight);\n    --pf-c-page__header-nav--PaddingLeft: var(--pf-c-page__header-nav--xl--PaddingLeft);\n  }\n}\n@media screen and (min-width: 1200px) {\n  .pf-c-page {\n    --pf-c-page__header-tools--MarginRight: var(--pf-c-page__header-tools--xl--MarginRight);\n  }\n}\n@media screen and (min-width: 1200px) {\n  .pf-c-page {\n    --pf-c-page__sidebar--TranslateX: var(--pf-c-page__sidebar--xl--TranslateX);\n  }\n}\n@media screen and (min-width: 1200px) {\n  .pf-c-page {\n    --pf-c-page__main-section--PaddingTop: var(--pf-c-page__main-section--xl--PaddingTop);\n    --pf-c-page__main-section--PaddingRight: var(--pf-c-page__main-section--xl--PaddingRight);\n    --pf-c-page__main-section--PaddingBottom: var(--pf-c-page__main-section--xl--PaddingBottom);\n    --pf-c-page__main-section--PaddingLeft: var(--pf-c-page__main-section--xl--PaddingLeft);\n  }\n}\n@media screen and (min-width: 1200px) {\n  .pf-c-page {\n    --pf-c-page__main-nav--PaddingRight: var(--pf-c-page__main-nav--xl--PaddingRight);\n    --pf-c-page__main-nav--PaddingLeft: var(--pf-c-page__main-nav--xl--PaddingLeft);\n  }\n}\n@media screen and (min-width: 1200px) {\n  .pf-c-page {\n    --pf-c-page__main-breadcrumb--PaddingRight: var(--pf-c-page__main-breadcrumb--xl--PaddingRight);\n    --pf-c-page__main-breadcrumb--PaddingLeft: var(--pf-c-page__main-breadcrumb--xl--PaddingLeft);\n  }\n}\n@media (min-width: 1200px) {\n  .pf-c-page {\n    grid-template-columns: max-content 1fr;\n    grid-template-areas: \"header header\" \"nav main\";\n  }\n}\n\n.pf-c-page__header,\n.pf-c-page > .pf-c-masthead {\n  grid-area: header;\n  z-index: var(--pf-c-page__header--ZIndex);\n}\n\n.pf-c-page__header {\n  color: var(--pf-global--Color--100);\n  grid-template-columns: auto auto;\n  display: grid;\n  align-items: center;\n  min-width: 0;\n  min-height: var(--pf-c-page__header--MinHeight);\n  background-color: var(--pf-c-page__header--BackgroundColor);\n}\n.pf-c-page__header > * {\n  display: flex;\n  align-items: center;\n}\n@media screen and (min-width: 992px) {\n  .pf-c-page__header {\n    grid-template-columns: auto 1fr auto;\n  }\n}\n.pf-c-page__header .pf-c-masthead {\n  grid-column: span 2;\n  align-self: stretch;\n}\n\n.pf-c-page__header-brand {\n  grid-column: 1/2;\n  padding-left: var(--pf-c-page__header-brand--PaddingLeft);\n}\n@media (min-width: 1200px) {\n  .pf-c-page__header-brand {\n    padding-right: var(--pf-c-page__header-brand--xl--PaddingRight);\n  }\n}\n\n.pf-c-page__header-brand-link {\n  display: flex;\n  flex: 1;\n  align-items: center;\n}\n.pf-c-page__header-brand-link .pf-c-brand {\n  max-height: var(--pf-c-page__header-brand-link--c-brand--MaxHeight);\n}\n\n.pf-c-page__header-brand-toggle .pf-c-button {\n  padding: var(--pf-c-page__header-sidebar-toggle__c-button--PaddingTop) var(--pf-c-page__header-sidebar-toggle__c-button--PaddingRight) var(--pf-c-page__header-sidebar-toggle__c-button--PaddingBottom) var(--pf-c-page__header-sidebar-toggle__c-button--PaddingLeft);\n  margin-right: var(--pf-c-page__header-sidebar-toggle__c-button--MarginRight);\n  margin-left: var(--pf-c-page__header-sidebar-toggle__c-button--MarginLeft);\n  font-size: var(--pf-c-page__header-sidebar-toggle__c-button--FontSize);\n  line-height: 1;\n}\n\n.pf-c-page__header-nav {\n  align-self: stretch;\n  min-width: 0;\n  padding-right: var(--pf-c-page__header-nav--PaddingRight);\n  padding-left: var(--pf-c-page__header-nav--PaddingLeft);\n  background-color: var(--pf-c-page__header-nav--BackgroundColor);\n  grid-column: 1/-1;\n  grid-row: 2/3;\n}\n@media screen and (min-width: 1200px) {\n  .pf-c-page__header-nav {\n    grid-column: 2/3;\n    grid-row: 1/2;\n  }\n}\n.pf-c-page__header-nav .pf-c-nav {\n  align-self: stretch;\n}\n\n.pf-c-page__header-tools {\n  grid-column: 2/3;\n  margin-right: var(--pf-c-page__header-tools--MarginRight);\n  margin-left: auto;\n}\n.pf-c-page__header-tools .pf-c-avatar {\n  margin-left: var(--pf-c-page__header-tools--c-avatar--MarginLeft);\n}\n@media screen and (min-width: 992px) {\n  .pf-c-page__header-tools {\n    grid-column: 3/4;\n  }\n}\n\n.pf-c-page__header-tools-group {\n  --pf-hidden-visible--visible--Display: var(--pf-c-page__header-tools-group--Display);\n  align-items: center;\n}\n.pf-c-page__header-tools-group + .pf-c-page__header-tools-group {\n  margin-left: var(--pf-c-page__header-tools-group--MarginLeft);\n}\n\n.pf-c-page__header-tools-item {\n  --pf-hidden-visible--visible--Display: var(--pf-c-page__header-tools-item--Display);\n}\n.pf-c-page__header-tools-item .pf-c-notification-badge.pf-m-read:hover {\n  --pf-c-notification-badge--after--BackgroundColor: var(--pf-c-page__header-tools-item--c-notification-badge--hover--BackgroundColor);\n}\n.pf-c-page__header-tools-item.pf-m-selected .pf-c-button {\n  background-color: var(--pf-c-page__header-tools--c-button--m-selected--before--BackgroundColor);\n  border-radius: var(--pf-c-page__header-tools--c-button--m-selected--before--BorderRadius);\n}\n.pf-c-page__header-tools-item.pf-m-selected .pf-c-button::before {\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  width: var(--pf-c-page__header-tools--c-button--m-selected--before--Width);\n  height: var(--pf-c-page__header-tools--c-button--m-selected--before--Height);\n  content: \"\";\n}\n.pf-c-page__header-tools-item.pf-m-selected .pf-c-button .pf-c-notification-badge.pf-m-unread {\n  --pf-c-notification-badge--after--BackgroundColor: var(--pf-c-page__header-tools--c-button--m-selected--notification-badge--m-unread--after--BackgroundColor);\n}\n.pf-c-page__header-tools-item.pf-m-selected .pf-c-button .pf-c-notification-badge.pf-m-unread::after {\n  border-color: var(--pf-c-page__header-tools--c-button--m-selected--c-notification-badge--m-unread--after--BorderColor);\n}\n.pf-c-page__header-tools-item.pf-m-selected .pf-c-button .pf-c-notification-badge.pf-m-attention {\n  --pf-c-notification-badge--after--BackgroundColor: var(--pf-global--danger-color--200);\n}\n.pf-c-page__header-tools-item .pf-c-button:focus .pf-c-notification-badge.pf-m-unread {\n  --pf-c-notification-badge--after--BackgroundColor: var(--pf-c-page__header-tools--c-button--notification-badge--m-unread--after--BackgroundColor);\n}\n.pf-c-page__header-tools-item .pf-c-button:focus .pf-c-notification-badge.pf-m-attention {\n  --pf-c-notification-badge--after--BackgroundColor: var(--pf-c-page__header-tools--c-button--notification-badge--m-attention--after--BackgroundColor);\n}\n\n.pf-c-page__sidebar {\n  grid-area: nav;\n  grid-row-start: 2;\n  grid-column-start: 1;\n  z-index: var(--pf-c-page__sidebar--ZIndex);\n  width: var(--pf-c-page__sidebar--Width);\n  overflow-x: hidden;\n  overflow-y: auto;\n  -webkit-overflow-scrolling: touch;\n  background-color: var(--pf-c-page__sidebar--BackgroundColor);\n  transition: var(--pf-c-page__sidebar--Transition);\n  transform: translateX(var(--pf-c-page__sidebar--TranslateX)) translateZ(var(--pf-c-page__sidebar--TranslateZ));\n}\n@media screen and (min-width: 1200px) {\n  .pf-c-page__sidebar {\n    box-shadow: var(--pf-c-page__sidebar--BoxShadow);\n  }\n}\n.pf-c-page__sidebar.pf-m-expanded {\n  --pf-c-page__sidebar--TranslateX: var(--pf-c-page__sidebar--m-expanded--TranslateX);\n  box-shadow: var(--pf-c-page__sidebar--BoxShadow);\n}\n.pf-c-page__sidebar.pf-m-collapsed {\n  max-width: 0;\n  overflow: hidden;\n}\n.pf-c-page__sidebar.pf-m-light {\n  color: var(--pf-global--Color--100);\n  --pf-c-page__sidebar--BackgroundColor: var(--pf-c-page__sidebar--m-light--BackgroundColor);\n}\n\n.pf-c-page__sidebar-body {\n  padding-top: var(--pf-c-page__sidebar-body--PaddingTop);\n  padding-bottom: var(--pf-c-page__sidebar-body--PaddingBottom);\n}\n.pf-c-page__sidebar-body.pf-m-menu {\n  --pf-c-page__sidebar-body--PaddingTop: var(--pf-c-page__sidebar-body--m-menu--PaddingTop);\n  --pf-c-page__sidebar-body--PaddingBottom: var(--pf-c-page__sidebar-body--m-menu--PaddingBottom);\n  background-color: var(--pf-global--palette--black-900);\n  border-top: var(--pf-c-page__sidebar-body--m-menu--BorderTopWidth) solid var(--pf-c-page__sidebar-body--m-menu--BorderTopColor);\n}\n.pf-c-page__sidebar-body.pf-m-menu + .pf-c-page__sidebar-body.pf-m-menu {\n  --pf-c-page__sidebar-body--m-menu--BorderTopWidth: 0;\n}\n.pf-c-page__sidebar-body.pf-m-menu .pf-c-context-selector {\n  --pf-c-context-selector__toggle--BorderTopColor: transparent;\n  --pf-c-context-selector__toggle--BorderRightColor: transparent;\n  --pf-c-context-selector__toggle--BorderBottomColor: var(--pf-c-page__sidebar-body--m-menu--c-context-selector--BorderBottomColor);\n  --pf-c-context-selector__toggle--BorderLeftColor: transparent;\n  --pf-c-context-selector__menu--Top: 100%;\n  color: var(--pf-global--Color--100);\n  width: 100%;\n}\n\n.pf-c-page__main-nav.pf-m-limit-width,\n.pf-c-page__main-breadcrumb.pf-m-limit-width,\n.pf-c-page__main-tabs.pf-m-limit-width,\n.pf-c-page__main-section.pf-m-limit-width,\n.pf-c-page__main-wizard.pf-m-limit-width {\n  display: flex;\n  flex-direction: column;\n  padding: 0;\n}\n.pf-c-page__main-nav.pf-m-limit-width > .pf-c-page__main-body,\n.pf-c-page__main-breadcrumb.pf-m-limit-width > .pf-c-page__main-body,\n.pf-c-page__main-tabs.pf-m-limit-width > .pf-c-page__main-body,\n.pf-c-page__main-section.pf-m-limit-width > .pf-c-page__main-body,\n.pf-c-page__main-wizard.pf-m-limit-width > .pf-c-page__main-body {\n  flex: 1;\n  max-width: var(--pf-c-page--section--m-limit-width--MaxWidth);\n}\n.pf-c-page__main-nav.pf-m-limit-width.pf-m-align-center,\n.pf-c-page__main-breadcrumb.pf-m-limit-width.pf-m-align-center,\n.pf-c-page__main-tabs.pf-m-limit-width.pf-m-align-center,\n.pf-c-page__main-section.pf-m-limit-width.pf-m-align-center,\n.pf-c-page__main-wizard.pf-m-limit-width.pf-m-align-center {\n  align-items: center;\n}\n.pf-c-page__main-nav.pf-m-limit-width.pf-m-align-center > .pf-c-page__main-body,\n.pf-c-page__main-breadcrumb.pf-m-limit-width.pf-m-align-center > .pf-c-page__main-body,\n.pf-c-page__main-tabs.pf-m-limit-width.pf-m-align-center > .pf-c-page__main-body,\n.pf-c-page__main-section.pf-m-limit-width.pf-m-align-center > .pf-c-page__main-body,\n.pf-c-page__main-wizard.pf-m-limit-width.pf-m-align-center > .pf-c-page__main-body {\n  width: 100%;\n}\n\n.pf-c-page__main-nav,\n.pf-c-page__main-breadcrumb,\n.pf-c-page__main-tabs,\n.pf-c-page__main-section,\n.pf-c-page__main-wizard,\n.pf-c-page__main-group,\n.pf-c-page__main-subnav {\n  flex-shrink: 0;\n}\n.pf-c-page__main-nav.pf-m-overflow-scroll,\n.pf-c-page__main-breadcrumb.pf-m-overflow-scroll,\n.pf-c-page__main-tabs.pf-m-overflow-scroll,\n.pf-c-page__main-section.pf-m-overflow-scroll,\n.pf-c-page__main-wizard.pf-m-overflow-scroll,\n.pf-c-page__main-group.pf-m-overflow-scroll,\n.pf-c-page__main-subnav.pf-m-overflow-scroll {\n  position: relative;\n  flex-shrink: 1;\n  overflow: auto;\n}\n.pf-c-page__main-nav.pf-m-shadow-bottom,\n.pf-c-page__main-breadcrumb.pf-m-shadow-bottom,\n.pf-c-page__main-tabs.pf-m-shadow-bottom,\n.pf-c-page__main-section.pf-m-shadow-bottom,\n.pf-c-page__main-wizard.pf-m-shadow-bottom,\n.pf-c-page__main-group.pf-m-shadow-bottom,\n.pf-c-page__main-subnav.pf-m-shadow-bottom {\n  z-index: var(--pf-c-page--section--m-shadow-bottom--ZIndex);\n  box-shadow: var(--pf-c-page--section--m-shadow-bottom--BoxShadow);\n}\n.pf-c-page__main-nav.pf-m-shadow-top,\n.pf-c-page__main-breadcrumb.pf-m-shadow-top,\n.pf-c-page__main-tabs.pf-m-shadow-top,\n.pf-c-page__main-section.pf-m-shadow-top,\n.pf-c-page__main-wizard.pf-m-shadow-top,\n.pf-c-page__main-group.pf-m-shadow-top,\n.pf-c-page__main-subnav.pf-m-shadow-top {\n  z-index: var(--pf-c-page--section--m-shadow-top--ZIndex);\n  box-shadow: var(--pf-c-page--section--m-shadow-top--BoxShadow);\n}\n.pf-c-page__main-nav.pf-m-sticky-top,\n.pf-c-page__main-breadcrumb.pf-m-sticky-top,\n.pf-c-page__main-tabs.pf-m-sticky-top,\n.pf-c-page__main-section.pf-m-sticky-top,\n.pf-c-page__main-wizard.pf-m-sticky-top,\n.pf-c-page__main-group.pf-m-sticky-top,\n.pf-c-page__main-subnav.pf-m-sticky-top {\n  position: sticky;\n  top: 0;\n  z-index: var(--pf-c-page--section--m-sticky-top--ZIndex);\n  box-shadow: var(--pf-c-page--section--m-sticky-top--BoxShadow);\n}\n.pf-c-page__main-nav.pf-m-sticky-bottom,\n.pf-c-page__main-breadcrumb.pf-m-sticky-bottom,\n.pf-c-page__main-tabs.pf-m-sticky-bottom,\n.pf-c-page__main-section.pf-m-sticky-bottom,\n.pf-c-page__main-wizard.pf-m-sticky-bottom,\n.pf-c-page__main-group.pf-m-sticky-bottom,\n.pf-c-page__main-subnav.pf-m-sticky-bottom {\n  position: sticky;\n  bottom: 0;\n  z-index: var(--pf-c-page--section--m-sticky-bottom--ZIndex);\n  box-shadow: var(--pf-c-page--section--m-sticky-bottom--BoxShadow);\n}\n@media (min-height: 0) {\n  .pf-c-page__main-nav.pf-m-sticky-top-on-sm-height,\n.pf-c-page__main-breadcrumb.pf-m-sticky-top-on-sm-height,\n.pf-c-page__main-tabs.pf-m-sticky-top-on-sm-height,\n.pf-c-page__main-section.pf-m-sticky-top-on-sm-height,\n.pf-c-page__main-wizard.pf-m-sticky-top-on-sm-height,\n.pf-c-page__main-group.pf-m-sticky-top-on-sm-height,\n.pf-c-page__main-subnav.pf-m-sticky-top-on-sm-height {\n    position: sticky;\n    top: 0;\n    z-index: var(--pf-c-page--section--m-sticky-top--ZIndex);\n    box-shadow: var(--pf-c-page--section--m-sticky-top--BoxShadow);\n  }\n  .pf-c-page__main-nav.pf-m-sticky-bottom-on-sm-height,\n.pf-c-page__main-breadcrumb.pf-m-sticky-bottom-on-sm-height,\n.pf-c-page__main-tabs.pf-m-sticky-bottom-on-sm-height,\n.pf-c-page__main-section.pf-m-sticky-bottom-on-sm-height,\n.pf-c-page__main-wizard.pf-m-sticky-bottom-on-sm-height,\n.pf-c-page__main-group.pf-m-sticky-bottom-on-sm-height,\n.pf-c-page__main-subnav.pf-m-sticky-bottom-on-sm-height {\n    position: sticky;\n    bottom: 0;\n    z-index: var(--pf-c-page--section--m-sticky-bottom--ZIndex);\n    box-shadow: var(--pf-c-page--section--m-sticky-bottom--BoxShadow);\n  }\n}\n@media (min-height: 40rem) {\n  .pf-c-page__main-nav.pf-m-sticky-top-on-md-height,\n.pf-c-page__main-breadcrumb.pf-m-sticky-top-on-md-height,\n.pf-c-page__main-tabs.pf-m-sticky-top-on-md-height,\n.pf-c-page__main-section.pf-m-sticky-top-on-md-height,\n.pf-c-page__main-wizard.pf-m-sticky-top-on-md-height,\n.pf-c-page__main-group.pf-m-sticky-top-on-md-height,\n.pf-c-page__main-subnav.pf-m-sticky-top-on-md-height {\n    position: sticky;\n    top: 0;\n    z-index: var(--pf-c-page--section--m-sticky-top--ZIndex);\n    box-shadow: var(--pf-c-page--section--m-sticky-top--BoxShadow);\n  }\n  .pf-c-page__main-nav.pf-m-sticky-bottom-on-md-height,\n.pf-c-page__main-breadcrumb.pf-m-sticky-bottom-on-md-height,\n.pf-c-page__main-tabs.pf-m-sticky-bottom-on-md-height,\n.pf-c-page__main-section.pf-m-sticky-bottom-on-md-height,\n.pf-c-page__main-wizard.pf-m-sticky-bottom-on-md-height,\n.pf-c-page__main-group.pf-m-sticky-bottom-on-md-height,\n.pf-c-page__main-subnav.pf-m-sticky-bottom-on-md-height {\n    position: sticky;\n    bottom: 0;\n    z-index: var(--pf-c-page--section--m-sticky-bottom--ZIndex);\n    box-shadow: var(--pf-c-page--section--m-sticky-bottom--BoxShadow);\n  }\n}\n@media (min-height: 48rem) {\n  .pf-c-page__main-nav.pf-m-sticky-top-on-lg-height,\n.pf-c-page__main-breadcrumb.pf-m-sticky-top-on-lg-height,\n.pf-c-page__main-tabs.pf-m-sticky-top-on-lg-height,\n.pf-c-page__main-section.pf-m-sticky-top-on-lg-height,\n.pf-c-page__main-wizard.pf-m-sticky-top-on-lg-height,\n.pf-c-page__main-group.pf-m-sticky-top-on-lg-height,\n.pf-c-page__main-subnav.pf-m-sticky-top-on-lg-height {\n    position: sticky;\n    top: 0;\n    z-index: var(--pf-c-page--section--m-sticky-top--ZIndex);\n    box-shadow: var(--pf-c-page--section--m-sticky-top--BoxShadow);\n  }\n  .pf-c-page__main-nav.pf-m-sticky-bottom-on-lg-height,\n.pf-c-page__main-breadcrumb.pf-m-sticky-bottom-on-lg-height,\n.pf-c-page__main-tabs.pf-m-sticky-bottom-on-lg-height,\n.pf-c-page__main-section.pf-m-sticky-bottom-on-lg-height,\n.pf-c-page__main-wizard.pf-m-sticky-bottom-on-lg-height,\n.pf-c-page__main-group.pf-m-sticky-bottom-on-lg-height,\n.pf-c-page__main-subnav.pf-m-sticky-bottom-on-lg-height {\n    position: sticky;\n    bottom: 0;\n    z-index: var(--pf-c-page--section--m-sticky-bottom--ZIndex);\n    box-shadow: var(--pf-c-page--section--m-sticky-bottom--BoxShadow);\n  }\n}\n@media (min-height: 60rem) {\n  .pf-c-page__main-nav.pf-m-sticky-top-on-xl-height,\n.pf-c-page__main-breadcrumb.pf-m-sticky-top-on-xl-height,\n.pf-c-page__main-tabs.pf-m-sticky-top-on-xl-height,\n.pf-c-page__main-section.pf-m-sticky-top-on-xl-height,\n.pf-c-page__main-wizard.pf-m-sticky-top-on-xl-height,\n.pf-c-page__main-group.pf-m-sticky-top-on-xl-height,\n.pf-c-page__main-subnav.pf-m-sticky-top-on-xl-height {\n    position: sticky;\n    top: 0;\n    z-index: var(--pf-c-page--section--m-sticky-top--ZIndex);\n    box-shadow: var(--pf-c-page--section--m-sticky-top--BoxShadow);\n  }\n  .pf-c-page__main-nav.pf-m-sticky-bottom-on-xl-height,\n.pf-c-page__main-breadcrumb.pf-m-sticky-bottom-on-xl-height,\n.pf-c-page__main-tabs.pf-m-sticky-bottom-on-xl-height,\n.pf-c-page__main-section.pf-m-sticky-bottom-on-xl-height,\n.pf-c-page__main-wizard.pf-m-sticky-bottom-on-xl-height,\n.pf-c-page__main-group.pf-m-sticky-bottom-on-xl-height,\n.pf-c-page__main-subnav.pf-m-sticky-bottom-on-xl-height {\n    position: sticky;\n    bottom: 0;\n    z-index: var(--pf-c-page--section--m-sticky-bottom--ZIndex);\n    box-shadow: var(--pf-c-page--section--m-sticky-bottom--BoxShadow);\n  }\n}\n@media (min-height: 80rem) {\n  .pf-c-page__main-nav.pf-m-sticky-top-on-2xl-height,\n.pf-c-page__main-breadcrumb.pf-m-sticky-top-on-2xl-height,\n.pf-c-page__main-tabs.pf-m-sticky-top-on-2xl-height,\n.pf-c-page__main-section.pf-m-sticky-top-on-2xl-height,\n.pf-c-page__main-wizard.pf-m-sticky-top-on-2xl-height,\n.pf-c-page__main-group.pf-m-sticky-top-on-2xl-height,\n.pf-c-page__main-subnav.pf-m-sticky-top-on-2xl-height {\n    position: sticky;\n    top: 0;\n    z-index: var(--pf-c-page--section--m-sticky-top--ZIndex);\n    box-shadow: var(--pf-c-page--section--m-sticky-top--BoxShadow);\n  }\n  .pf-c-page__main-nav.pf-m-sticky-bottom-on-2xl-height,\n.pf-c-page__main-breadcrumb.pf-m-sticky-bottom-on-2xl-height,\n.pf-c-page__main-tabs.pf-m-sticky-bottom-on-2xl-height,\n.pf-c-page__main-section.pf-m-sticky-bottom-on-2xl-height,\n.pf-c-page__main-wizard.pf-m-sticky-bottom-on-2xl-height,\n.pf-c-page__main-group.pf-m-sticky-bottom-on-2xl-height,\n.pf-c-page__main-subnav.pf-m-sticky-bottom-on-2xl-height {\n    position: sticky;\n    bottom: 0;\n    z-index: var(--pf-c-page--section--m-sticky-bottom--ZIndex);\n    box-shadow: var(--pf-c-page--section--m-sticky-bottom--BoxShadow);\n  }\n}\n\n.pf-c-page__main,\n.pf-c-page__drawer {\n  grid-area: main;\n  z-index: var(--pf-c-page__main--ZIndex);\n  overflow-x: hidden;\n  overflow-y: auto;\n  -webkit-overflow-scrolling: touch;\n}\n.pf-c-page__main:focus,\n.pf-c-page__drawer:focus {\n  outline: 0;\n}\n\n.pf-c-page__main,\n.pf-c-page__main-drawer,\n.pf-c-page__main-group {\n  display: flex;\n  flex-direction: column;\n}\n\n.pf-c-page__main-nav {\n  padding-top: var(--pf-c-page__main-nav--PaddingTop);\n  padding-right: var(--pf-c-page__main-nav--PaddingRight);\n  padding-left: var(--pf-c-page__main-nav--PaddingLeft);\n  background-color: var(--pf-c-page__main-nav--BackgroundColor);\n}\n.pf-c-page__main-nav.pf-m-sticky-top, .pf-c-page__main-group.pf-m-sticky-top .pf-c-page__main-nav:last-child {\n  padding-bottom: var(--pf-c-page__main-nav--m-sticky-top--PaddingBottom);\n}\n\n.pf-c-page__main-subnav {\n  background-color: var(--pf-c-page__main-subnav--BackgroundColor);\n  border-top: var(--pf-c-page__main-subnav--BorderTopWidth) solid var(--pf-c-page__main-subnav--BorderTopColor);\n  border-left: var(--pf-c-page__main-subnav--BorderLeftWidth) solid var(--pf-c-page__main-subnav--BorderLeftColor);\n}\n@media screen and (min-width: 1200px) {\n  .pf-c-page__sidebar ~ .pf-c-page__main {\n    --pf-c-page__main-subnav--BorderLeftWidth: var(--pf-c-page__sidebar--main__main-subnav--BorderLeftWidth);\n  }\n}\n.pf-c-page__sidebar.pf-m-collapsed ~ .pf-c-page__main {\n  --pf-c-page__main-subnav--BorderLeftWidth: var(--pf-c-page__sidebar--m-collapsed--main__main-subnav--BorderLeftWidth);\n}\n\n.pf-c-page__main-breadcrumb {\n  padding: var(--pf-c-page__main-breadcrumb--PaddingTop) var(--pf-c-page__main-breadcrumb--PaddingRight) var(--pf-c-page__main-breadcrumb--PaddingBottom) var(--pf-c-page__main-breadcrumb--PaddingLeft);\n  background-color: var(--pf-c-page__main-breadcrumb--BackgroundColor);\n}\n.pf-c-page__main-breadcrumb + .pf-c-page__main-section {\n  --pf-c-page__main-section--PaddingTop: var(--pf-c-page__main-breadcrumb--main-section--PaddingTop);\n}\n.pf-c-page__main-breadcrumb.pf-m-sticky-top, .pf-c-page__main-group.pf-m-sticky-top .pf-c-page__main-breadcrumb:last-child {\n  --pf-c-page__main-breadcrumb--PaddingBottom: var(--pf-c-page__main-breadcrumb--m-sticky-top--PaddingBottom);\n}\n\n.pf-c-page__main-tabs {\n  padding: var(--pf-c-page__main-tabs--PaddingTop) var(--pf-c-page__main-tabs--PaddingRight) var(--pf-c-page__main-tabs--PaddingBottom) var(--pf-c-page__main-tabs--PaddingLeft);\n  background-color: var(--pf-c-page__main-tabs--BackgroundColor);\n}\n.pf-c-page__main-nav + .pf-c-page__main-tabs {\n  --pf-c-page__main-tabs--PaddingTop: var(--pf-c-page__main-nav--page__main-tabs--PaddingTop);\n}\n.pf-c-page__main-breadcrumb + .pf-c-page__main-tabs {\n  --pf-c-page__main-tabs--PaddingTop: var(--pf-c-page__main-breadcrumb--page__main-tabs--PaddingTop);\n}\n\n.pf-c-page__main-section:last-child, .pf-c-page__main-section:only-child, .pf-c-page__main-section.pf-m-fill,\n.pf-c-page__main-group:last-child,\n.pf-c-page__main-group:only-child,\n.pf-c-page__main-group.pf-m-fill,\n.pf-c-page__main-wizard:last-child,\n.pf-c-page__main-wizard:only-child,\n.pf-c-page__main-wizard.pf-m-fill {\n  flex-grow: 1;\n}\n.pf-c-page__main-section.pf-m-no-fill,\n.pf-c-page__main-group.pf-m-no-fill,\n.pf-c-page__main-wizard.pf-m-no-fill {\n  flex-grow: 0;\n}\n\n.pf-c-page__main-section {\n  padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  background-color: var(--pf-c-page__main-section--BackgroundColor);\n}\n.pf-c-page__main-section.pf-m-light {\n  --pf-c-page__main-section--BackgroundColor: var(--pf-c-page__main-section--m-light--BackgroundColor);\n}\n.pf-c-page__main-section.pf-m-light-100 {\n  --pf-c-page__main-section--BackgroundColor: var(--pf-c-page__main-section--m-light-100--BackgroundColor);\n}\n.pf-c-page__main-section[class*=pf-m-dark-] {\n  color: var(--pf-global--Color--100);\n}\n.pf-c-page__main-section.pf-m-dark-100 {\n  --pf-c-page__main-section--BackgroundColor: var(--pf-c-page__main-section--m-dark-100--BackgroundColor);\n}\n.pf-c-page__main-section.pf-m-dark-200 {\n  --pf-c-page__main-section--BackgroundColor: var(--pf-c-page__main-section--m-dark-200--BackgroundColor);\n}\n.pf-c-page__main-section.pf-m-padding {\n  padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n}\n.pf-c-page__main-section.pf-m-padding.pf-m-limit-width {\n  padding: 0;\n}\n.pf-c-page__main-section.pf-m-padding.pf-m-limit-width .pf-c-page__main-body {\n  padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n}\n.pf-c-page__main-section.pf-m-no-padding, .pf-c-page__main-section.pf-m-no-padding.pf-m-limit-width .pf-c-page__main-body {\n  padding: 0;\n}\n@media (min-width: 576px) {\n  .pf-c-page__main-section.pf-m-padding-on-sm {\n    padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  }\n  .pf-c-page__main-section.pf-m-padding-on-sm.pf-m-limit-width {\n    padding: 0;\n  }\n  .pf-c-page__main-section.pf-m-padding-on-sm.pf-m-limit-width .pf-c-page__main-body {\n    padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  }\n  .pf-c-page__main-section.pf-m-no-padding-on-sm, .pf-c-page__main-section.pf-m-no-padding-on-sm.pf-m-limit-width .pf-c-page__main-body {\n    padding: 0;\n  }\n}\n@media (min-width: 768px) {\n  .pf-c-page__main-section.pf-m-padding-on-md {\n    padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  }\n  .pf-c-page__main-section.pf-m-padding-on-md.pf-m-limit-width {\n    padding: 0;\n  }\n  .pf-c-page__main-section.pf-m-padding-on-md.pf-m-limit-width .pf-c-page__main-body {\n    padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  }\n  .pf-c-page__main-section.pf-m-no-padding-on-md, .pf-c-page__main-section.pf-m-no-padding-on-md.pf-m-limit-width .pf-c-page__main-body {\n    padding: 0;\n  }\n}\n@media (min-width: 992px) {\n  .pf-c-page__main-section.pf-m-padding-on-lg {\n    padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  }\n  .pf-c-page__main-section.pf-m-padding-on-lg.pf-m-limit-width {\n    padding: 0;\n  }\n  .pf-c-page__main-section.pf-m-padding-on-lg.pf-m-limit-width .pf-c-page__main-body {\n    padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  }\n  .pf-c-page__main-section.pf-m-no-padding-on-lg, .pf-c-page__main-section.pf-m-no-padding-on-lg.pf-m-limit-width .pf-c-page__main-body {\n    padding: 0;\n  }\n}\n@media (min-width: 1200px) {\n  .pf-c-page__main-section.pf-m-padding-on-xl {\n    padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  }\n  .pf-c-page__main-section.pf-m-padding-on-xl.pf-m-limit-width {\n    padding: 0;\n  }\n  .pf-c-page__main-section.pf-m-padding-on-xl.pf-m-limit-width .pf-c-page__main-body {\n    padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  }\n  .pf-c-page__main-section.pf-m-no-padding-on-xl, .pf-c-page__main-section.pf-m-no-padding-on-xl.pf-m-limit-width .pf-c-page__main-body {\n    padding: 0;\n  }\n}\n@media (min-width: 1450px) {\n  .pf-c-page__main-section.pf-m-padding-on-2xl {\n    padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  }\n  .pf-c-page__main-section.pf-m-padding-on-2xl.pf-m-limit-width {\n    padding: 0;\n  }\n  .pf-c-page__main-section.pf-m-padding-on-2xl.pf-m-limit-width .pf-c-page__main-body {\n    padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n  }\n  .pf-c-page__main-section.pf-m-no-padding-on-2xl, .pf-c-page__main-section.pf-m-no-padding-on-2xl.pf-m-limit-width .pf-c-page__main-body {\n    padding: 0;\n  }\n}\n\n.pf-c-page__main-wizard {\n  flex: 1 1;\n  min-height: 0;\n  background-color: var(--pf-c-page__main-wizard--BackgroundColor);\n  border-top: var(--pf-c-page__main-wizard--BorderTopWidth) solid var(--pf-c-page__main-wizard--BorderTopColor);\n}\n.pf-c-page__main-wizard:first-child {\n  --pf-c-page__main-wizard--BorderTopWidth: 0;\n}\n.pf-c-page__main-wizard.pf-m-light-200 {\n  --pf-c-page__main-wizard--BackgroundColor: var(--pf-c-page__main-wizard--m-light-200--BackgroundColor);\n}\n\n.pf-c-page__main-wizard .pf-c-page__main-body {\n  min-height: 0;\n}\n\n.pf-c-page__main-group {\n  flex-shrink: 0;\n}\n\n.pf-c-page__main-nav .pf-c-page__main-body {\n  padding-top: var(--pf-c-page__main-nav--PaddingTop);\n  padding-right: var(--pf-c-page__main-nav--PaddingRight);\n  padding-left: var(--pf-c-page__main-nav--PaddingLeft);\n}\n.pf-c-page__main-breadcrumb .pf-c-page__main-body {\n  padding: var(--pf-c-page__main-breadcrumb--PaddingTop) var(--pf-c-page__main-breadcrumb--PaddingRight) var(--pf-c-page__main-breadcrumb--PaddingBottom) var(--pf-c-page__main-breadcrumb--PaddingLeft);\n}\n.pf-c-page__main-section .pf-c-page__main-body {\n  padding: var(--pf-c-page__main-section--PaddingTop) var(--pf-c-page__main-section--PaddingRight) var(--pf-c-page__main-section--PaddingBottom) var(--pf-c-page__main-section--PaddingLeft);\n}\n.pf-c-page__main-tabs .pf-c-page__main-body {\n  padding: var(--pf-c-page__main-tabs--PaddingTop) var(--pf-c-page__main-tabs--PaddingRight) var(--pf-c-page__main-tabs--PaddingBottom) var(--pf-c-page__main-tabs--PaddingLeft);\n}\n\n.pf-c-page__drawer {\n  grid-area: main;\n}\n.pf-c-page__drawer > .pf-c-drawer {\n  flex: 1 0 auto;\n}\n\n:where(.pf-theme-dark) .pf-c-page__sidebar-body.pf-m-menu .pf-c-context-selector,\n:where(.pf-theme-dark) .pf-c-page__main-section[class*=pf-m-dark-],\n:where(.pf-theme-dark) .pf-c-page__header {\n  --pf-global--Color--100: #e0e0e0;\n  --pf-global--Color--200: #aaabac;\n  --pf-global--BorderColor--100: #444548;\n  --pf-global--primary-color--100: #1fa7f8;\n  --pf-global--link--Color: #1fa7f8;\n  --pf-global--link--Color--hover: #73bcf7;\n  --pf-global--BackgroundColor--100: #1b1d21;\n}\n:where(.pf-theme-dark) .pf-c-page__sidebar-body.pf-m-menu .pf-c-context-selector .pf-c-card,\n:where(.pf-theme-dark) .pf-c-page__main-section[class*=pf-m-dark-] .pf-c-card,\n:where(.pf-theme-dark) .pf-c-page__header .pf-c-card {\n  --pf-c-card--BackgroundColor: var(--pf-global--BackgroundColor--100);\n}\n:where(.pf-theme-dark) .pf-c-page__sidebar-body.pf-m-menu .pf-c-context-selector .pf-c-button,\n:where(.pf-theme-dark) .pf-c-page__main-section[class*=pf-m-dark-] .pf-c-button,\n:where(.pf-theme-dark) .pf-c-page__header .pf-c-button {\n  --pf-c-button--m-primary--Color: var(--pf-global--Color--light-100);\n  --pf-c-button--m-primary--hover--Color: var(--pf-global--Color--light-100);\n  --pf-c-button--m-primary--focus--Color: var(--pf-global--Color--light-100);\n  --pf-c-button--m-primary--active--Color: var(--pf-global--Color--light-100);\n  --pf-c-button--m-primary--BackgroundColor: var(--pf-global--primary-color--300);\n  --pf-c-button--m-primary--hover--BackgroundColor: var(--pf-global--primary-color--200);\n  --pf-c-button--m-primary--focus--BackgroundColor: var(--pf-global--primary-color--200);\n  --pf-c-button--m-primary--active--BackgroundColor: var(--pf-global--primary-color--200);\n  --pf-c-button--m-secondary--Color: var(--pf-global--primary-color--100);\n  --pf-c-button--m-secondary--hover--Color: var(--pf-global--primary-color--100);\n  --pf-c-button--m-secondary--focus--Color: var(--pf-global--primary-color--100);\n  --pf-c-button--m-secondary--active--Color: var(--pf-global--primary-color--100);\n}\n\n:where(.pf-theme-dark) .pf-c-page {\n  --pf-c-page__main-section--BackgroundColor: var(--pf-global--BackgroundColor--200);\n  --pf-c-page__header-tools--c-button--m-selected--before--BackgroundColor: var(--pf-global--BackgroundColor--300);\n  --pf-c-page__sidebar--BackgroundColor: var(--pf-global--BackgroundColor--100);\n  --pf-c-page__header--BackgroundColor: var(--pf-global--palette--black-1000);\n}\n:where(.pf-theme-dark) .pf-c-page__header-tools-item.pf-m-selected .pf-c-button {\n  color: var(--pf-global--Color--100);\n}\n:where(.pf-theme-dark) .pf-c-page__header-tools-item.pf-m-selected .pf-c-button .pf-c-notification-badge:hover::before {\n  background-color: var(--pf-c-page__header-tools--c-button--m-selected--before--BackgroundColor);\n}\n:where(.pf-theme-dark) .pf-c-page__main-nav.pf-m-sticky-top, :where(.pf-theme-dark) .pf-c-page__main-nav.pf-m-sticky-bottom {\n  --pf-c-page__main-nav--BackgroundColor: var(--pf-global--BackgroundColor--300);\n}\n:where(.pf-theme-dark) .pf-c-page__main-breadcrumb.pf-m-sticky-top, :where(.pf-theme-dark) .pf-c-page__main-breadcrumb.pf-m-sticky-bottom {\n  --pf-c-page__main-breadcrumb--BackgroundColor: var(--pf-global--BackgroundColor--300);\n}\n:where(.pf-theme-dark) .pf-c-page__main-group.pf-m-sticky-top, :where(.pf-theme-dark) .pf-c-page__main-group.pf-m-sticky-bottom {\n  --pf-c-page__main-section--m-light--BackgroundColor: var(--pf-global--BackgroundColor--300);\n  --pf-c-page__main-section--BackgroundColor: var(--pf-global--BackgroundColor--300);\n  --pf-c-page__main-breadcrumb--BackgroundColor: var(--pf-global--BackgroundColor--300);\n  --pf-c-page__main-nav--BackgroundColor: var(--pf-global--BackgroundColor--300);\n}\n:where(.pf-theme-dark) .pf-c-page__main-section.pf-m-sticky-top, :where(.pf-theme-dark) .pf-c-page__main-section.pf-m-sticky-bottom {\n  --pf-c-page__main-section--BackgroundColor: var(--pf-global--BackgroundColor--300);\n}\n:where(.pf-theme-dark) .pf-c-page__sidebar-body.pf-m-menu .pf-c-context-selector,\n:where(.pf-theme-dark) .pf-c-page__main-section[class*=pf-m-dark-],\n:where(.pf-theme-dark) .pf-c-page__header {\n  color: var(--pf-global--Color--100);\n}");
