/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.unix.USOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freedesktop.dbus.Message;

public class MessageWriter {
    private OutputStream out;
    private boolean isunix;

    public MessageWriter(OutputStream out) {
        this.out = out;
        this.isunix = false;
        try {
            if (out instanceof USOutputStream) {
                this.isunix = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.isunix) {
            this.out = new BufferedOutputStream(this.out);
        }
    }

    public void writeMessage(Message m) throws IOException {
        if (null == m) {
            return;
        }
        if (null == m.getWireData()) {
            return;
        }
        if (this.isunix) {
            ((USOutputStream)this.out).write(m.getWireData());
        } else {
            for (byte[] buf : m.getWireData()) {
                if (null == buf) break;
                this.out.write(buf);
            }
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

