/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.statement.apple;

import com.webauthn4j.data.attestation.statement.AppleAnonymousAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationType;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.CoreRegistrationObject;
import com.webauthn4j.validator.attestation.statement.AbstractStatementValidator;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import com.webauthn4j.validator.exception.PublicKeyMismatchException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.util.Arrays;
import org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.parse.Asn1Parser;
import org.apache.kerby.asn1.type.Asn1OctetString;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AppleAnonymousAttestationStatementValidator
extends AbstractStatementValidator<AppleAnonymousAttestationStatement> {
    @Override
    public @NonNull AttestationType validate(@NonNull CoreRegistrationObject registrationObject) {
        AssertUtil.notNull((Object)registrationObject, (String)"registrationObject must not be null");
        if (!this.supports(registrationObject)) {
            throw new IllegalArgumentException(String.format("Specified format '%s' is not supported by %s.", registrationObject.getAttestationObject().getFormat(), this.getClass().getName()));
        }
        AppleAnonymousAttestationStatement attestationStatement = (AppleAnonymousAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        this.validateAttestationStatementNotNull(attestationStatement);
        this.validateNonce(registrationObject);
        this.validatePublicKey(registrationObject, attestationStatement);
        return AttestationType.BASIC;
    }

    void validateAttestationStatementNotNull(AppleAnonymousAttestationStatement attestationStatement) {
        if (attestationStatement == null) {
            throw new BadAttestationStatementException("attestation statement is not found.");
        }
    }

    private void validateNonce(@NonNull CoreRegistrationObject registrationObject) {
        byte[] extracted;
        AppleAnonymousAttestationStatement attestationStatement = (AppleAnonymousAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        byte[] nonce = this.getNonce(registrationObject);
        byte[] extensionValue = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate().getExtensionValue("1.2.840.113635.100.8.2");
        try {
            Asn1OctetString extensionEnvelope = new Asn1OctetString();
            extensionEnvelope.decode(extensionValue);
            extensionEnvelope.getValue();
            byte[] extensionEnvelopeValue = (byte[])extensionEnvelope.getValue();
            Asn1Container container = (Asn1Container)Asn1Parser.parse((ByteBuffer)ByteBuffer.wrap(extensionEnvelopeValue));
            Asn1ParseResult firstElement = (Asn1ParseResult)container.getChildren().get(0);
            Asn1OctetString octetString = new Asn1OctetString();
            octetString.decode(firstElement);
            extracted = (byte[])octetString.getValue();
        }
        catch (IOException | RuntimeException e) {
            throw new BadAttestationStatementException("Failed to extract nonce from Apple anonymous attestation statement.", e);
        }
        if (!Arrays.equals(extracted, nonce)) {
            throw new BadAttestationStatementException("nonce doesn't match.");
        }
    }

    private @NonNull byte[] getNonce(@NonNull CoreRegistrationObject registrationObject) {
        byte[] authenticatorData = registrationObject.getAuthenticatorDataBytes();
        byte[] clientDataHash = registrationObject.getClientDataHash();
        byte[] nonceToHash = ByteBuffer.allocate(authenticatorData.length + clientDataHash.length).put(authenticatorData).put(clientDataHash).array();
        return MessageDigestUtil.createSHA256().digest(nonceToHash);
    }

    private void validatePublicKey(@NonNull CoreRegistrationObject registrationObject, @NonNull AppleAnonymousAttestationStatement attestationStatement) {
        PublicKey publicKeyInCredentialData;
        PublicKey publicKeyInEndEntityCert = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate().getPublicKey();
        if (!publicKeyInEndEntityCert.equals(publicKeyInCredentialData = registrationObject.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getCOSEKey().getPublicKey())) {
            throw new PublicKeyMismatchException("The public key in the first certificate in x5c doesn't matches the credentialPublicKey in the attestedCredentialData in authenticatorData.");
        }
    }
}

