/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import oracle.jdbc.driver.PhasedPublisher;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;

final class BufferedPublisher<T>
extends PhasedPublisher<T> {
    private final AsyncQueue<T> itemQueue;
    private final Monitor monitor = Monitor.newInstance();
    private CompletableFuture<T> onNextFuture = null;
    private boolean isTerminated = false;
    private Throwable terminalError = null;

    private BufferedPublisher(int n2, Executor executor) {
        super(executor, null);
        this.itemQueue = new AsyncQueue(n2);
    }

    final CompletionStage<Void> offerItem(T t2) {
        return this.itemQueue.put(t2);
    }

    final void terminate(Throwable throwable) {
        try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
            this.isTerminated = true;
            this.terminalError = throwable;
            if (this.onNextFuture != null) {
                this.attemptTerminalSignal();
            }
        }
    }

    @Override
    protected final CompletionStage<T> advancePhaseAsync() {
        try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
            this.onNextFuture = this.itemQueue.take();
            if (this.isTerminated) {
                this.attemptTerminalSignal();
            }
            CompletableFuture<T> completableFuture = this.onNextFuture;
            return completableFuture;
        }
    }

    private void attemptTerminalSignal() {
        if (this.terminalError == null) {
            this.onNextFuture.complete(null);
        } else {
            this.onNextFuture.completeExceptionally(this.terminalError);
        }
    }

    static final <T> BufferedPublisher<T> newInstance(int n2, Executor executor) {
        return new BufferedPublisher<T>(n2, executor);
    }

    private static final class AsyncQueue<T> {
        private final Monitor queueMonitor = Monitor.newInstance();
        private final ArrayDeque<T> queue = new ArrayDeque();
        private final int maxQueueSize;
        private CompletableFuture<Void> putFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
        private CompletableFuture<Void> takeFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;

        private AsyncQueue(int n2) {
            this.maxQueueSize = n2;
        }

        private final CompletionStage<Void> put(T t2) {
            try (Monitor.CloseableLock closeableLock = this.queueMonitor.acquireCloseableLock();){
                assert (this.takeFuture.isDone()) : "Stage returned by previous put is not complete";
                this.queue.addLast(t2);
                this.putFuture.complete(null);
                if (this.queue.size() < this.maxQueueSize) {
                    CompletableFuture<Void> completableFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
                    return completableFuture;
                }
                this.takeFuture = new CompletableFuture<Void>();
                CompletableFuture<Void> completableFuture = this.takeFuture;
                return completableFuture;
            }
        }

        private final CompletableFuture<T> take() {
            try (Monitor.CloseableLock closeableLock = this.queueMonitor.acquireCloseableLock();){
                assert (this.putFuture.isDone()) : "Stage returned by previous take is not complete";
                T t2 = this.queue.pollFirst();
                this.takeFuture.complete(null);
                if (t2 != null) {
                    CompletableFuture<T> completableFuture = CompletableFuture.completedFuture(t2);
                    return completableFuture;
                }
                this.putFuture = new CompletableFuture();
                CompletionStage completionStage = this.putFuture.thenCompose(void_ -> this.take());
                return completionStage;
            }
        }
    }
}

