/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.clientscope;

import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientScopeProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.clientscope.MapClientScopeProvider;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.ProviderEvent;

public class MapClientScopeProviderFactory
extends AbstractMapProviderFactory<MapClientScopeProvider, MapClientScopeEntity, ClientScopeModel>
implements ClientScopeProviderFactory<MapClientScopeProvider>,
InvalidationHandler {
    public MapClientScopeProviderFactory() {
        super(ClientScopeModel.class, MapClientScopeProvider.class);
    }

    @Override
    public MapClientScopeProvider createNew(KeycloakSession session) {
        return new MapClientScopeProvider(session, this.getStorage(session));
    }

    public String getHelpText() {
        return "Client scope provider";
    }

    public void invalidate(final KeycloakSession session, InvalidationHandler.InvalidableObjectType type, final Object ... params) {
        if (type == AbstractMapProviderFactory.MapProviderObjectType.REALM_BEFORE_REMOVE) {
            ((MapClientScopeProvider)this.create(session)).preRemove((RealmModel)params[0]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.CLIENT_SCOPE_BEFORE_REMOVE) {
            ((RealmModel)params[0]).removeDefaultClientScope((ClientScopeModel)params[1]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.CLIENT_SCOPE_AFTER_REMOVE) {
            session.getKeycloakSessionFactory().publish((ProviderEvent)new ClientScopeModel.ClientScopeRemovedEvent(){

                public ClientScopeModel getClientScope() {
                    return (ClientScopeModel)params[0];
                }

                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }
    }
}

