/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.common;

import java.io.IOException;
import java.util.HashSet;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.SinglePortServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.router.router.impl.singleport.SinglePortEndpointRouter;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.routes.singleport.SinglePortRouteSource;

public class HotRodUtils {
    public static final int DEFAULT_MAX_RESULTS = 0x3FFFFFFF;

    public static void createHotRodMapStoreServer(HotRodServer hotRodServer, DefaultCacheManager hotRodCacheManager, int embeddedPort) {
        HotRodServerConfigurationBuilder hotRodServerConfigurationBuilder = new HotRodServerConfigurationBuilder();
        hotRodServerConfigurationBuilder.startTransport(false);
        hotRodServerConfigurationBuilder.port(embeddedPort);
        hotRodServer.start((ProtocolServerConfiguration)hotRodServerConfigurationBuilder.build(), (EmbeddedCacheManager)hotRodCacheManager);
        RestServerConfigurationBuilder restServerConfigurationBuilder = new RestServerConfigurationBuilder();
        restServerConfigurationBuilder.startTransport(false);
        restServerConfigurationBuilder.port(embeddedPort);
        RestServer restServer = new RestServer();
        restServer.start((ProtocolServerConfiguration)restServerConfigurationBuilder.build(), (EmbeddedCacheManager)hotRodCacheManager);
        SinglePortRouteSource routeSource = new SinglePortRouteSource();
        HashSet<Route> routes = new HashSet<Route>();
        routes.add(new Route((RouteSource)routeSource, (RouteDestination)new HotRodServerRouteDestination("hotrod", hotRodServer)));
        routes.add(new Route((RouteSource)routeSource, (RouteDestination)new RestServerRouteDestination("rest", restServer)));
        SinglePortRouterConfiguration singlePortRouter = ((SinglePortServerConfigurationBuilder)new SinglePortServerConfigurationBuilder().port(embeddedPort)).build();
        SinglePortEndpointRouter endpointServer = new SinglePortEndpointRouter(singlePortRouter);
        endpointServer.start(new RoutingTable(routes));
    }

    public static void createHotRodMapStoreServer(int embeddedPort) {
        DefaultCacheManager hotRodCacheManager = null;
        try {
            hotRodCacheManager = new DefaultCacheManager("config/infinispan.xml");
        }
        catch (IOException e) {
            new RuntimeException("Cannot initialize cache manager!", e);
        }
        HotRodUtils.createHotRodMapStoreServer(new HotRodServer(), hotRodCacheManager, embeddedPort);
    }

    public static <T> Query<T> paginateQuery(Query<T> query, Integer first, Integer max) {
        if (first != null && first > 0) {
            query = query.startOffset((long)first.intValue());
            if (max == null || max < 0) {
                max = 0x3FFFFFFF;
            }
        }
        if (max != null && max >= 0) {
            query = query.maxResults(max.intValue());
        }
        return query;
    }
}

