/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.hibernate.listeners;

import org.hibernate.HibernateException;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.keycloak.models.map.storage.jpa.JpaChildEntity;
import org.keycloak.models.map.storage.jpa.JpaRootEntity;

public class JpaEntityVersionListener
implements PreInsertEventListener,
PreDeleteEventListener,
PreUpdateEventListener {
    public static final JpaEntityVersionListener INSTANCE = new JpaEntityVersionListener();

    public void updateEntityVersion(Object entity) throws HibernateException {
        Object root = entity;
        while (root instanceof JpaChildEntity) {
            root = ((JpaChildEntity)entity).getParent();
        }
        if (root instanceof JpaRootEntity) {
            ((JpaRootEntity)root).updateEntityVersion();
        }
    }

    public boolean onPreInsert(PreInsertEvent event) {
        this.updateEntityVersion(event.getEntity());
        return false;
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        this.updateEntityVersion(event.getEntity());
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        this.updateEntityVersion(event.getEntity());
        return false;
    }
}

