/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.user.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UuidValidator;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaAttributeEntity;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserAttributeEntity;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserConsentEntity;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserFederatedIdentityEntity;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserMetadata;
import org.keycloak.models.map.user.MapUserConsentEntity;
import org.keycloak.models.map.user.MapUserCredentialEntity;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.MapUserFederatedIdentityEntity;

@Entity
@Table(name="kc_user", uniqueConstraints={@UniqueConstraint(columnNames={"realmId", "username"}), @UniqueConstraint(columnNames={"realmId", "emailConstraint"})})
@TypeDefs(value={@TypeDef(name="jsonb", typeClass=JsonbType.class)})
public class JpaUserEntity
extends MapUserEntity.AbstractUserEntity
implements JpaRootVersionedEntity,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    private UUID id;
    @Version
    @Column
    private int version;
    @Type(type="jsonb")
    @Column(columnDefinition="jsonb")
    private final JpaUserMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String realmId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String username;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String firstName;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String lastName;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String email;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String emailConstraint;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String federationLink;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private Boolean enabled;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private Boolean emailVerified;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private Long timestamp;
    @Column(name="group_id")
    @ElementCollection
    @CollectionTable(name="kc_user_group", joinColumns={@JoinColumn(name="user_id", nullable=false)})
    private final Set<String> groupIds;
    @Column(name="role_id")
    @ElementCollection
    @CollectionTable(name="kc_user_role", joinColumns={@JoinColumn(name="user_id", nullable=false)})
    private final Set<String> roleIds;
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    private final Set<JpaUserAttributeEntity> attributes;
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    private final Set<JpaUserConsentEntity> consents;
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    private final Set<JpaUserFederatedIdentityEntity> federatedIdentities;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaUserEntity() {
        this.$$_hibernate_write_groupIds(new HashSet());
        this.$$_hibernate_write_roleIds(new HashSet());
        this.$$_hibernate_write_attributes(new HashSet());
        this.$$_hibernate_write_consents(new HashSet());
        this.$$_hibernate_write_federatedIdentities(new HashSet());
        this.$$_hibernate_write_metadata(new JpaUserMetadata());
    }

    public JpaUserEntity(DeepCloner cloner) {
        this.$$_hibernate_write_groupIds(new HashSet());
        this.$$_hibernate_write_roleIds(new HashSet());
        this.$$_hibernate_write_attributes(new HashSet());
        this.$$_hibernate_write_consents(new HashSet());
        this.$$_hibernate_write_federatedIdentities(new HashSet());
        this.$$_hibernate_write_metadata(new JpaUserMetadata(cloner));
    }

    public JpaUserEntity(UUID id, int version, Integer entityVersion, String realmId, String username, String firstName, String lastName, String email, String emailConstraint, String federationLink, Boolean enabled, Boolean emailVerified, Long timestamp) {
        this.$$_hibernate_write_groupIds(new HashSet());
        this.$$_hibernate_write_roleIds(new HashSet());
        this.$$_hibernate_write_attributes(new HashSet());
        this.$$_hibernate_write_consents(new HashSet());
        this.$$_hibernate_write_federatedIdentities(new HashSet());
        this.$$_hibernate_write_id(id);
        this.$$_hibernate_write_version(version);
        this.$$_hibernate_write_entityVersion(entityVersion);
        this.$$_hibernate_write_realmId(realmId);
        this.$$_hibernate_write_username(username);
        this.$$_hibernate_write_firstName(firstName);
        this.$$_hibernate_write_lastName(lastName);
        this.$$_hibernate_write_email(email);
        this.$$_hibernate_write_emailConstraint(emailConstraint);
        this.$$_hibernate_write_federationLink(federationLink);
        this.$$_hibernate_write_enabled(enabled);
        this.$$_hibernate_write_emailVerified(emailVerified);
        this.$$_hibernate_write_timestamp(timestamp);
        this.$$_hibernate_write_metadata(null);
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_USER;
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        String validatedId = UuidValidator.validateAndConvert((String)id);
        this.$$_hibernate_write_id(UUID.fromString(validatedId));
    }

    public String getRealmId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getRealmId();
        }
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_read_metadata().setRealmId(realmId);
    }

    public String getUsername() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getUsername();
        }
        return this.$$_hibernate_read_username();
    }

    public void setUsername(String username) {
        this.$$_hibernate_read_metadata().setUsername(username);
    }

    public String getFirstName() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getFirstName();
        }
        return this.$$_hibernate_read_firstName();
    }

    public void setFirstName(String firstName) {
        this.$$_hibernate_read_metadata().setFirstName(firstName);
    }

    public Long getCreatedTimestamp() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getCreatedTimestamp();
        }
        return this.$$_hibernate_read_timestamp();
    }

    public void setCreatedTimestamp(Long createdTimestamp) {
        this.$$_hibernate_read_metadata().setCreatedTimestamp(createdTimestamp);
    }

    public String getLastName() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getLastName();
        }
        return this.$$_hibernate_read_lastName();
    }

    public void setLastName(String lastName) {
        this.$$_hibernate_read_metadata().setLastName(lastName);
    }

    public String getEmail() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEmail();
        }
        return this.$$_hibernate_read_email();
    }

    public void setEmail(String email) {
        this.$$_hibernate_read_metadata().setEmail(email);
    }

    public Boolean isEnabled() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().isEnabled();
        }
        return this.$$_hibernate_read_enabled();
    }

    public void setEnabled(Boolean enabled) {
        this.$$_hibernate_read_metadata().setEnabled(enabled);
    }

    public Boolean isEmailVerified() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().isEmailVerified();
        }
        return this.$$_hibernate_read_emailVerified();
    }

    public void setEmailVerified(Boolean emailVerified) {
        this.$$_hibernate_read_metadata().setEmailVerified(emailVerified);
    }

    public String getEmailConstraint() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEmailConstraint();
        }
        return this.$$_hibernate_read_emailConstraint();
    }

    public void setEmailConstraint(String emailConstraint) {
        this.$$_hibernate_read_metadata().setEmailConstraint(emailConstraint);
    }

    public String getFederationLink() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getFederationLink();
        }
        return this.$$_hibernate_read_federationLink();
    }

    public void setFederationLink(String federationLink) {
        this.$$_hibernate_read_metadata().setFederationLink(federationLink);
    }

    public String getServiceAccountClientLink() {
        return this.$$_hibernate_read_metadata().getServiceAccountClientLink();
    }

    public void setServiceAccountClientLink(String serviceAccountClientLink) {
        this.$$_hibernate_read_metadata().setServiceAccountClientLink(serviceAccountClientLink);
    }

    public Long getNotBefore() {
        return this.$$_hibernate_read_metadata().getNotBefore();
    }

    public void setNotBefore(Long notBefore) {
        this.$$_hibernate_read_metadata().setNotBefore(notBefore);
    }

    public Set<String> getGroupsMembership() {
        return this.$$_hibernate_read_groupIds();
    }

    public void setGroupsMembership(Set<String> groupsMembership) {
        this.$$_hibernate_read_groupIds().clear();
        if (groupsMembership != null) {
            this.$$_hibernate_read_groupIds().addAll(groupsMembership);
        }
    }

    public void addGroupsMembership(String groupId) {
        this.$$_hibernate_read_groupIds().add(groupId);
    }

    public void removeGroupsMembership(String groupId) {
        this.$$_hibernate_read_groupIds().remove(groupId);
    }

    public Set<String> getRolesMembership() {
        return this.$$_hibernate_read_roleIds();
    }

    public void setRolesMembership(Set<String> rolesMembership) {
        this.$$_hibernate_read_roleIds().clear();
        if (rolesMembership != null) {
            this.$$_hibernate_read_roleIds().addAll(rolesMembership);
        }
    }

    public void addRolesMembership(String roleId) {
        this.$$_hibernate_read_roleIds().add(roleId);
    }

    public void removeRolesMembership(String roleId) {
        this.$$_hibernate_read_roleIds().remove(roleId);
    }

    public Set<String> getRequiredActions() {
        return this.$$_hibernate_read_metadata().getRequiredActions();
    }

    public void setRequiredActions(Set<String> requiredActions) {
        this.$$_hibernate_read_metadata().setRequiredActions(requiredActions);
    }

    public void addRequiredAction(String requiredAction) {
        this.$$_hibernate_read_metadata().addRequiredAction(requiredAction);
    }

    public void removeRequiredAction(String requiredAction) {
        this.$$_hibernate_read_metadata().removeRequiredAction(requiredAction);
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (JpaUserAttributeEntity attribute : this.$$_hibernate_read_attributes()) {
            List values = result.getOrDefault(attribute.getName(), new LinkedList());
            values.add(attribute.getValue());
            result.put(attribute.getName(), values);
        }
        return result;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.$$_hibernate_read_attributes().clear();
        if (attributes != null) {
            attributes.forEach(this::setAttribute);
        }
    }

    public List<String> getAttribute(String name) {
        return this.$$_hibernate_read_attributes().stream().filter(a -> Objects.equals(a.getName(), name)).map(JpaAttributeEntity::getValue).collect(Collectors.toList());
    }

    public void setAttribute(String name, List<String> values) {
        this.removeAttribute(name);
        if (values != null) {
            values.forEach(value -> this.$$_hibernate_read_attributes().add(new JpaUserAttributeEntity(this, name, (String)value)));
        }
    }

    public void removeAttribute(String name) {
        this.$$_hibernate_read_attributes().removeIf(attr -> Objects.equals(attr.getName(), name));
    }

    public Set<MapUserConsentEntity> getUserConsents() {
        return this.$$_hibernate_read_consents().stream().map(MapUserConsentEntity.class::cast).collect(Collectors.toSet());
    }

    public void setUserConsents(Set<MapUserConsentEntity> userConsents) {
        this.$$_hibernate_read_consents().clear();
        if (userConsents != null) {
            userConsents.forEach(this::addUserConsent);
        }
    }

    public void addUserConsent(MapUserConsentEntity userConsentEntity) {
        JpaUserConsentEntity entity = (JpaUserConsentEntity)JpaMapStorageProviderFactory.CLONER.from((Object)userConsentEntity);
        entity.setParent(this);
        entity.setEntityVersion(this.getEntityVersion());
        this.$$_hibernate_read_consents().add(entity);
    }

    public Boolean removeUserConsent(MapUserConsentEntity userConsentEntity) {
        return this.$$_hibernate_read_consents().removeIf(uc -> Objects.equals(uc.getClientId(), userConsentEntity.getClientId()));
    }

    public Boolean removeUserConsent(String clientId) {
        return this.$$_hibernate_read_consents().removeIf(uc -> Objects.equals(uc.getClientId(), clientId));
    }

    public List<MapUserCredentialEntity> getCredentials() {
        return this.$$_hibernate_read_metadata().getCredentials();
    }

    public void setCredentials(List<MapUserCredentialEntity> credentials) {
        this.$$_hibernate_read_metadata().setCredentials(credentials);
    }

    public void addCredential(MapUserCredentialEntity credentialEntity) {
        this.$$_hibernate_read_metadata().addCredential(credentialEntity);
    }

    public Boolean removeCredential(MapUserCredentialEntity credentialEntity) {
        return super.removeCredential(credentialEntity.getId());
    }

    public Set<MapUserFederatedIdentityEntity> getFederatedIdentities() {
        return this.$$_hibernate_read_federatedIdentities().stream().map(MapUserFederatedIdentityEntity.class::cast).collect(Collectors.toSet());
    }

    public void setFederatedIdentities(Set<MapUserFederatedIdentityEntity> federatedIdentities) {
        this.$$_hibernate_read_federatedIdentities().clear();
        if (federatedIdentities != null) {
            federatedIdentities.forEach(this::addFederatedIdentity);
        }
    }

    public void addFederatedIdentity(MapUserFederatedIdentityEntity federatedIdentity) {
        JpaUserFederatedIdentityEntity entity = (JpaUserFederatedIdentityEntity)JpaMapStorageProviderFactory.CLONER.from((Object)federatedIdentity);
        entity.setParent(this);
        entity.setEntityVersion(this.getEntityVersion());
        this.$$_hibernate_read_federatedIdentities().add(entity);
    }

    public Boolean removeFederatedIdentity(MapUserFederatedIdentityEntity federatedIdentity) {
        return this.$$_hibernate_read_federatedIdentities().removeIf(fi -> Objects.equals(fi.getIdentityProvider(), federatedIdentity.getIdentityProvider()));
    }

    public Boolean removeFederatedIdentity(String identityProviderId) {
        return this.$$_hibernate_read_federatedIdentities().removeIf(fi -> Objects.equals(fi.getIdentityProvider(), identityProviderId));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaUserEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaUserEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public JpaUserMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaUserMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public void $$_hibernate_write_metadata(JpaUserMetadata jpaUserMetadata) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaUserMetadata)this.$$_hibernate_getInterceptor().writeObject((Object)this, "metadata", (Object)this.metadata, (Object)jpaUserMetadata);
            return;
        }
        this.metadata = jpaUserMetadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public String $$_hibernate_read_username() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.username = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "username", (Object)this.username);
        }
        return this.username;
    }

    public void $$_hibernate_write_username(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.username = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "username", (Object)this.username, (Object)string);
            return;
        }
        this.username = string;
    }

    public String $$_hibernate_read_firstName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.firstName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "firstName", (Object)this.firstName);
        }
        return this.firstName;
    }

    public void $$_hibernate_write_firstName(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.firstName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "firstName", (Object)this.firstName, (Object)string);
            return;
        }
        this.firstName = string;
    }

    public String $$_hibernate_read_lastName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastName", (Object)this.lastName);
        }
        return this.lastName;
    }

    public void $$_hibernate_write_lastName(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastName", (Object)this.lastName, (Object)string);
            return;
        }
        this.lastName = string;
    }

    public String $$_hibernate_read_email() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.email = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "email", (Object)this.email);
        }
        return this.email;
    }

    public void $$_hibernate_write_email(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.email = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "email", (Object)this.email, (Object)string);
            return;
        }
        this.email = string;
    }

    public String $$_hibernate_read_emailConstraint() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailConstraint = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "emailConstraint", (Object)this.emailConstraint);
        }
        return this.emailConstraint;
    }

    public void $$_hibernate_write_emailConstraint(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailConstraint = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "emailConstraint", (Object)this.emailConstraint, (Object)string);
            return;
        }
        this.emailConstraint = string;
    }

    public String $$_hibernate_read_federationLink() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federationLink = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "federationLink", (Object)this.federationLink);
        }
        return this.federationLink;
    }

    public void $$_hibernate_write_federationLink(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federationLink = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "federationLink", (Object)this.federationLink, (Object)string);
            return;
        }
        this.federationLink = string;
    }

    public Boolean $$_hibernate_read_enabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = (Boolean)this.$$_hibernate_getInterceptor().readObject((Object)this, "enabled", (Object)this.enabled);
        }
        return this.enabled;
    }

    public void $$_hibernate_write_enabled(Boolean bl) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = (Boolean)this.$$_hibernate_getInterceptor().writeObject((Object)this, "enabled", (Object)this.enabled, (Object)bl);
            return;
        }
        this.enabled = bl;
    }

    public Boolean $$_hibernate_read_emailVerified() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailVerified = (Boolean)this.$$_hibernate_getInterceptor().readObject((Object)this, "emailVerified", (Object)this.emailVerified);
        }
        return this.emailVerified;
    }

    public void $$_hibernate_write_emailVerified(Boolean bl) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailVerified = (Boolean)this.$$_hibernate_getInterceptor().writeObject((Object)this, "emailVerified", (Object)this.emailVerified, (Object)bl);
            return;
        }
        this.emailVerified = bl;
    }

    public Long $$_hibernate_read_timestamp() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.timestamp = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "timestamp", (Object)this.timestamp);
        }
        return this.timestamp;
    }

    public void $$_hibernate_write_timestamp(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.timestamp = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "timestamp", (Object)this.timestamp, (Object)l);
            return;
        }
        this.timestamp = l;
    }

    public Set $$_hibernate_read_groupIds() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.groupIds = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "groupIds", this.groupIds);
        }
        return this.groupIds;
    }

    public void $$_hibernate_write_groupIds(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.groupIds = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "groupIds", this.groupIds, (Object)set);
            return;
        }
        this.groupIds = set;
    }

    public Set $$_hibernate_read_roleIds() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.roleIds = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "roleIds", this.roleIds);
        }
        return this.roleIds;
    }

    public void $$_hibernate_write_roleIds(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.roleIds = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "roleIds", this.roleIds, (Object)set);
            return;
        }
        this.roleIds = set;
    }

    public Set $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)set);
            return;
        }
        this.attributes = set;
    }

    public Set $$_hibernate_read_consents() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.consents = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "consents", this.consents);
        }
        return this.consents;
    }

    public void $$_hibernate_write_consents(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.consents = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "consents", this.consents, (Object)set);
            return;
        }
        this.consents = set;
    }

    public Set $$_hibernate_read_federatedIdentities() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federatedIdentities = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "federatedIdentities", this.federatedIdentities);
        }
        return this.federatedIdentities;
    }

    public void $$_hibernate_write_federatedIdentities(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federatedIdentities = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "federatedIdentities", this.federatedIdentities, (Object)set);
            return;
        }
        this.federatedIdentities = set;
    }
}

