/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.configuration.builder;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.configuration.builder.ConfigurationBuilderParent;
import org.infinispan.server.router.configuration.builder.HotRodRouterBuilder;
import org.infinispan.server.router.configuration.builder.RestRouterBuilder;
import org.infinispan.server.router.configuration.builder.SinglePortRouterBuilder;
import org.infinispan.server.router.logging.RouterLogger;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;

public class RoutingBuilder
implements ConfigurationBuilderParent {
    protected static final RouterLogger logger = (RouterLogger)LogFactory.getLog(MethodHandles.lookup().lookupClass(), RouterLogger.class);
    private final ConfigurationBuilderParent parent;
    private Set<Route<? extends RouteSource, ? extends RouteDestination>> routes = new HashSet<Route<? extends RouteSource, ? extends RouteDestination>>();

    public RoutingBuilder(ConfigurationBuilderParent parent) {
        this.parent = parent;
    }

    public <Source extends RouteSource, Destination extends RouteDestination> RoutingBuilder add(Route<Source, Destination> route) {
        this.routes.add(route);
        return this;
    }

    protected RoutingTable build() {
        try {
            this.routes.forEach(r -> r.validate());
        }
        catch (Exception e) {
            throw logger.configurationValidationError(e);
        }
        return new RoutingTable(this.routes);
    }

    @Override
    public RoutingBuilder routing() {
        return this.parent.routing();
    }

    @Override
    public HotRodRouterBuilder hotrod() {
        return this.parent.hotrod();
    }

    @Override
    public RestRouterBuilder rest() {
        return this.parent.rest();
    }

    @Override
    public SinglePortRouterBuilder singlePort() {
        return this.parent.singlePort();
    }
}

