/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.console;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.ConsoleCommandBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.console.ConsoleCliManager;
import io.quarkus.deployment.console.ConsoleCommand;
import io.quarkus.deployment.console.ConsoleConfig;
import io.quarkus.deployment.console.ConsoleHelper;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.ConsoleStateManager;
import io.quarkus.deployment.dev.ExceptionNotificationBuildItem;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.deployment.dev.testing.TestConsoleHandler;
import io.quarkus.deployment.dev.testing.TestListenerBuildItem;
import io.quarkus.deployment.dev.testing.TestSetupBuildItem;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.ide.Ide;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.runtime.console.ConsoleRuntimeConfig;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.invocation.CommandInvocation;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class ConsoleProcessor {
    private static final Logger log = Logger.getLogger(ConsoleProcessor.class);
    private static boolean consoleInstalled = false;
    static volatile ConsoleStateManager.ConsoleContext context;

    @BuildStep(onlyIf={IsDevelopment.class})
    @Produce(value=TestSetupBuildItem.class)
    ConsoleInstalledBuildItem setupConsole(TestConfig config, BuildProducer<TestListenerBuildItem> testListenerBuildItemBuildProducer, LaunchModeBuildItem launchModeBuildItem, ConsoleConfig consoleConfig) {
        if (consoleInstalled) {
            return ConsoleInstalledBuildItem.INSTANCE;
        }
        consoleInstalled = true;
        if (config.console.orElse(consoleConfig.enabled).booleanValue()) {
            ConsoleRuntimeConfig consoleRuntimeConfig = new ConsoleRuntimeConfig();
            consoleRuntimeConfig.color = ConfigProvider.getConfig().getOptionalValue("quarkus.console.color", Boolean.class);
            io.quarkus.runtime.logging.ConsoleConfig loggingConsoleConfig = new io.quarkus.runtime.logging.ConsoleConfig();
            loggingConsoleConfig.color = ConfigProvider.getConfig().getOptionalValue("quarkus.log.console.color", Boolean.class);
            ConsoleHelper.installConsole(config, consoleConfig, consoleRuntimeConfig, loggingConsoleConfig, launchModeBuildItem.isTest());
            ConsoleStateManager.init(QuarkusConsole.INSTANCE, launchModeBuildItem.getDevModeType().get());
            if (TestSupport.instance().isEmpty() || config.continuousTesting == TestConfig.Mode.DISABLED || config.flatClassPath) {
                return ConsoleInstalledBuildItem.INSTANCE;
            }
            TestConsoleHandler consoleHandler = new TestConsoleHandler(launchModeBuildItem.getDevModeType().get());
            consoleHandler.install();
            testListenerBuildItemBuildProducer.produce(new TestListenerBuildItem(consoleHandler));
        }
        return ConsoleInstalledBuildItem.INSTANCE;
    }

    @Consume(value=ConsoleInstalledBuildItem.class)
    @BuildStep
    void setupExceptionHandler(BuildProducer<ExceptionNotificationBuildItem> exceptionNotificationBuildItem, final EffectiveIdeBuildItem ideSupport, LaunchModeBuildItem launchModeBuildItem) {
        if (launchModeBuildItem.isAuxiliaryApplication()) {
            return;
        }
        final AtomicReference lastUserCode = new AtomicReference();
        exceptionNotificationBuildItem.produce(new ExceptionNotificationBuildItem(new BiConsumer<Throwable, StackTraceElement>(){

            @Override
            public void accept(Throwable throwable, StackTraceElement stackTraceElement) {
                lastUserCode.set(stackTraceElement);
            }
        }));
        if (context == null) {
            context = ConsoleStateManager.INSTANCE.createContext("Exceptions");
        }
        context.reset(new ConsoleCommand('x', "Opens last exception in IDE", new ConsoleCommand.HelpState(new Supplier<String>(){

            @Override
            public String get() {
                return "\u001b[91m";
            }
        }, new Supplier<String>(){

            @Override
            public String get() {
                StackTraceElement throwable = (StackTraceElement)lastUserCode.get();
                if (throwable == null) {
                    return "None";
                }
                return throwable.getFileName() + ":" + throwable.getLineNumber();
            }
        }), new Runnable(){

            @Override
            public void run() {
                Path fileName;
                StackTraceElement throwable = (StackTraceElement)lastUserCode.get();
                if (throwable == null) {
                    return;
                }
                String className = throwable.getClassName();
                Object file = throwable.getFileName();
                if (className.contains(".")) {
                    file = className.substring(0, className.lastIndexOf(46) + 1).replace('.', File.separatorChar) + (String)file;
                }
                if ((fileName = Ide.findSourceFile((String)file)) == null) {
                    log.error((Object)("Unable to find file: " + (String)file));
                    return;
                }
                List<String> args = ideSupport.getIde().createFileOpeningArgs(fileName.toAbsolutePath().toString(), "" + throwable.getLineNumber());
                ConsoleProcessor.this.launchInIDE(ideSupport.getIde(), args);
            }
        }));
    }

    protected void launchInIDE(final Ide ide, final List<String> args) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String effectiveCommand = ide.getEffectiveCommand();
                    if (effectiveCommand == null || effectiveCommand.isEmpty()) {
                        log.debug((Object)("Unable to determine proper launch command for IDE: " + ide));
                        return;
                    }
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(effectiveCommand);
                    command.addAll(args);
                    log.debugf("Opening IDE with %s", command);
                    new ProcessBuilder(command).redirectOutput(ProcessBuilder.Redirect.DISCARD).redirectError(ProcessBuilder.Redirect.DISCARD).start().waitFor(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to open IDE", (Throwable)e);
                }
            }
        }, "Launch in IDE Action").start();
    }

    @BuildStep
    @Produce(value=ServiceStartBuildItem.class)
    void installCliCommands(List<ConsoleCommandBuildItem> commands) {
        ConsoleCliManager.setCommands(commands.stream().map(ConsoleCommandBuildItem::getConsoleCommand).collect(Collectors.toList()));
    }

    @BuildStep
    ConsoleCommandBuildItem quitCommand() {
        return new ConsoleCommandBuildItem(new QuitCommand());
    }

    @BuildStep
    ConsoleCommandBuildItem helpCommand() {
        return new ConsoleCommandBuildItem(new HelpCommand());
    }

    @CommandDefinition(name="help", description="Displays the command list", aliases={"h"})
    public static class HelpCommand
    implements Command {
        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            commandInvocation.getShell().writeln("The following commands are available, run them with -h for more info:\n");
            for (CommandContainer c : ConsoleCliManager.commands) {
                commandInvocation.getShell().writeln(c.getParser().getProcessedCommand().name() + "\t" + c.getParser().getProcessedCommand().description());
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="quit", description="Quits the console", aliases={"q"})
    public static class QuitCommand
    implements Command {
        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            QuarkusConsole.INSTANCE.exitCliMode();
            return CommandResult.SUCCESS;
        }
    }
}

