/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import io.quarkus.deployment.util.FileUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jboss.logging.Logger;

public final class ContainerRuntimeUtil {
    private static final Logger log = Logger.getLogger(ContainerRuntimeUtil.class);

    private ContainerRuntimeUtil() {
    }

    public static ContainerRuntime detectContainerRuntime() {
        String dockerVersionOutput = ContainerRuntimeUtil.getVersionOutputFor(ContainerRuntime.DOCKER);
        boolean dockerAvailable = dockerVersionOutput.contains("Docker version");
        String podmanVersionOutput = ContainerRuntimeUtil.getVersionOutputFor(ContainerRuntime.PODMAN);
        boolean podmanAvailable = podmanVersionOutput.startsWith("podman version");
        if (dockerAvailable) {
            if (dockerVersionOutput.equals(podmanVersionOutput)) {
                return ContainerRuntime.PODMAN;
            }
            return ContainerRuntime.DOCKER;
        }
        if (podmanAvailable) {
            return ContainerRuntime.PODMAN;
        }
        throw new IllegalStateException("No container runtime was found to. Make sure you have Docker or Podman installed in your environment.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionOutputFor(ContainerRuntime containerRuntime) {
        Process versionProcess = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(containerRuntime.getExecutableName(), "--version").redirectErrorStream(true);
            versionProcess = pb.start();
            versionProcess.waitFor();
            String string = new String(FileUtil.readFileContents(versionProcess.getInputStream()), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException | InterruptedException e) {
            log.debugf((Throwable)e, "Failure to read version output from %s", (Object)containerRuntime.getExecutableName());
            String string = "";
            return string;
        }
        finally {
            if (versionProcess != null) {
                versionProcess.destroy();
            }
        }
    }

    public static enum ContainerRuntime {
        DOCKER,
        PODMAN;


        public String getExecutableName() {
            return this.name().toLowerCase();
        }
    }
}

