/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.EncoderEntryMapper;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.CacheFilters;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.DistributedQueueingSegmentListener;
import org.infinispan.notifications.cachelistener.EventWrapper;
import org.infinispan.notifications.cachelistener.ListenerHolder;
import org.infinispan.notifications.cachelistener.QueueingAllSegmentListener;
import org.infinispan.notifications.cachelistener.QueueingSegmentListener;
import org.infinispan.notifications.cachelistener.SecurityActions;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.annotation.PartitionStatusChanged;
import org.infinispan.notifications.cachelistener.annotation.PersistenceAvailabilityChanged;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ClusterEvent;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerRemoveCallable;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerReplicateCallable;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.PartitionStatusChangedEvent;
import org.infinispan.notifications.cachelistener.event.PersistenceAvailabilityChangedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.notifications.cachelistener.event.impl.EventImpl;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterAsConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterAsKeyValueFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterAsKeyValueFilterConverter;
import org.infinispan.notifications.cachelistener.filter.DelegatingCacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.notifications.cachelistener.filter.FilterIndexingServiceProvider;
import org.infinispan.notifications.cachelistener.filter.IndexedFilter;
import org.infinispan.notifications.impl.AbstractListenerImpl;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.reactive.publisher.PublisherTransformers;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.SegmentCompletionPublisher;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.stream.impl.CacheIntermediatePublisher;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.intops.object.FilterOperation;
import org.infinispan.stream.impl.intops.object.MapOperation;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class CacheNotifierImpl<K, V>
extends AbstractListenerImpl<Event<K, V>, CacheEntryListenerInvocation<K, V>>
implements ClusterCacheNotifier<K, V> {
    private static final Log log = LogFactory.getLog(CacheNotifierImpl.class);
    private static final Map<Class<? extends Annotation>, Class<?>> allowedListeners = new HashMap(16);
    private static final Map<Class<? extends Annotation>, Class<?>> clusterAllowedListeners = new HashMap(4);
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryCreatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryRemovedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryVisitedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryModifiedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryActivatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryPassivatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryLoadedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryInvalidatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryExpiredListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntriesEvictedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> transactionRegisteredListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> transactionCompletedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> dataRehashedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> topologyChangedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> partitionChangedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> persistenceChangedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    @Inject
    TransactionManager transactionManager;
    @Inject
    Configuration config;
    @Inject
    GlobalConfiguration globalConfiguration;
    @Inject
    InternalEntryFactory entryFactory;
    @Inject
    ClusterEventManager<K, V> eventManager;
    @Inject
    BasicComponentRegistry componentRegistry;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    RpcManager rpcManager;
    @Inject
    EncoderRegistry encoderRegistry;
    @Inject
    ComponentRef<AdvancedCache<K, V>> cache;
    @Inject
    ComponentRef<ClusteringDependentLogic> clusteringDependentLogic;
    @Inject
    ComponentRef<AsyncInterceptorChain> interceptorChain;
    @Inject
    ComponentRef<ClusterPublisherManager<K, V>> publisherManager;
    private ClusterExecutor clusterExecutor;
    private final Map<Object, UUID> clusterListenerIDs = new ConcurrentHashMap<Object, UUID>();
    private Collection<FilterIndexingServiceProvider> filterIndexingServiceProviders;
    private final ConcurrentMap<UUID, QueueingSegmentListener<K, V, ? extends Event<K, V>>> segmentHandler;

    public CacheNotifierImpl() {
        this(new ConcurrentHashMap<UUID, QueueingSegmentListener<K, V, ? extends Event<K, V>>>());
    }

    CacheNotifierImpl(ConcurrentMap<UUID, QueueingSegmentListener<K, V, ? extends Event<K, V>>> handler) {
        this.segmentHandler = handler;
        this.listenersMap.put(CacheEntryCreated.class, this.cacheEntryCreatedListeners);
        this.listenersMap.put(CacheEntryRemoved.class, this.cacheEntryRemovedListeners);
        this.listenersMap.put(CacheEntryVisited.class, this.cacheEntryVisitedListeners);
        this.listenersMap.put(CacheEntryModified.class, this.cacheEntryModifiedListeners);
        this.listenersMap.put(CacheEntryActivated.class, this.cacheEntryActivatedListeners);
        this.listenersMap.put(CacheEntryPassivated.class, this.cacheEntryPassivatedListeners);
        this.listenersMap.put(CacheEntryLoaded.class, this.cacheEntryLoadedListeners);
        this.listenersMap.put(CacheEntriesEvicted.class, this.cacheEntriesEvictedListeners);
        this.listenersMap.put(CacheEntryExpired.class, this.cacheEntryExpiredListeners);
        this.listenersMap.put(TransactionRegistered.class, this.transactionRegisteredListeners);
        this.listenersMap.put(TransactionCompleted.class, this.transactionCompletedListeners);
        this.listenersMap.put(CacheEntryInvalidated.class, this.cacheEntryInvalidatedListeners);
        this.listenersMap.put(DataRehashed.class, this.dataRehashedListeners);
        this.listenersMap.put(TopologyChanged.class, this.topologyChangedListeners);
        this.listenersMap.put(PartitionStatusChanged.class, this.partitionChangedListeners);
        this.listenersMap.put(PersistenceAvailabilityChanged.class, this.persistenceChangedListeners);
    }

    @Start(priority=9)
    public void start() {
        if (!this.config.simpleCache()) {
            this.clusterExecutor = SecurityActions.getClusterExecutor((Cache)this.cache.wired());
        }
        Collection providers = ServiceFinder.load(FilterIndexingServiceProvider.class, (ClassLoader[])new ClassLoader[0]);
        this.filterIndexingServiceProviders = new ArrayList<FilterIndexingServiceProvider>(providers.size());
        for (FilterIndexingServiceProvider provider : providers) {
            this.componentRegistry.wireDependencies(provider, false);
            provider.start();
            this.filterIndexingServiceProviders.add(provider);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.clusterListenerIDs.clear();
        if (this.filterIndexingServiceProviders != null) {
            for (FilterIndexingServiceProvider provider : this.filterIndexingServiceProviders) {
                provider.stop();
            }
            this.filterIndexingServiceProviders = null;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations(Listener l) {
        if (l.clustered()) {
            return clusterAllowedListeners;
        }
        return allowedListeners;
    }

    private K convertKey(CacheEntryListenerInvocation listenerInvocation, K key) {
        MediaType convertFormat;
        if (key == null) {
            return null;
        }
        DataConversion keyDataConversion = listenerInvocation.getKeyDataConversion();
        Wrapper wrp = keyDataConversion.getWrapper();
        Object unwrappedKey = keyDataConversion.getEncoder().fromStorage(wrp.unwrap(key));
        CacheEventFilter filter = listenerInvocation.getFilter();
        CacheEventConverter converter = listenerInvocation.getConverter();
        if (filter == null && converter == null) {
            if (listenerInvocation.useStorageFormat()) {
                return (K)unwrappedKey;
            }
            return (K)keyDataConversion.fromStorage(key);
        }
        MediaType mediaType = convertFormat = filter == null ? converter.format() : filter.format();
        if (listenerInvocation.useStorageFormat() || convertFormat == null) {
            return (K)unwrappedKey;
        }
        return (K)this.encoderRegistry.convert(unwrappedKey, keyDataConversion.getStorageMediaType(), convertFormat);
    }

    private V convertValue(CacheEntryListenerInvocation listenerInvocation, V value) {
        MediaType convertFormat;
        if (value == null) {
            return null;
        }
        DataConversion valueDataConversion = listenerInvocation.getValueDataConversion();
        Wrapper wrp = valueDataConversion.getWrapper();
        Object unwrappedValue = valueDataConversion.getEncoder().fromStorage(wrp.unwrap(value));
        CacheEventFilter filter = listenerInvocation.getFilter();
        CacheEventConverter converter = listenerInvocation.getConverter();
        if (filter == null && converter == null) {
            if (listenerInvocation.useStorageFormat()) {
                return (V)unwrappedValue;
            }
            return (V)valueDataConversion.fromStorage(value);
        }
        MediaType mediaType = convertFormat = filter == null ? converter.format() : filter.format();
        if (listenerInvocation.useStorageFormat() || convertFormat == null) {
            return (V)unwrappedValue;
        }
        return (V)this.encoderRegistry.convert(unwrappedValue, valueDataConversion.getStorageMediaType(), convertFormat);
    }

    @Override
    protected final Transaction suspendIfNeeded() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            switch (this.transactionManager.getStatus()) {
                case 6: {
                    return null;
                }
            }
            return this.transactionManager.suspend();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("An error occurred while trying to suspend a transaction.", e);
            }
            return null;
        }
    }

    @Override
    protected final void resumeIfNeeded(Transaction transaction) {
        block3: {
            if (transaction == null || this.transactionManager == null) {
                return;
            }
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.tracef(e, "An error occurred while trying to resume a suspended transaction. tx=%s", transaction);
            }
        }
    }

    int extractSegment(FlagAffectedCommand command, Object key) {
        return SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
    }

    @Override
    public CompletionStage<Void> notifyCacheEntryCreated(K key, V value, Metadata metadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryCreatedListeners)) {
            return this.resumeOnCPU(this.doNotifyCreated(key, value, metadata, pre, ctx, command), command);
        }
        return CompletableFutures.completedNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> doNotifyCreated(K key, V value, Metadata metadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.clusteringDependentLogic.running().commitType(command, ctx, this.extractSegment(command, key), false).isLocal() && (command == null || !command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER))) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_CREATED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            Thread batchIdentifier = ctx.isInTxScope() ? null : Thread.currentThread();
            try {
                CompletionStage<Void> completionStage;
                AggregateCompletionStage<Void> aggregateCompletionStage = null;
                for (CacheEntryListenerInvocation listener : this.cacheEntryCreatedListeners) {
                    this.configureEvent(listener, e, key, value, metadata, pre, ctx, command, null, null);
                    aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner));
                }
                if (batchIdentifier != null) {
                    completionStage = this.sendEvents(batchIdentifier, aggregateCompletionStage);
                    return completionStage;
                }
                if (aggregateCompletionStage != null) {
                    completionStage = aggregateCompletionStage.freeze();
                    return completionStage;
                }
            }
            finally {
                if (batchIdentifier != null) {
                    this.eventManager.dropEvents(batchIdentifier);
                }
            }
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyCacheEntryModified(K key, V value, Metadata metadata, V previousValue, Metadata previousMetadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryModifiedListeners)) {
            return this.resumeOnCPU(this.doNotifyModified(key, value, metadata, previousValue, previousMetadata, pre, ctx, command), command);
        }
        return CompletableFutures.completedNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> doNotifyModified(K key, V value, Metadata metadata, V previousValue, Metadata previousMetadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.clusteringDependentLogic.running().commitType(command, ctx, this.extractSegment(command, key), false).isLocal() && (command == null || !command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER))) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_MODIFIED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            Thread batchIdentifier = ctx.isInTxScope() ? null : Thread.currentThread();
            try {
                CompletionStage<Void> completionStage;
                AggregateCompletionStage<Void> aggregateCompletionStage = null;
                for (CacheEntryListenerInvocation listener : this.cacheEntryModifiedListeners) {
                    this.configureEvent(listener, e, key, value, metadata, pre, ctx, command, previousValue, previousMetadata);
                    aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner));
                }
                if (batchIdentifier != null) {
                    completionStage = this.sendEvents(batchIdentifier, aggregateCompletionStage);
                    return completionStage;
                }
                if (aggregateCompletionStage != null) {
                    completionStage = aggregateCompletionStage.freeze();
                    return completionStage;
                }
            }
            finally {
                if (batchIdentifier != null) {
                    this.eventManager.dropEvents(batchIdentifier);
                }
            }
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyCacheEntryRemoved(K key, V previousValue, Metadata previousMetadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryRemovedListeners)) {
            return this.resumeOnCPU(this.doNotifyRemoved(key, previousValue, previousMetadata, pre, ctx, command), command);
        }
        return CompletableFutures.completedNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> doNotifyRemoved(K key, V previousValue, Metadata previousMetadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.clusteringDependentLogic.running().commitType(command, ctx, this.extractSegment(command, key), true).isLocal()) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_REMOVED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            Thread batchIdentifier = ctx.isInTxScope() ? null : Thread.currentThread();
            try {
                CompletionStage<Void> completionStage;
                AggregateCompletionStage<Void> aggregateCompletionStage = null;
                for (CacheEntryListenerInvocation listener : this.cacheEntryRemovedListeners) {
                    if (pre) {
                        this.configureEvent(listener, e, key, previousValue, previousMetadata, true, ctx, command, previousValue, previousMetadata);
                    } else {
                        this.configureEvent(listener, e, key, null, previousMetadata, false, ctx, command, previousValue, previousMetadata);
                    }
                    aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner));
                }
                if (batchIdentifier != null) {
                    completionStage = this.sendEvents(batchIdentifier, aggregateCompletionStage);
                    return completionStage;
                }
                if (aggregateCompletionStage != null) {
                    completionStage = aggregateCompletionStage.freeze();
                    return completionStage;
                }
            }
            finally {
                if (batchIdentifier != null) {
                    this.eventManager.dropEvents(batchIdentifier);
                }
            }
        }
        return CompletableFutures.completedNull();
    }

    private void configureEvent(CacheEntryListenerInvocation listenerInvocation, EventImpl<K, V> e, K key, V value, Metadata metadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command, V previousValue, Metadata previousMetadata) {
        key = this.convertKey(listenerInvocation, key);
        value = this.convertValue(listenerInvocation, value);
        previousValue = this.convertValue(listenerInvocation, previousValue);
        e.setOriginLocal(ctx.isOriginLocal());
        e.setPre(pre);
        e.setValue(pre ? previousValue : value);
        e.setNewValue(value);
        e.setOldValue(previousValue);
        e.setOldMetadata(previousMetadata);
        e.setMetadata(metadata);
        if (command != null && command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            e.setCommandRetried(true);
        }
        e.setKey(key);
        this.setSource(e, ctx, command);
    }

    private void configureEvent(CacheEntryListenerInvocation listenerInvocation, EventImpl<K, V> e, K key, V value, boolean pre, InvocationContext ctx) {
        e.setPre(pre);
        e.setKey(this.convertKey(listenerInvocation, key));
        e.setValue(this.convertValue(listenerInvocation, value));
        e.setOriginLocal(ctx.isOriginLocal());
        this.setSource(e, ctx, null);
    }

    private void configureEvent(CacheEntryListenerInvocation listenerInvocation, EventImpl<K, V> e, K key, V value, Metadata metadata, InvocationContext ctx) {
        e.setKey(this.convertKey(listenerInvocation, key));
        e.setValue(this.convertValue(listenerInvocation, value));
        e.setMetadata(metadata);
        e.setOriginLocal(true);
        e.setPre(false);
        this.setSource(e, ctx, null);
    }

    @Override
    public CompletionStage<Void> notifyCacheEntryVisited(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryVisitedListeners)) {
            return this.resumeOnCPU(this.doNotifyVisited(key, value, pre, ctx), command);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyVisited(K key, V value, boolean pre, InvocationContext ctx) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_VISITED);
        boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
        for (CacheEntryListenerInvocation listener : this.cacheEntryVisitedListeners) {
            this.configureEvent(listener, e, key, value, pre, ctx);
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyCacheEntriesEvicted(Collection<Map.Entry<K, V>> entries, InvocationContext ctx, FlagAffectedCommand command) {
        if (!entries.isEmpty() && this.isNotificationAllowed(command, this.cacheEntriesEvictedListeners)) {
            return this.resumeOnCPU(this.doNotifyEvicted(entries), command);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyEvicted(Collection<Map.Entry<K, V>> entries) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_EVICTED);
        for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntriesEvictedListeners) {
            HashMap<K, V> evictedKeysAndValues = new HashMap<K, V>();
            for (Map.Entry<K, V> entry : entries) {
                evictedKeysAndValues.put(this.convertKey(listener, entry.getKey()), this.convertValue(listener, entry.getValue()));
            }
            e.setEntries(evictedKeysAndValues);
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(e));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    private CompletionStage<Void> sendEvents(Object batchIdentifier, AggregateCompletionStage<Void> aggregateCompletionStage) {
        CompletionStage<Void> managerStage = this.eventManager.sendEvents(batchIdentifier);
        if (aggregateCompletionStage != null) {
            if (managerStage != null) {
                aggregateCompletionStage.dependsOn(managerStage);
            }
            return aggregateCompletionStage.freeze();
        }
        return managerStage;
    }

    @Override
    public CompletionStage<Void> notifyCacheEntryExpired(K key, V value, Metadata metadata, InvocationContext ctx) {
        if (!this.cacheEntryExpiredListeners.isEmpty()) {
            return this.resumeOnCPU(this.doNotifyExpired(key, value, metadata, ctx), key);
        }
        return CompletableFutures.completedNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> doNotifyExpired(K key, V value, Metadata metadata, InvocationContext ctx) {
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_EXPIRED);
        boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        Thread batchIdentifier = ctx != null && ctx.isInTxScope() ? null : Thread.currentThread();
        try {
            for (CacheEntryListenerInvocation listener : this.cacheEntryExpiredListeners) {
                this.configureEvent(listener, e, key, value, metadata, ctx);
                aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner));
            }
            if (batchIdentifier != null) {
                CompletionStage<Void> completionStage = this.sendEvents(batchIdentifier, aggregateCompletionStage);
                return completionStage;
            }
        }
        finally {
            if (batchIdentifier != null) {
                this.eventManager.dropEvents(batchIdentifier);
            }
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyCacheEntryInvalidated(K key, V value, Metadata metadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryInvalidatedListeners)) {
            return this.resumeOnCPU(this.doNotifyInvalidated(key, value, metadata, pre, ctx, command), command);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyInvalidated(K key, V value, Metadata metadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_INVALIDATED);
        boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
        for (CacheEntryListenerInvocation listener : this.cacheEntryInvalidatedListeners) {
            this.configureEvent(listener, e, key, value, metadata, pre, ctx, command, value, metadata);
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyCacheEntryLoaded(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryLoadedListeners)) {
            return this.resumeOnCPU(this.doNotifyLoaded(key, value, pre, ctx), command);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyLoaded(K key, V value, boolean pre, InvocationContext ctx) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_LOADED);
        boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
        for (CacheEntryListenerInvocation listener : this.cacheEntryLoadedListeners) {
            this.configureEvent(listener, e, key, value, pre, ctx);
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyCacheEntryActivated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryActivatedListeners)) {
            return this.resumeOnCPU(this.doNotifyActivated(key, value, pre, ctx), command);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyActivated(K key, V value, boolean pre, InvocationContext ctx) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_ACTIVATED);
        boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
        for (CacheEntryListenerInvocation listener : this.cacheEntryActivatedListeners) {
            this.configureEvent(listener, e, key, value, pre, ctx);
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    private void setSource(EventImpl<K, V> e, InvocationContext ctx, FlagAffectedCommand command) {
        if (ctx != null && ctx.isInTxScope()) {
            GlobalTransaction tx = ((TxInvocationContext)ctx).getGlobalTransaction();
            e.setSource(tx);
        } else if (command instanceof WriteCommand) {
            CommandInvocationId invocationId = ((WriteCommand)command).getCommandInvocationId();
            e.setSource(invocationId);
        }
    }

    @Override
    public CompletionStage<Void> notifyCacheEntryPassivated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryPassivatedListeners)) {
            return this.resumeOnCPU(this.doNotifyPassivated(key, value, pre), command);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyPassivated(K key, V value, boolean pre) {
        EventImpl<K, V> e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_PASSIVATED);
        boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (CacheEntryListenerInvocation listener : this.cacheEntryPassivatedListeners) {
            key = this.convertKey(listener, key);
            value = this.convertValue(listener, value);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    private boolean isLocalNodePrimaryOwner(K key) {
        return this.clusteringDependentLogic.running().getCacheTopology().getDistribution(key).isPrimary();
    }

    @Override
    public CompletionStage<Void> notifyTransactionCompleted(GlobalTransaction transaction, boolean successful, InvocationContext ctx) {
        if (!this.transactionCompletedListeners.isEmpty()) {
            return this.resumeOnCPU(this.doNotifyTransactionCompleted(transaction, successful, ctx), transaction);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyTransactionCompleted(GlobalTransaction transaction, boolean successful, InvocationContext ctx) {
        boolean isOriginLocal = ctx.isOriginLocal();
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.TRANSACTION_COMPLETED);
        e.setOriginLocal(isOriginLocal);
        e.setTransactionId(transaction);
        e.setTransactionSuccessful(successful);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (CacheEntryListenerInvocation<K, V> listener : this.transactionCompletedListeners) {
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(e));
        }
        if (ctx.isInTxScope()) {
            if (successful) {
                return this.sendEvents(transaction, aggregateCompletionStage);
            }
            this.eventManager.dropEvents(transaction);
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyTransactionRegistered(GlobalTransaction globalTransaction, boolean isOriginLocal) {
        if (!this.transactionRegisteredListeners.isEmpty()) {
            return this.resumeOnCPU(this.doNotifyTransactionRegistered(globalTransaction, isOriginLocal), globalTransaction);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyTransactionRegistered(GlobalTransaction globalTransaction, boolean isOriginLocal) {
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.TRANSACTION_REGISTERED);
        e.setOriginLocal(isOriginLocal);
        e.setTransactionId(globalTransaction);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (CacheEntryListenerInvocation<K, V> listener : this.transactionRegisteredListeners) {
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(e));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyDataRehashed(ConsistentHash oldCH, ConsistentHash newCH, ConsistentHash unionCH, int newTopologyId, boolean pre) {
        if (!this.dataRehashedListeners.isEmpty()) {
            return this.resumeOnCPU(this.doNotifyDataRehashed(oldCH, newCH, unionCH, newTopologyId, pre), newTopologyId);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyDataRehashed(ConsistentHash oldCH, ConsistentHash newCH, ConsistentHash unionCH, int newTopologyId, boolean pre) {
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.DATA_REHASHED);
        e.setPre(pre);
        e.setReadConsistentHashAtStart(oldCH);
        e.setWriteConsistentHashAtStart(oldCH);
        e.setReadConsistentHashAtEnd(newCH);
        e.setWriteConsistentHashAtEnd(newCH);
        e.setUnionConsistentHash(unionCH);
        e.setNewTopologyId(newTopologyId);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (CacheEntryListenerInvocation<K, V> listener : this.dataRehashedListeners) {
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(e));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyTopologyChanged(CacheTopology oldTopology, CacheTopology newTopology, int newTopologyId, boolean pre) {
        if (!this.topologyChangedListeners.isEmpty()) {
            return this.resumeOnCPU(this.doNotifyTopologyChanged(oldTopology, newTopology, newTopologyId, pre), newTopology.getTopologyId());
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyTopologyChanged(CacheTopology oldTopology, CacheTopology newTopology, int newTopologyId, boolean pre) {
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.TOPOLOGY_CHANGED);
        e.setPre(pre);
        if (oldTopology != null) {
            e.setReadConsistentHashAtStart(oldTopology.getReadConsistentHash());
            e.setWriteConsistentHashAtStart(oldTopology.getWriteConsistentHash());
        }
        e.setReadConsistentHashAtEnd(newTopology.getReadConsistentHash());
        e.setWriteConsistentHashAtEnd(newTopology.getWriteConsistentHash());
        e.setNewTopologyId(newTopologyId);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (CacheEntryListenerInvocation<K, V> listener : this.topologyChangedListeners) {
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(e));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyPartitionStatusChanged(AvailabilityMode mode, boolean pre) {
        if (!this.partitionChangedListeners.isEmpty()) {
            return this.resumeOnCPU(this.doNotifyPartitionStatusChanged(mode, pre), (Object)mode);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyPartitionStatusChanged(AvailabilityMode mode, boolean pre) {
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.PARTITION_STATUS_CHANGED);
        e.setPre(pre);
        e.setAvailabilityMode(mode);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (CacheEntryListenerInvocation<K, V> listener : this.partitionChangedListeners) {
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(e));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyPersistenceAvailabilityChanged(boolean available) {
        if (!this.persistenceChangedListeners.isEmpty()) {
            return this.resumeOnCPU(this.doNotifyPersistenceAvailabilityChanged(available), available);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> doNotifyPersistenceAvailabilityChanged(boolean available) {
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.PERSISTENCE_AVAILABILITY_CHANGED);
        e.setAvailable(available);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (CacheEntryListenerInvocation<K, V> listener : this.persistenceChangedListeners) {
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invoke(e));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyClusterListeners(Collection<ClusterEvent<K, V>> events, UUID uuid) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        block6: for (ClusterEvent<K, V> event : events) {
            if (event.isPre()) {
                throw new IllegalArgumentException("Events for cluster listener should never be pre change");
            }
            block0 : switch (event.getType()) {
                case CACHE_ENTRY_MODIFIED: {
                    for (CacheEntryListenerInvocation listener : this.cacheEntryModifiedListeners) {
                        if (!listener.isClustered() || !uuid.equals(listener.getIdentifier())) continue;
                        aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invokeNoChecks(new EventWrapper(event.getKey(), event), false, true, false));
                        break block0;
                    }
                    continue block6;
                }
                case CACHE_ENTRY_CREATED: {
                    for (CacheEntryListenerInvocation listener : this.cacheEntryCreatedListeners) {
                        if (!listener.isClustered() || !uuid.equals(listener.getIdentifier())) continue;
                        aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invokeNoChecks(new EventWrapper(event.getKey(), event), false, true, false));
                        break block0;
                    }
                    continue block6;
                }
                case CACHE_ENTRY_REMOVED: {
                    for (CacheEntryListenerInvocation listener : this.cacheEntryRemovedListeners) {
                        if (!listener.isClustered() || !uuid.equals(listener.getIdentifier())) continue;
                        aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invokeNoChecks(new EventWrapper(event.getKey(), event), false, true, false));
                        break block0;
                    }
                    continue block6;
                }
                case CACHE_ENTRY_EXPIRED: {
                    for (CacheEntryListenerInvocation listener : this.cacheEntryExpiredListeners) {
                        if (!listener.isClustered() || !uuid.equals(listener.getIdentifier())) continue;
                        aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, listener.invokeNoChecks(new EventWrapper(event.getKey(), event), false, true, false));
                        break block0;
                    }
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected event type encountered!");
                }
            }
        }
        return aggregateCompletionStage != null ? this.resumeOnCPU(aggregateCompletionStage.freeze(), uuid) : CompletableFutures.completedNull();
    }

    @Override
    public Collection<ClusterListenerReplicateCallable<K, V>> retrieveClusterListenerCallablesToInstall() {
        HashSet<Object> enlistedAlready = new HashSet<Object>();
        HashSet<ClusterListenerReplicateCallable<K, V>> callables = new HashSet<ClusterListenerReplicateCallable<K, V>>();
        if (log.isTraceEnabled()) {
            log.tracef("Request received to get cluster listeners currently registered", new Object[0]);
        }
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryModifiedListeners);
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryCreatedListeners);
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryRemovedListeners);
        if (log.isTraceEnabled()) {
            log.tracef("Cluster listeners found %s", callables);
        }
        return callables;
    }

    private void registerClusterListenerCallablesToInstall(Set<Object> enlistedAlready, Set<ClusterListenerReplicateCallable<K, V>> callables, List<CacheEntryListenerInvocation<K, V>> listenerInvocations) {
        for (CacheEntryListenerInvocation<K, V> listener : listenerInvocations) {
            if (enlistedAlready.contains(listener.getTarget())) continue;
            if (listener.isClustered()) {
                Set<Class<? extends Annotation>> filterAnnotations = listener.getFilterAnnotations();
                callables.add(new ClusterListenerReplicateCallable<K, V>(this.cache.wired().getName(), listener.getIdentifier(), this.rpcManager.getAddress(), listener.getFilter(), listener.getConverter(), listener.isSync(), filterAnnotations, listener.getKeyDataConversion(), listener.getValueDataConversion(), listener.useStorageFormat()));
                enlistedAlready.add(listener.getTarget());
                continue;
            }
            if (!(listener.getTarget() instanceof RemoteClusterListener)) continue;
            RemoteClusterListener lcl = (RemoteClusterListener)listener.getTarget();
            Set<Class<? extends Annotation>> filterAnnotations = listener.getFilterAnnotations();
            callables.add(new ClusterListenerReplicateCallable<K, V>(this.cache.wired().getName(), lcl.getId(), lcl.getOwnerAddress(), listener.getFilter(), listener.getConverter(), listener.isSync(), filterAnnotations, listener.getKeyDataConversion(), listener.getValueDataConversion(), listener.useStorageFormat()));
            enlistedAlready.add(listener.getTarget());
        }
    }

    public boolean isNotificationAllowed(FlagAffectedCommand cmd, List<CacheEntryListenerInvocation<K, V>> listeners) {
        return !listeners.isEmpty() && (cmd == null || !cmd.hasAnyFlag(FlagBitSets.SKIP_LISTENER_NOTIFICATION));
    }

    @Override
    public CompletionStage<Void> addListenerAsync(Object listener) {
        return this.addListenerAsync(listener, null, null, null);
    }

    @Override
    public CompletionStage<Void> addListenerAsync(Object listener, ClassLoader classLoader) {
        return this.addListenerAsync(listener, null, null, classLoader);
    }

    private <C> CompletionStage<Void> addListenerInternal(Object listener, DataConversion keyDataConversion, DataConversion valueDataConversion, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, ClassLoader classLoader, boolean useStorageFormat) {
        QueueingSegmentListener handler;
        CacheInvocationBuilder builder;
        Listener l = CacheNotifierImpl.testListenerClassValidity(listener.getClass());
        UUID generatedId = UUID.randomUUID();
        CacheMode cacheMode = this.config.clustering().cacheMode();
        FilterIndexingServiceProvider indexingProvider = null;
        boolean foundMethods = false;
        DataConversion keyConversion = keyDataConversion == null ? DataConversion.IDENTITY_KEY : keyDataConversion;
        DataConversion valueConversion = valueDataConversion == null ? DataConversion.IDENTITY_VALUE : valueDataConversion;
        Set<Class<? extends Annotation>> filterAnnotations = this.findListenerCallbacks(listener);
        if (filter instanceof IndexedFilter && (indexingProvider = this.findIndexingServiceProvider((IndexedFilter)filter)) != null) {
            builder = new DelegatingCacheInvocationBuilder(indexingProvider);
            this.adjustCacheInvocationBuilder(builder, filter, converter, filterAnnotations, l, useStorageFormat, generatedId, keyConversion, valueConversion, classLoader);
            foundMethods = this.validateAndAddListenerInvocations(listener, builder);
            ((DelegatingCacheInvocationBuilder)builder).registerListenerInvocations();
        }
        if (indexingProvider == null) {
            builder = new CacheInvocationBuilder();
            this.adjustCacheInvocationBuilder(builder, filter, converter, filterAnnotations, l, useStorageFormat, generatedId, keyConversion, valueConversion, classLoader);
            foundMethods = this.validateAndAddListenerInvocations(listener, builder);
        }
        CompletionStage<Void> stage = CompletableFutures.completedNull();
        if (foundMethods && l.clustered()) {
            if (l.observation() == Listener.Observation.PRE) {
                throw Log.CONTAINER.clusterListenerRegisteredWithOnlyPreEvents(listener.getClass());
            }
            if (cacheMode.isInvalidation()) {
                throw new UnsupportedOperationException("Cluster listeners cannot be used with Invalidation Caches!");
            }
            if (this.clusterListenerOnPrimaryOnly()) {
                List<Address> members;
                Address ourAddress;
                this.clusterListenerIDs.put(listener, generatedId);
                if (this.rpcManager != null) {
                    ourAddress = this.rpcManager.getAddress();
                    members = this.rpcManager.getMembers();
                } else {
                    ourAddress = null;
                    members = null;
                }
                if (members != null && members.size() > 1) {
                    stage = this.registerClusterListeners(members, generatedId, ourAddress, filter, converter, l, listener, keyDataConversion, valueDataConversion, useStorageFormat);
                }
            }
        }
        if ((handler = (QueueingSegmentListener)this.segmentHandler.remove(generatedId)) != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Listener %s requests initial state for cache", generatedId);
            }
            ArrayList intermediateOperations = new ArrayList();
            if (keyDataConversion != DataConversion.IDENTITY_KEY && valueDataConversion != DataConversion.IDENTITY_VALUE) {
                intermediateOperations.add(new MapOperation(EncoderEntryMapper.newCacheEntryMapper(keyDataConversion, valueDataConversion, this.entryFactory)));
            }
            if (filter instanceof CacheEventFilterConverter && (filter == converter || converter == null)) {
                intermediateOperations.add(new MapOperation(CacheFilters.converterToFunction(new CacheEventFilterConverterAsKeyValueFilterConverter((CacheEventFilterConverter)filter))));
                intermediateOperations.add(new FilterOperation(CacheFilters.notNullCacheEntryPredicate()));
            } else {
                if (filter != null) {
                    intermediateOperations.add(new FilterOperation<CacheEntry<? super K, ? super V>>(CacheFilters.predicate(new CacheEventFilterAsKeyValueFilter<K, V>(filter))));
                }
                if (converter != null) {
                    intermediateOperations.add(new MapOperation<CacheEntry<? super K, ? super V>, CacheEntry<? super K, C>>(CacheFilters.function(new CacheEventConverterAsConverter<K, V, C>(converter))));
                }
            }
            stage = this.handlePublisher(stage, intermediateOperations, handler, generatedId, l, null, null);
        }
        return stage;
    }

    private CompletionStage<Void> handlePublisher(CompletionStage<Void> currentStage, Collection<IntermediateOperation<?, ?, ?, ?>> intermediateOperations, QueueingSegmentListener<K, V, ? extends Event<K, V>> handler, UUID generatedId, Listener l, Function<Object, Object> kc, Function<Object, Object> kv) {
        SegmentCompletionPublisher publisher = this.publisherManager.running().entryPublisher(null, null, null, true, DeliveryGuarantee.EXACTLY_ONCE, this.config.clustering().stateTransfer().chunkSize(), intermediateOperations.isEmpty() ? PublisherTransformers.identity() : new CacheIntermediatePublisher(intermediateOperations));
        Completable delayCompletable = Completable.defer(() -> Completable.fromCompletionStage(handler.delayProcessing()));
        Publisher p = s -> publisher.subscribe(s, handler);
        currentStage = currentStage.thenCompose(ignore -> Flowable.fromPublisher((Publisher)p).startWith((CompletableSource)delayCompletable).filter(ice -> handler.markKeyAsProcessing(ice.getKey()) != QueueingSegmentListener.REMOVED).delay(ice -> RxJavaInterop.voidCompletionStageToFlowable(this.raiseEventForInitialTransfer(generatedId, (CacheEntry)ice, l.clustered(), kc, kv))).rebatchRequests(20).ignoreElements().andThen((CompletableSource)delayCompletable).toCompletionStage(null));
        currentStage = currentStage.thenCompose(ignore -> {
            if (log.isTraceEnabled()) {
                log.tracef("Finding any created entries during listener registration for %s", generatedId);
            }
            Set entries = handler.findCreatedEntries();
            AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            for (CacheEntry entry : entries) {
                aggregateCompletionStage.dependsOn(this.raiseEventForInitialTransfer(generatedId, entry, l.clustered(), null, null));
            }
            return aggregateCompletionStage.freeze();
        });
        currentStage = currentStage.thenCompose(ignore -> handler.transferComplete());
        if (log.isTraceEnabled()) {
            currentStage = currentStage.whenComplete((v, t) -> log.tracef("Listener %s initial state for cache completed", generatedId));
        }
        return currentStage;
    }

    private <C> CompletionStage<Void> registerClusterListeners(List<Address> members, UUID generatedId, Address ourAddress, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Listener l, Object listener, DataConversion keyDataConversion, DataConversion valueDataConversion, boolean useStorageFormat) {
        if (log.isTraceEnabled()) {
            log.tracef("Replicating cluster listener to other nodes %s for cluster listener with id %s", members, generatedId);
        }
        ClusterListenerReplicateCallable<? super K, ? super V> callable = new ClusterListenerReplicateCallable<K, V>(this.cache.wired().getName(), generatedId, ourAddress, filter, converter, l.sync(), this.findListenerCallbacks(listener), keyDataConversion, valueDataConversion, useStorageFormat);
        TriConsumer<Address, Void, Throwable> handleSuspect = (a, ignore, t) -> {
            if (t != null && !(t instanceof SuspectException)) {
                log.debugf((Throwable)t, "Address: %s encountered an exception while adding cluster listener", a);
                throw new CacheListenerException(t);
            }
        };
        CompletableFuture<Void> completionStage = this.clusterExecutor.filterTargets(a -> !ourAddress.equals(a)).submitConsumer(callable, handleSuspect);
        return completionStage.thenCompose(v -> this.clusterExecutor.filterTargets(a -> !members.contains(a) && !a.equals(ourAddress)).submitConsumer(callable, handleSuspect).exceptionally(t -> {
            if (!(t instanceof SuspectException)) {
                throw new CacheListenerException(t);
            }
            return null;
        }));
    }

    @Override
    public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, ClassLoader classLoader) {
        return this.addListenerInternal(listener, DataConversion.IDENTITY_KEY, DataConversion.IDENTITY_VALUE, filter, converter, classLoader, false);
    }

    private FilterIndexingServiceProvider findIndexingServiceProvider(IndexedFilter indexedFilter) {
        if (this.filterIndexingServiceProviders != null) {
            for (FilterIndexingServiceProvider provider : this.filterIndexingServiceProviders) {
                if (!provider.supportsFilter(indexedFilter)) continue;
                return provider;
            }
        }
        log.noFilterIndexingServiceProviderFound(indexedFilter.getClass().getName());
        return null;
    }

    @Override
    public List<CacheEntryListenerInvocation<K, V>> getListenerCollectionForAnnotation(Class<? extends Annotation> annotation) {
        return super.getListenerCollectionForAnnotation(annotation);
    }

    private CompletionStage<Void> raiseEventForInitialTransfer(UUID identifier, CacheEntry entry, boolean clustered, Function<Object, Object> kc, Function<Object, Object> kv) {
        EventImpl preEvent;
        if (kc == null) {
            kc = Function.identity();
        }
        if (kv == null) {
            kv = Function.identity();
        }
        if (clustered) {
            preEvent = null;
        } else {
            preEvent = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_CREATED);
            preEvent.setKey(kc.apply(entry.getKey()));
            preEvent.setPre(true);
            preEvent.setCurrentState(true);
        }
        EventImpl<Object, Object> postEvent = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_CREATED);
        postEvent.setKey(kc.apply(entry.getKey()));
        postEvent.setValue(kv.apply(entry.getValue()));
        postEvent.setMetadata(entry.getMetadata());
        postEvent.setPre(false);
        postEvent.setCurrentState(true);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (CacheEntryListenerInvocation cacheEntryListenerInvocation : this.cacheEntryCreatedListeners) {
            if (cacheEntryListenerInvocation.getIdentifier() != identifier) continue;
            if (preEvent != null) {
                aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, cacheEntryListenerInvocation.invokeNoChecks(new EventWrapper(null, preEvent), true, true, false));
            }
            aggregateCompletionStage = CacheNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, cacheEntryListenerInvocation.invokeNoChecks(new EventWrapper(null, postEvent), true, true, false));
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    @Override
    public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        return this.addListenerAsync(listener, filter, converter, null);
    }

    @Override
    public <C> CompletionStage<Void> addFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return this.addFilteredListenerInternal(listener, null, null, filter, converter, filterAnnotations, false);
    }

    @Override
    public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return this.addFilteredListenerInternal(listener, null, null, filter, converter, filterAnnotations, false);
    }

    @Override
    public <C> CompletionStage<Void> addListenerAsync(ListenerHolder listenerHolder, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, ClassLoader classLoader) {
        return this.addListenerInternal(listenerHolder.getListener(), listenerHolder.getKeyDataConversion(), listenerHolder.getValueDataConversion(), filter, converter, classLoader, false);
    }

    @Override
    public <C> CompletionStage<Void> addFilteredListenerAsync(ListenerHolder listenerHolder, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return this.addFilteredListenerInternal(listenerHolder.getListener(), listenerHolder.getKeyDataConversion(), listenerHolder.getValueDataConversion(), filter, converter, filterAnnotations, listenerHolder.isFilterOnStorageFormat());
    }

    protected boolean clusterListenerOnPrimaryOnly() {
        CacheMode mode = this.config.clustering().cacheMode();
        boolean zeroCapacity = this.config.clustering().hash().capacityFactor() == 0.0f || this.globalConfiguration.isZeroCapacityNode();
        return mode.isDistributed() || mode.isScattered() || mode.isReplicated() && zeroCapacity;
    }

    private <C> CompletionStage<Void> addFilteredListenerInternal(Object listener, DataConversion keyDataConversion, DataConversion valueDataConversion, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations, boolean useStorageFormat) {
        QueueingSegmentListener handler;
        CacheInvocationBuilder builder;
        DataConversion valueConversion;
        Listener l = CacheNotifierImpl.testListenerClassValidity(listener.getClass());
        UUID generatedId = UUID.randomUUID();
        CacheMode cacheMode = this.config.clustering().cacheMode();
        FilterIndexingServiceProvider indexingProvider = null;
        boolean foundMethods = false;
        DataConversion keyConversion = keyDataConversion == null ? DataConversion.IDENTITY_KEY : keyDataConversion;
        DataConversion dataConversion = valueConversion = valueDataConversion == null ? DataConversion.IDENTITY_VALUE : valueDataConversion;
        if (filter instanceof IndexedFilter && (indexingProvider = this.findIndexingServiceProvider((IndexedFilter)filter)) != null) {
            builder = new DelegatingCacheInvocationBuilder(indexingProvider);
            this.adjustCacheInvocationBuilder(builder, filter, converter, filterAnnotations, l, useStorageFormat, generatedId, keyConversion, valueConversion, null);
            foundMethods = this.validateAndAddFilterListenerInvocations(listener, builder, filterAnnotations);
            ((DelegatingCacheInvocationBuilder)builder).registerListenerInvocations();
        }
        if (indexingProvider == null) {
            builder = new CacheInvocationBuilder();
            this.adjustCacheInvocationBuilder(builder, filter, converter, filterAnnotations, l, useStorageFormat, generatedId, keyConversion, valueConversion, null);
            foundMethods = this.validateAndAddFilterListenerInvocations(listener, builder, filterAnnotations);
        }
        CompletionStage<Void> stage = CompletableFutures.completedNull();
        if (foundMethods && l.clustered()) {
            if (l.observation() == Listener.Observation.PRE) {
                throw Log.CONTAINER.clusterListenerRegisteredWithOnlyPreEvents(listener.getClass());
            }
            if (cacheMode.isInvalidation()) {
                throw new UnsupportedOperationException("Cluster listeners cannot be used with Invalidation Caches!");
            }
            if (this.clusterListenerOnPrimaryOnly()) {
                this.clusterListenerIDs.put(listener, generatedId);
                Address ourAddress = this.rpcManager.getAddress();
                List<Address> members = this.rpcManager.getMembers();
                if (members != null && members.size() > 1) {
                    stage = this.registerClusterListeners(members, generatedId, ourAddress, filter, converter, l, listener, keyDataConversion, valueDataConversion, useStorageFormat);
                }
            }
        }
        if ((handler = (QueueingSegmentListener)this.segmentHandler.remove(generatedId)) != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Listener %s requests initial state for cache", generatedId);
            }
            ArrayList intermediateOperations = new ArrayList();
            MediaType storage = valueConversion.getStorageMediaType();
            MediaType keyReq = keyConversion.getRequestMediaType();
            MediaType valueReq = valueConversion.getRequestMediaType();
            AdvancedCache<K, V> advancedCache = this.cache.running();
            DataConversion chainedKeyDataConversion = advancedCache.getKeyDataConversion();
            DataConversion chainedValueDataConversion = advancedCache.getValueDataConversion();
            if (keyReq != null && valueReq != null) {
                chainedKeyDataConversion = chainedKeyDataConversion.withRequestMediaType(keyReq);
                chainedValueDataConversion = chainedValueDataConversion.withRequestMediaType(valueReq);
            }
            boolean hasFilter = false;
            MediaType filterMediaType = null;
            if (filter != null) {
                hasFilter = true;
                MediaType mediaType = filterMediaType = useStorageFormat ? null : filter.format();
                if (filterMediaType == null) {
                    chainedKeyDataConversion = chainedKeyDataConversion.withRequestMediaType(storage);
                    chainedValueDataConversion = chainedValueDataConversion.withRequestMediaType(storage);
                } else {
                    chainedKeyDataConversion = chainedKeyDataConversion.withRequestMediaType(filterMediaType);
                    chainedValueDataConversion = chainedValueDataConversion.withRequestMediaType(filterMediaType);
                }
            }
            if (converter != null) {
                hasFilter = true;
                MediaType mediaType = filterMediaType = useStorageFormat ? null : converter.format();
                if (filterMediaType == null) {
                    chainedKeyDataConversion = chainedKeyDataConversion.withRequestMediaType(storage);
                    chainedValueDataConversion = chainedValueDataConversion.withRequestMediaType(storage);
                } else {
                    chainedKeyDataConversion = chainedKeyDataConversion.withRequestMediaType(filterMediaType);
                    chainedValueDataConversion = chainedValueDataConversion.withRequestMediaType(filterMediaType);
                }
            }
            if (!Objects.equals(chainedKeyDataConversion, keyDataConversion) || !Objects.equals(chainedValueDataConversion, valueDataConversion)) {
                this.componentRegistry.wireDependencies(chainedKeyDataConversion, false);
                this.componentRegistry.wireDependencies(chainedValueDataConversion, false);
                intermediateOperations.add(new MapOperation(EncoderEntryMapper.newCacheEntryMapper(chainedKeyDataConversion, chainedValueDataConversion, this.entryFactory)));
            }
            if (filter instanceof CacheEventFilterConverter && (filter == converter || converter == null)) {
                intermediateOperations.add(new MapOperation(CacheFilters.converterToFunction(new CacheEventFilterConverterAsKeyValueFilterConverter((CacheEventFilterConverter)filter))));
                intermediateOperations.add(new FilterOperation(CacheFilters.notNullCacheEntryPredicate()));
            } else {
                if (filter != null) {
                    intermediateOperations.add(new FilterOperation<CacheEntry<? super K, ? super V>>(CacheFilters.predicate(new CacheEventFilterAsKeyValueFilter<K, V>(filter))));
                }
                if (converter != null) {
                    intermediateOperations.add(new MapOperation<CacheEntry<? super K, ? super V>, CacheEntry<? super K, C>>(CacheFilters.function(new CacheEventConverterAsConverter<K, V, C>(converter))));
                }
            }
            boolean finalHasFilter = hasFilter;
            MediaType finalFilterMediaType = filterMediaType;
            Function<Object, Object> kc = k -> {
                if (!finalHasFilter) {
                    return k;
                }
                if (finalFilterMediaType == null || useStorageFormat || keyReq == null) {
                    return keyDataConversion.fromStorage(k);
                }
                return this.encoderRegistry.convert(k, finalFilterMediaType, keyDataConversion.getRequestMediaType());
            };
            Function<Object, Object> kv = v -> {
                if (!finalHasFilter) {
                    return v;
                }
                if (finalFilterMediaType == null || useStorageFormat || valueReq == null) {
                    return valueConversion.fromStorage(v);
                }
                return this.encoderRegistry.convert(v, finalFilterMediaType, valueConversion.getRequestMediaType());
            };
            stage = this.handlePublisher(stage, intermediateOperations, handler, generatedId, l, kc, kv);
        }
        return stage;
    }

    private <C> void adjustCacheInvocationBuilder(CacheInvocationBuilder builder, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations, Listener l, boolean useStorageFormat, UUID generatedId, DataConversion keyConversion, DataConversion valueConversion, ClassLoader classLoader) {
        builder.setIncludeCurrentState(l.includeCurrentState()).setClustered(l.clustered()).setOnlyPrimary(l.clustered() ? this.clusterListenerOnPrimaryOnly() : l.primaryOnly()).setObservation(l.clustered() ? Listener.Observation.POST : l.observation()).setFilter(filter).setConverter(converter).useStorageFormat(useStorageFormat).setKeyDataConversion(keyConversion).setValueDataConversion(valueConversion).setIdentifier(generatedId).setClassLoader(classLoader);
        builder.setFilterAnnotations(filterAnnotations);
    }

    @Override
    public CompletionStage<Void> removeListenerAsync(Object listener) {
        this.removeListenerFromMaps(listener);
        UUID id = this.clusterListenerIDs.remove(listener);
        if (id != null) {
            return this.clusterExecutor.submitConsumer(new ClusterListenerRemoveCallable(this.cache.wired().getName(), id), (a, ignore, t) -> {
                if (t != null) {
                    throw new CacheException(t);
                }
            });
        }
        return CompletableFutures.completedNull();
    }

    @Override
    protected Set<CacheEntryListenerInvocation<K, V>> removeListenerInvocation(Class<? extends Annotation> annotation, Object listener) {
        Set<CacheEntryListenerInvocation<K, V>> markedForRemoval = super.removeListenerInvocation(annotation, listener);
        for (CacheEntryListenerInvocation cacheEntryListenerInvocation : markedForRemoval) {
            if (!(cacheEntryListenerInvocation instanceof DelegatingCacheEntryListenerInvocation)) continue;
            ((DelegatingCacheEntryListenerInvocation)cacheEntryListenerInvocation).unregister();
        }
        return markedForRemoval;
    }

    static {
        allowedListeners.put(CacheEntryCreated.class, CacheEntryCreatedEvent.class);
        allowedListeners.put(CacheEntryRemoved.class, CacheEntryRemovedEvent.class);
        allowedListeners.put(CacheEntryVisited.class, CacheEntryVisitedEvent.class);
        allowedListeners.put(CacheEntryModified.class, CacheEntryModifiedEvent.class);
        allowedListeners.put(CacheEntryActivated.class, CacheEntryActivatedEvent.class);
        allowedListeners.put(CacheEntryPassivated.class, CacheEntryPassivatedEvent.class);
        allowedListeners.put(CacheEntryLoaded.class, CacheEntryLoadedEvent.class);
        allowedListeners.put(CacheEntriesEvicted.class, CacheEntriesEvictedEvent.class);
        allowedListeners.put(TransactionRegistered.class, TransactionRegisteredEvent.class);
        allowedListeners.put(TransactionCompleted.class, TransactionCompletedEvent.class);
        allowedListeners.put(CacheEntryInvalidated.class, CacheEntryInvalidatedEvent.class);
        allowedListeners.put(CacheEntryExpired.class, CacheEntryExpiredEvent.class);
        allowedListeners.put(DataRehashed.class, DataRehashedEvent.class);
        allowedListeners.put(TopologyChanged.class, TopologyChangedEvent.class);
        allowedListeners.put(PartitionStatusChanged.class, PartitionStatusChangedEvent.class);
        allowedListeners.put(PersistenceAvailabilityChanged.class, PersistenceAvailabilityChangedEvent.class);
        clusterAllowedListeners.put(CacheEntryCreated.class, CacheEntryCreatedEvent.class);
        clusterAllowedListeners.put(CacheEntryModified.class, CacheEntryModifiedEvent.class);
        clusterAllowedListeners.put(CacheEntryRemoved.class, CacheEntryRemovedEvent.class);
        clusterAllowedListeners.put(CacheEntryExpired.class, CacheEntryExpiredEvent.class);
    }

    protected class BaseCacheEntryListenerInvocation<K, V>
    implements CacheEntryListenerInvocation<K, V> {
        private final EncoderRegistry encoderRegistry;
        protected final ListenerInvocation<Event<K, V>> invocation;
        protected final CacheEventFilter<? super K, ? super V> filter;
        protected final CacheEventConverter<? super K, ? super V, ?> converter;
        private final DataConversion keyDataConversion;
        private final DataConversion valueDataConversion;
        private final boolean useStorageFormat;
        protected final boolean onlyPrimary;
        protected final boolean clustered;
        protected final UUID identifier;
        protected final Class<? extends Annotation> annotation;
        protected final boolean sync;
        protected final boolean filterAndConvert;
        protected final Listener.Observation observation;
        protected final Set<Class<? extends Annotation>> filterAnnotations;

        protected BaseCacheEntryListenerInvocation(EncoderRegistry encoderRegistry, ListenerInvocation<Event<K, V>> invocation, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, ?> converter, Class<? extends Annotation> annotation, boolean onlyPrimary, boolean clustered, UUID identifier, boolean sync, Listener.Observation observation, Set<Class<? extends Annotation>> filterAnnotations, DataConversion keyDataConversion, DataConversion valueDataConversion, boolean useStorageFormat) {
            this.encoderRegistry = encoderRegistry;
            this.invocation = invocation;
            this.filter = filter;
            this.converter = converter;
            this.keyDataConversion = keyDataConversion;
            this.valueDataConversion = valueDataConversion;
            this.useStorageFormat = useStorageFormat;
            this.filterAndConvert = filter instanceof CacheEventFilterConverter && (filter == converter || converter == null);
            this.onlyPrimary = onlyPrimary;
            this.clustered = clustered;
            this.identifier = identifier;
            this.annotation = annotation;
            this.sync = sync;
            this.observation = observation;
            this.filterAnnotations = filterAnnotations;
        }

        @Override
        public CompletionStage<Void> invoke(Event<K, V> event) {
            if (this.shouldInvoke(event)) {
                return this.doRealInvocation(event);
            }
            return null;
        }

        @Override
        public CompletionStage<Void> invoke(EventWrapper<K, V, CacheEntryEvent<K, V>> wrapped, boolean isLocalNodePrimaryOwner) {
            CacheEntryEvent<K, V> resultingEvent = this.shouldInvoke(wrapped.getEvent(), isLocalNodePrimaryOwner);
            if (resultingEvent != null) {
                wrapped.setEvent(resultingEvent);
                return this.invokeNoChecks(wrapped, false, this.filterAndConvert, false);
            }
            return null;
        }

        @Override
        public CompletionStage<Void> invokeNoChecks(EventWrapper<K, V, CacheEntryEvent<K, V>> wrapped, boolean skipQueue, boolean skipConverter, boolean needsTransform) {
            if (!skipConverter) {
                wrapped.setEvent(this.convertValue(this.converter, wrapped.getEvent()));
            }
            if (needsTransform) {
                CacheEntryEvent<K, V> event = wrapped.getEvent();
                EventImpl eventImpl = (EventImpl)event;
                wrapped.setEvent(this.convertEventToRequestFormat(eventImpl, this.filter, this.converter, eventImpl.getValue()));
            }
            if (skipQueue) {
                return this.invocation.invoke(wrapped.getEvent());
            }
            return this.doRealInvocation(wrapped);
        }

        protected CompletionStage<Void> doRealInvocation(EventWrapper<K, V, CacheEntryEvent<K, V>> event) {
            return this.doRealInvocation(event.getEvent());
        }

        protected CompletionStage<Void> doRealInvocation(Event<K, V> event) {
            return this.invocation.invoke(event);
        }

        protected boolean shouldInvoke(Event<K, V> event) {
            return this.observation.shouldInvoke(event.isPre());
        }

        protected CacheEntryEvent<K, V> shouldInvoke(CacheEntryEvent<K, V> event, boolean isLocalNodePrimaryOwner) {
            if (log.isTraceEnabled()) {
                log.tracef("Should invoke %s (filter %s)? (onlyPrimary=%s, isPrimary=%s)", new Object[]{event, this.filter, this.onlyPrimary, isLocalNodePrimaryOwner});
            }
            if (this.onlyPrimary && !isLocalNodePrimaryOwner) {
                return null;
            }
            if (event instanceof EventImpl) {
                EventType eventType;
                EventImpl eventImpl = (EventImpl)event;
                if (!this.shouldInvoke(event)) {
                    return null;
                }
                if (this.filter != null && (eventType = this.getEvent(eventImpl)) != null) {
                    if (this.filterAndConvert) {
                        Object newValue = ((CacheEventFilterConverter)this.filter).filterAndConvert(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), eventType);
                        return newValue != null ? this.convertEventToRequestFormat(eventImpl, this.filter, null, newValue) : null;
                    }
                    boolean accept = this.filter.accept(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), eventType);
                    if (!accept) {
                        return null;
                    }
                    if (this.converter == null) {
                        return this.convertEventToRequestFormat(eventImpl, this.filter, null, eventImpl.getValue());
                    }
                }
            }
            return event;
        }

        private EventType getEvent(EventImpl<K, V> event) {
            switch (event.getType()) {
                case CACHE_ENTRY_MODIFIED: 
                case CACHE_ENTRY_CREATED: 
                case CACHE_ENTRY_REMOVED: 
                case CACHE_ENTRY_EXPIRED: 
                case CACHE_ENTRY_ACTIVATED: 
                case CACHE_ENTRY_INVALIDATED: 
                case CACHE_ENTRY_LOADED: 
                case CACHE_ENTRY_PASSIVATED: 
                case CACHE_ENTRY_VISITED: {
                    return new EventType(event.isCommandRetried(), event.isPre(), event.getType());
                }
            }
            return null;
        }

        @Override
        public Object getTarget() {
            return this.invocation.getTarget();
        }

        @Override
        public CacheEventFilter<? super K, ? super V> getFilter() {
            return this.filter;
        }

        @Override
        public Set<Class<? extends Annotation>> getFilterAnnotations() {
            return this.filterAnnotations;
        }

        @Override
        public DataConversion getKeyDataConversion() {
            return this.keyDataConversion;
        }

        @Override
        public DataConversion getValueDataConversion() {
            return this.valueDataConversion;
        }

        @Override
        public boolean useStorageFormat() {
            return this.useStorageFormat;
        }

        @Override
        public CacheEventConverter<? super K, ? super V, ?> getConverter() {
            return this.converter;
        }

        @Override
        public boolean isClustered() {
            return this.clustered;
        }

        @Override
        public UUID getIdentifier() {
            return this.identifier;
        }

        @Override
        public Listener.Observation getObservation() {
            return this.observation;
        }

        @Override
        public Class<? extends Annotation> getAnnotation() {
            return this.annotation;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected CacheEntryEvent<K, V> convertValue(CacheEventConverter<? super K, ? super V, ?> converter, CacheEntryEvent<K, V> event) {
            Object newValue;
            if (converter == null) return event;
            if (!(event instanceof EventImpl)) throw new IllegalArgumentException("Provided event should be org.infinispan.notifications.cachelistener.event.impl.EventImpl when a converter is being used!");
            EventImpl eventImpl = (EventImpl)event;
            EventType evType = new EventType(eventImpl.isCommandRetried(), eventImpl.isPre(), eventImpl.getType());
            if (converter.useRequestFormat()) {
                eventImpl = this.convertEventToRequestFormat(eventImpl, null, converter, eventImpl.getValue());
                newValue = converter.convert(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), evType);
                eventImpl.setValue(newValue);
            } else {
                newValue = converter.convert(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), evType);
            }
            if (converter.useRequestFormat()) return eventImpl;
            return this.convertEventToRequestFormat(eventImpl, null, converter, newValue);
        }

        private EventImpl<K, V> convertEventToRequestFormat(EventImpl<K, V> eventImpl, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, ?> converter, Object newValue) {
            MediaType keyFromFormat = this.keyDataConversion.getStorageMediaType();
            MediaType valueFromFormat = this.valueDataConversion.getStorageMediaType();
            if (converter != null) {
                if (converter.format() != null && !this.useStorageFormat) {
                    keyFromFormat = converter.format();
                    valueFromFormat = converter.format();
                }
            } else if (filter != null && filter.format() != null && !this.useStorageFormat) {
                keyFromFormat = filter.format();
                valueFromFormat = filter.format();
            }
            Object convertedKey = this.convertToRequestFormat(eventImpl.getKey(), keyFromFormat, this.keyDataConversion);
            Object convertedValue = this.convertToRequestFormat(newValue, valueFromFormat, this.valueDataConversion);
            Object convertedOldValue = this.convertToRequestFormat(eventImpl.getOldValue(), valueFromFormat, this.valueDataConversion);
            Object clone = eventImpl.clone();
            ((EventImpl)clone).setKey(convertedKey);
            ((EventImpl)clone).setValue(convertedValue);
            ((EventImpl)clone).setOldValue(convertedOldValue);
            return clone;
        }

        private Object convertToRequestFormat(Object object, MediaType objectFormat, DataConversion dataConversion) {
            if (object == null) {
                return null;
            }
            MediaType requestMediaType = dataConversion.getRequestMediaType();
            if (requestMediaType == null) {
                return dataConversion.fromStorage(object);
            }
            Transcoder transcoder = this.encoderRegistry.getTranscoder(objectFormat, requestMediaType);
            return transcoder.transcode(object, objectFormat, requestMediaType);
        }

        @Override
        public boolean isSync() {
            return this.sync;
        }

        public String toString() {
            return "BaseCacheEntryListenerInvocation{id=" + this.identifier + '}';
        }
    }

    protected class ClusteredListenerInvocation<K, V>
    extends BaseCacheEntryListenerInvocation<K, V> {
        private final QueueingSegmentListener<K, V, CacheEntryEvent<K, V>> handler;

        public ClusteredListenerInvocation(EncoderRegistry encoderRegistry, ListenerInvocation<Event<K, V>> invocation, QueueingSegmentListener<K, V, CacheEntryEvent<K, V>> handler, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, ?> converter, Class<? extends Annotation> annotation, boolean onlyPrimary, UUID identifier, boolean sync, Listener.Observation observation, Set<Class<? extends Annotation>> filterAnnotations, DataConversion keyDataConversion, DataConversion valueDataConversion, boolean useStorageFormat) {
            super(encoderRegistry, invocation, filter, converter, annotation, onlyPrimary, true, identifier, sync, observation, filterAnnotations, keyDataConversion, valueDataConversion, useStorageFormat);
            this.handler = handler;
        }

        @Override
        public CompletionStage<Void> invoke(Event<K, V> event) {
            throw new UnsupportedOperationException("Clustered initial transfer don't support regular events!");
        }

        @Override
        protected CompletionStage<Void> doRealInvocation(EventWrapper<K, V, CacheEntryEvent<K, V>> wrapped) {
            if (!this.handler.handleEvent(wrapped, this.invocation)) {
                return super.doRealInvocation(wrapped.getEvent());
            }
            return null;
        }

        @Override
        public String toString() {
            return "ClusteredListenerInvocation{id=" + this.identifier + '}';
        }
    }

    protected class DelegatingCacheInvocationBuilder
    extends CacheInvocationBuilder {
        private final FilterIndexingServiceProvider provider;
        private final Map<Class<? extends Annotation>, List<DelegatingCacheEntryListenerInvocation<K, V>>> listeners;

        DelegatingCacheInvocationBuilder(FilterIndexingServiceProvider provider) {
            this.listeners = new HashMap(3);
            this.provider = provider;
        }

        @Override
        public DelegatingCacheEntryListenerInvocation<K, V> build() {
            DelegatingCacheEntryListenerInvocation invocation = this.provider.interceptListenerInvocation(super.build());
            List invocations = this.listeners.get(invocation.getAnnotation());
            if (invocations == null) {
                invocations = new ArrayList(2);
                this.listeners.put(invocation.getAnnotation(), invocations);
            }
            invocations.add(invocation);
            return invocation;
        }

        void registerListenerInvocations() {
            if (!this.listeners.isEmpty()) {
                boolean filterAndConvert = this.filter == this.converter || this.converter == null;
                this.provider.registerListenerInvocations(this.clustered, this.onlyPrimary, filterAndConvert, (IndexedFilter)this.filter, this.listeners, this.keyDataConversion, this.valueDataConversion);
            }
        }
    }

    protected class CacheInvocationBuilder
    extends AbstractListenerImpl.AbstractInvocationBuilder {
        CacheEventFilter<? super K, ? super V> filter;
        CacheEventConverter<? super K, ? super V, ?> converter;
        boolean onlyPrimary;
        boolean clustered;
        boolean includeCurrentState;
        UUID identifier;
        DataConversion keyDataConversion;
        DataConversion valueDataConversion;
        Listener.Observation observation;
        Set<Class<? extends Annotation>> filterAnnotations;
        boolean storageFormat;

        protected CacheInvocationBuilder() {
            super(CacheNotifierImpl.this);
        }

        public CacheEventFilter<? super K, ? super V> getFilter() {
            return this.filter;
        }

        public CacheInvocationBuilder setFilter(CacheEventFilter<? super K, ? super V> filter) {
            this.filter = filter;
            return this;
        }

        public CacheEventConverter<? super K, ? super V, ?> getConverter() {
            return this.converter;
        }

        public CacheInvocationBuilder setConverter(CacheEventConverter<? super K, ? super V, ?> converter) {
            this.converter = converter;
            return this;
        }

        public CacheInvocationBuilder useStorageFormat(boolean useStorageFormat) {
            this.storageFormat = useStorageFormat;
            return this;
        }

        public boolean isOnlyPrimary() {
            return this.onlyPrimary;
        }

        public CacheInvocationBuilder setOnlyPrimary(boolean onlyPrimary) {
            this.onlyPrimary = onlyPrimary;
            return this;
        }

        public boolean isClustered() {
            return this.clustered;
        }

        public CacheInvocationBuilder setClustered(boolean clustered) {
            this.clustered = clustered;
            return this;
        }

        public UUID getIdentifier() {
            return this.identifier;
        }

        public CacheInvocationBuilder setIdentifier(UUID identifier) {
            this.identifier = identifier;
            return this;
        }

        public CacheInvocationBuilder setKeyDataConversion(DataConversion dataConversion) {
            this.keyDataConversion = dataConversion;
            return this;
        }

        public CacheInvocationBuilder setValueDataConversion(DataConversion dataConversion) {
            this.valueDataConversion = dataConversion;
            return this;
        }

        public boolean isIncludeCurrentState() {
            return this.includeCurrentState;
        }

        public CacheInvocationBuilder setIncludeCurrentState(boolean includeCurrentState) {
            this.includeCurrentState = includeCurrentState;
            return this;
        }

        public Listener.Observation getObservation() {
            return this.observation;
        }

        public CacheInvocationBuilder setObservation(Listener.Observation observation) {
            this.observation = observation;
            return this;
        }

        public CacheInvocationBuilder setFilterAnnotations(Set<Class<? extends Annotation>> filterAnnotations) {
            this.filterAnnotations = filterAnnotations;
            return this;
        }

        public CacheEntryListenerInvocation<K, V> build() {
            BaseCacheEntryListenerInvocation returnValue;
            AbstractListenerImpl.ListenerInvocationImpl invocation = new AbstractListenerImpl.ListenerInvocationImpl(CacheNotifierImpl.this, this.target, this.method, this.sync, this.classLoader, this.subject);
            this.wireDependencies(this.filter, this.converter);
            if (this.includeCurrentState) {
                if (this.clustered) {
                    QueueingSegmentListener handler = (QueueingAllSegmentListener)CacheNotifierImpl.this.segmentHandler.get(this.identifier);
                    if (handler == null) {
                        if (CacheNotifierImpl.this.clusterListenerOnPrimaryOnly()) {
                            LocalizedCacheTopology cacheTopology = CacheNotifierImpl.this.clusteringDependentLogic.running().getCacheTopology();
                            handler = new DistributedQueueingSegmentListener(CacheNotifierImpl.this.entryFactory, cacheTopology.getCurrentCH().getNumSegments(), cacheTopology::getSegment);
                        } else {
                            handler = new QueueingAllSegmentListener(CacheNotifierImpl.this.entryFactory);
                        }
                        QueueingSegmentListener currentQueue = CacheNotifierImpl.this.segmentHandler.putIfAbsent(this.identifier, handler);
                        if (currentQueue != null) {
                            handler = currentQueue;
                        }
                    }
                    returnValue = new ClusteredListenerInvocation(CacheNotifierImpl.this.encoderRegistry, invocation, handler, this.filter, this.converter, this.annotation, this.onlyPrimary, this.identifier, this.sync, this.observation, this.filterAnnotations, this.keyDataConversion, this.valueDataConversion, this.storageFormat);
                } else {
                    returnValue = new BaseCacheEntryListenerInvocation(CacheNotifierImpl.this.encoderRegistry, invocation, this.filter, this.converter, this.annotation, this.onlyPrimary, this.clustered, this.identifier, this.sync, this.observation, this.filterAnnotations, this.keyDataConversion, this.valueDataConversion, this.storageFormat);
                }
            } else {
                returnValue = new BaseCacheEntryListenerInvocation(CacheNotifierImpl.this.encoderRegistry, invocation, this.filter, this.converter, this.annotation, this.onlyPrimary, this.clustered, this.identifier, this.sync, this.observation, this.filterAnnotations, this.keyDataConversion, this.valueDataConversion, this.storageFormat);
            }
            return returnValue;
        }

        protected <C> void wireDependencies(CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
            if (filter != null) {
                CacheNotifierImpl.this.componentRegistry.wireDependencies(filter, false);
            }
            if (converter != null && converter != filter) {
                CacheNotifierImpl.this.componentRegistry.wireDependencies(converter, false);
            }
            if (this.keyDataConversion != null) {
                CacheNotifierImpl.this.componentRegistry.wireDependencies(this.keyDataConversion, false);
            }
            if (this.valueDataConversion != null) {
                CacheNotifierImpl.this.componentRegistry.wireDependencies(this.valueDataConversion, false);
            }
        }
    }
}

