/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtils {
    public static <K, V> Stream<Pair<K, V>> leftInnerJoinStream(Stream<K> stream, Function<? super K, Stream<V>> mapper) {
        return StreamSupport.stream(() -> new ToPairSpliterator(stream, mapper), 1024, false);
    }

    public static <K, V> Stream<Pair<K, V>> leftInnerJoinIterable(Stream<K> stream, Function<? super K, ? extends Iterable<V>> mapper) {
        return StreamSupport.stream(() -> new IterableToPairSpliterator(stream, mapper), 1024, false);
    }

    private static class IterableToPairSpliterator<K, V>
    extends AbstractToPairSpliterator<K, V, Function<? super K, ? extends Iterable<V>>> {
        public IterableToPairSpliterator(Stream<K> stream, Function<? super K, ? extends Iterable<V>> mapper) {
            super(stream, mapper);
        }

        @Override
        protected void nextKey() {
            this.flatMapIterator = null;
            while (this.flatMapIterator == null && this.streamIterator.hasNext()) {
                this.currentKey = this.streamIterator.next();
                Iterable vStream = (Iterable)((Function)this.mapper).apply(this.currentKey);
                this.flatMapIterator = vStream == null ? null : vStream.iterator();
            }
        }
    }

    private static class ToPairSpliterator<K, V>
    extends AbstractToPairSpliterator<K, V, Function<? super K, Stream<V>>> {
        public ToPairSpliterator(Stream<K> stream, Function<? super K, Stream<V>> mapper) {
            super(stream, mapper);
        }

        @Override
        protected void nextKey() {
            this.flatMapIterator = null;
            while (this.flatMapIterator == null && this.streamIterator.hasNext()) {
                this.currentKey = this.streamIterator.next();
                Stream vStream = (Stream)((Function)this.mapper).apply(this.currentKey);
                this.flatMapIterator = vStream == null ? null : vStream.iterator();
            }
        }
    }

    public static abstract class AbstractToPairSpliterator<K, V, M>
    implements Spliterator<Pair<K, V>> {
        protected final Iterator<K> streamIterator;
        protected final M mapper;
        protected Iterator<V> flatMapIterator;
        protected K currentKey;

        public AbstractToPairSpliterator(Stream<K> stream, M mapper) {
            this.streamIterator = stream.iterator();
            this.mapper = mapper;
        }

        protected abstract void nextKey();

        @Override
        public boolean tryAdvance(Consumer<? super Pair<K, V>> action) {
            if (this.flatMapIterator != null && this.flatMapIterator.hasNext()) {
                action.accept(new Pair<K, V>(this.currentKey, this.flatMapIterator.next()));
                return true;
            }
            this.nextKey();
            if (this.flatMapIterator != null && this.flatMapIterator.hasNext()) {
                action.accept(new Pair<K, V>(this.currentKey, this.flatMapIterator.next()));
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<Pair<K, V>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1024;
        }
    }

    public static final class Pair<T1, T2> {
        private final T1 k;
        private final T2 v;

        public Pair(T1 k, T2 v) {
            this.k = k;
            this.v = v;
        }

        public T1 getK() {
            return this.k;
        }

        public T2 getV() {
            return this.v;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.k);
            hash = 97 * hash + Objects.hashCode(this.v);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            if (!Objects.equals(this.k, other.k)) {
                return false;
            }
            return Objects.equals(this.v, other.v);
        }

        public String toString() {
            return "[" + this.k + ", " + this.v + "]";
        }
    }
}

