/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common.delegate;

import java.util.Collection;
import java.util.Map;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.UpdatableEntity;

public interface EntityFieldDelegate<E>
extends UpdatableEntity {
    public <EF extends Enum<? extends EntityField<E>>> Object get(EF var1);

    default public <T, EF extends Enum<? extends EntityField<E>>> void set(EF field, T value) {
    }

    default public <T, EF extends Enum<? extends EntityField<E>>> void collectionAdd(EF field, T value) {
        Collection c = (Collection)this.get(field);
        if (c != null) {
            c.add(value);
        }
    }

    default public <T, EF extends Enum<? extends EntityField<E>>> Object collectionRemove(EF field, T value) {
        Collection c = (Collection)this.get(field);
        return c == null ? null : Boolean.valueOf(c.remove(value));
    }

    default public <K, EF extends Enum<? extends EntityField<E>>> Object mapGet(EF field, K key) {
        Map m = (Map)this.get(field);
        return m == null ? null : m.get(key);
    }

    default public <K, T, EF extends Enum<? extends EntityField<E>>> void mapPut(EF field, K key, T value) {
        Map m = (Map)this.get(field);
        if (m != null) {
            m.put(key, value);
        }
    }

    default public <K, EF extends Enum<? extends EntityField<E>>> Object mapRemove(EF field, K key) {
        Map m = (Map)this.get(field);
        if (m != null) {
            return m.remove(key);
        }
        return null;
    }
}

