/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractStartCommand;
import picocli.CommandLine;

public abstract class AbstractExportImportCommand
extends AbstractStartCommand
implements Runnable {
    private final String action;
    @CommandLine.Option(names={"--dir"}, arity="1", description={"Set the path to a directory where files will be read from when importing or created with the exported data."}, paramLabel="<path>")
    String toDir;
    @CommandLine.Option(names={"--file"}, arity="1", description={"Set the path to a file that will be read when importing or created with the exported data."}, paramLabel="<path>")
    String toFile;

    protected AbstractExportImportCommand(String action) {
        this.action = action;
    }

    @Override
    public void run() {
        System.setProperty("keycloak.migration.action", this.action);
        if (this.toDir != null) {
            System.setProperty("keycloak.migration.provider", "dir");
            System.setProperty("keycloak.migration.dir", this.toDir);
        } else if (this.toFile != null) {
            System.setProperty("keycloak.migration.provider", "singleFile");
            System.setProperty("keycloak.migration.file", this.toFile);
        } else {
            this.executionError(this.spec.commandLine(), "Must specify either --dir or --file options.");
        }
        Environment.setProfile("import_export");
        super.run();
    }
}

