/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.NoContent;
import org.jboss.resteasy.util.TypeConverter;

@Provider
@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
public class DefaultTextPlain
implements MessageBodyReader,
AsyncMessageBodyWriter {
    public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !String.class.equals((Object)type) && TypeConverter.isConvertable(type);
    }

    public Object readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        InputStream delegate = NoContent.noContentCheck((MultivaluedMap<String, String>)httpHeaders, entityStream);
        String value = ProviderHelper.readString(delegate, mediaType);
        return TypeConverter.getType(type, value);
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !String.class.equals((Object)type) && !type.isArray();
    }

    public long getSize(Object o, Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset != null) {
            try {
                return o.toString().getBytes(charset).length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return o.toString().getBytes(StandardCharsets.UTF_8).length;
    }

    public void writeTo(Object o, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset == null) {
            entityStream.write(o.toString().getBytes(StandardCharsets.UTF_8));
        } else {
            entityStream.write(o.toString().getBytes(charset));
        }
    }

    public CompletionStage<Void> asyncWriteTo(Object o, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, AsyncOutputStream entityStream) {
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset == null) {
            return entityStream.asyncWrite(o.toString().getBytes(StandardCharsets.UTF_8));
        }
        try {
            return entityStream.asyncWrite(o.toString().getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            return ProviderHelper.completedException(e);
        }
    }
}

