/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.clientscope;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.hotRod.client.HotRodProtocolMapperEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodProtocolMapperEntityDelegate;
import org.keycloak.models.map.storage.hotRod.clientscope.HotRodClientScopeEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntityNonIndexed;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;

public class HotRodClientScopeEntityDelegate
extends HotRodClientScopeEntity.AbstractHotRodClientScopeEntityDelegate
implements MapClientScopeEntity {
    private final HotRodClientScopeEntity hotRodEntity;
    private final DeepCloner cloner;

    public HotRodClientScopeEntityDelegate() {
        this.cloner = DeepCloner.DUMB_CLONER;
        this.hotRodEntity = new HotRodClientScopeEntity();
    }

    public HotRodClientScopeEntityDelegate(HotRodClientScopeEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public HotRodClientScopeEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodClientScopeEntity();
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodClientScopeEntityDelegate)) {
            return false;
        }
        HotRodClientScopeEntityDelegate other = (HotRodClientScopeEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getProtocol(), other.getProtocol()) && Objects.equals(this.getProtocolMappers(), other.getProtocolMappers()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getScopeMappings(), other.getScopeMappings());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodClientScopeEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodClientScopeEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodClientScopeEntity e1 = (HotRodClientScopeEntity)o1;
        HotRodClientScopeEntity e2 = (HotRodClientScopeEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.realmId, e2.realmId) && Objects.equals(e1.name, e2.name) && Objects.equals(e1.protocol, e2.protocol) && Objects.equals(e1.description, e2.description) && Objects.equals(e1.scopeMappings, e2.scopeMappings) && Objects.equals(e1.protocolMappers, e2.protocolMappers) && Objects.equals(e1.attributes, e2.attributes);
    }

    public static int entityHashCode(HotRodClientScopeEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public <V> V deepClone(V obj) {
        return (V)this.cloner.from(obj);
    }

    public void setAttribute(String p0, List<String> p1) {
        LinkedList<String> linkedList = p1 = p1 == null ? null : new LinkedList<String>(p1);
        if (p1 != null) {
            p1.removeIf(UndefinedValuesUtils::isUndefined);
        }
        boolean valueUndefined = UndefinedValuesUtils.isUndefined(p1);
        if (this.hotRodEntity.attributes == null && !valueUndefined) {
            this.hotRodEntity.attributes = new HashSet<HotRodAttributeEntityNonIndexed>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.attributes.add(new HotRodAttributeEntityNonIndexed(p0, p1)));
    }

    public void removeAttribute(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public void setAttributes(Map<String, List<String>> p0) {
        Map<String, List<String>> map = p0 = p0 == null ? null : (Map<String, List<String>>)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodAttributeEntityNonIndexed> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodAttributeEntityNonIndexedFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.attributes, migrated);
        this.hotRodEntity.attributes = migrated;
    }

    public Map<String, List<String>> getAttributes() {
        return this.hotRodEntity.attributes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.attributes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public List<String> getAttribute(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public String getDescription() {
        return this.hotRodEntity.description == null ? null : this.hotRodEntity.description;
    }

    public void setDescription(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.description, migrated);
        this.hotRodEntity.description = migrated;
    }

    public void setName(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.name, migrated);
        this.hotRodEntity.name = migrated;
    }

    public String getName() {
        return this.hotRodEntity.name == null ? null : this.hotRodEntity.name;
    }

    public void setProtocol(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.protocol, migrated);
        this.hotRodEntity.protocol = migrated;
    }

    public String getProtocol() {
        return this.hotRodEntity.protocol == null ? null : this.hotRodEntity.protocol;
    }

    public void addProtocolMapper(MapProtocolMapperEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.protocolMappers == null) {
            this.hotRodEntity.protocolMappers = new HashSet<HotRodProtocolMapperEntity>();
        }
        HotRodProtocolMapperEntity migrated = (HotRodProtocolMapperEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.protocolMappers.add(migrated);
    }

    public Set<MapProtocolMapperEntity> getProtocolMappers() {
        return this.hotRodEntity.protocolMappers == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.protocolMappers, collectionItem -> new HotRodProtocolMapperEntityDelegate((HotRodProtocolMapperEntity)collectionItem));
    }

    public void setRealmId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.realmId, migrated);
        this.hotRodEntity.realmId = migrated;
    }

    public String getRealmId() {
        return this.hotRodEntity.realmId == null ? null : this.hotRodEntity.realmId;
    }

    public void addScopeMapping(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.scopeMappings == null) {
            this.hotRodEntity.scopeMappings = new LinkedList<String>();
        }
        String migrated = p0;
        this.hotRodEntity.scopeMappings.add(migrated);
        this.hotRodEntity.updated = true;
    }

    public Collection<String> getScopeMappings() {
        return this.hotRodEntity.scopeMappings == null ? null : this.hotRodEntity.scopeMappings;
    }

    public void removeScopeMapping(String p0) {
        if (this.hotRodEntity.scopeMappings == null) {
            return;
        }
        boolean removed = this.hotRodEntity.scopeMappings.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    @Override
    public HotRodClientScopeEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

