/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault;

import io.quarkus.vault.VaultKubernetesAuthReactiveService;
import io.quarkus.vault.auth.VaultKubernetesAuthConfig;
import io.quarkus.vault.auth.VaultKubernetesAuthRole;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class VaultKubernetesAuthService {
    private final VaultKubernetesAuthReactiveService service;

    public VaultKubernetesAuthService() {
    }

    @Inject
    public VaultKubernetesAuthService(VaultKubernetesAuthReactiveService service) {
        this.service = service;
    }

    public void configure(VaultKubernetesAuthConfig config) {
        this.service.configure(config).await().indefinitely();
    }

    public VaultKubernetesAuthConfig getConfig() {
        return (VaultKubernetesAuthConfig)this.service.getConfig().await().indefinitely();
    }

    public VaultKubernetesAuthRole getRole(String name) {
        return (VaultKubernetesAuthRole)this.service.getRole(name).await().indefinitely();
    }

    public void createRole(String name, VaultKubernetesAuthRole role) {
        this.service.createRole(name, role).await().indefinitely();
    }

    public void deleteRole(String name) {
        this.service.deleteRole(name).await().indefinitely();
    }

    public List<String> getRoles() {
        return (List)this.service.getRoles().await().indefinitely();
    }
}

