/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.DeploymentStateProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.delegate.ClientModelLazyDelegate;
import org.keycloak.models.jpa.ClientAdapter;
import org.keycloak.models.jpa.ClientScopeAdapter;
import org.keycloak.models.jpa.GroupAdapter;
import org.keycloak.models.jpa.MigrationModelAdapter;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.jpa.RealmAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.ClientScopeClientMappingEntity;
import org.keycloak.models.jpa.entities.ClientScopeEntity;
import org.keycloak.models.jpa.entities.GroupEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RealmLocalizationTextsEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.utils.StreamsUtil;

public class JpaRealmProvider
implements RealmProvider,
ClientProvider,
ClientScopeProvider,
GroupProvider,
RoleProvider,
DeploymentStateProvider {
    protected static final Logger logger = Logger.getLogger(JpaRealmProvider.class);
    private final KeycloakSession session;
    protected EntityManager em;
    private Set<String> clientSearchableAttributes;
    private Set<String> groupSearchableAttributes;

    public JpaRealmProvider(KeycloakSession session, EntityManager em, Set<String> clientSearchableAttributes, Set<String> groupSearchableAttributes) {
        this.session = session;
        this.em = em;
        this.clientSearchableAttributes = clientSearchableAttributes;
        this.groupSearchableAttributes = groupSearchableAttributes;
    }

    public MigrationModel getMigrationModel() {
        return new MigrationModelAdapter(this.em);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        RealmEntity realm = new RealmEntity();
        realm.setName(name);
        realm.setId(id);
        this.em.persist((Object)realm);
        this.em.flush();
        RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmCreationEvent((RealmModel)adapter){
            final /* synthetic */ RealmModel val$adapter;
            {
                this.val$adapter = realmModel;
            }

            public RealmModel getCreatedRealm() {
                return this.val$adapter;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        });
        return adapter;
    }

    public RealmModel getRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return null;
        }
        RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        return adapter;
    }

    public Stream<RealmModel> getRealmsWithProviderTypeStream(Class<?> providerType) {
        TypedQuery query = this.em.createNamedQuery("getRealmIdsWithProviderType", String.class);
        query.setParameter("providerType", (Object)providerType.getName());
        return this.getRealms((TypedQuery<String>)query);
    }

    public Stream<RealmModel> getRealmsStream() {
        TypedQuery query = this.em.createNamedQuery("getAllRealmIds", String.class);
        return this.getRealms((TypedQuery<String>)query);
    }

    private Stream<RealmModel> getRealms(TypedQuery<String> query) {
        return StreamsUtil.closing(query.getResultStream().map(arg_0 -> ((RealmProvider)this.session.realms()).getRealm(arg_0)).filter(Objects::nonNull));
    }

    public RealmModel getRealmByName(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmIdByName", String.class);
        query.setParameter("name", (Object)name);
        List entities = query.getResultList();
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() > 1) {
            throw new IllegalStateException("Should not be more than one realm with same name");
        }
        String id = (String)query.getResultList().get(0);
        return this.session.realms().getRealm(id);
    }

    public boolean removeRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (realm == null) {
            return false;
        }
        this.em.refresh((Object)realm);
        final RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        this.session.users().preRemove((RealmModel)adapter);
        realm.getDefaultGroupIds().clear();
        this.em.flush();
        int num = this.em.createNamedQuery("deleteGroupRoleMappingsByRealm").setParameter("realm", (Object)realm.getId()).executeUpdate();
        this.session.clients().removeClients((RealmModel)adapter);
        num = this.em.createNamedQuery("deleteDefaultClientScopeRealmMappingByRealm").setParameter("realm", (Object)realm).executeUpdate();
        this.session.clientScopes().removeClientScopes((RealmModel)adapter);
        this.session.roles().removeRoles((RealmModel)adapter);
        adapter.getTopLevelGroupsStream().forEach(adapter::removeGroup);
        num = this.em.createNamedQuery("removeClientInitialAccessByRealm").setParameter("realm", (Object)realm).executeUpdate();
        this.em.remove((Object)realm);
        this.em.flush();
        this.em.clear();
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmRemovedEvent(){

            public RealmModel getRealm() {
                return adapter;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        });
        return true;
    }

    public void close() {
    }

    public RoleModel addRealmRole(RealmModel realm, String name) {
        return this.addRealmRole(realm, KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        if (this.getRealmRole(realm, name) != null) {
            throw new ModelDuplicateException();
        }
        RoleEntity entity = new RoleEntity();
        entity.setId(id);
        entity.setName(name);
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        RoleAdapter adapter = new RoleAdapter(this.session, realm, this.em, entity);
        return adapter;
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoleIdByName", String.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)realm.getId());
        List roles = query.getResultList();
        if (roles.isEmpty()) {
            return null;
        }
        return this.session.roles().getRoleById(realm, (String)roles.get(0));
    }

    public RoleModel addClientRole(ClientModel client, String name) {
        return this.addClientRole(client, KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addClientRole(ClientModel client, String id, String name) {
        if (this.getClientRole(client, name) != null) {
            throw new ModelDuplicateException();
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setRealmId(client.getRealm().getId());
        roleEntity.setClientId(client.getId());
        roleEntity.setClientRole(true);
        this.em.persist((Object)roleEntity);
        RoleAdapter adapter = new RoleAdapter(this.session, client.getRealm(), this.em, roleEntity);
        return adapter;
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoleIds", String.class);
        query.setParameter("realm", (Object)realm.getId());
        Stream roles = query.getResultStream();
        return StreamsUtil.closing(roles.map(arg_0 -> ((RealmModel)realm).getRoleById(arg_0)));
    }

    public RoleModel getClientRole(ClientModel client, String name) {
        TypedQuery query = this.em.createNamedQuery("getClientRoleIdByName", String.class);
        query.setParameter("name", (Object)name);
        query.setParameter("client", (Object)client.getId());
        List roles = query.getResultList();
        if (roles.isEmpty()) {
            return null;
        }
        return this.session.roles().getRoleById(client.getRealm(), (String)roles.get(0));
    }

    public Map<ClientModel, Set<String>> getAllRedirectUrisOfEnabledClients(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getAllRedirectUrisOfEnabledClients", Map.class);
        query.setParameter("realm", (Object)realm.getId());
        return StreamsUtil.closing(query.getResultStream().filter(s -> s.get("client") != null)).collect(Collectors.groupingBy(s -> new ClientAdapter(realm, this.em, this.session, (ClientEntity)s.get("client")), Collectors.mapping(s -> (String)s.get("redirectUri"), Collectors.toSet())));
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoles", RoleEntity.class);
        query.setParameter("realm", (Object)realm.getId());
        return this.getRolesStream((TypedQuery<RoleEntity>)query, realm, first, max);
    }

    public Stream<RoleModel> getRolesStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        if (ids == null) {
            return Stream.empty();
        }
        TypedQuery query = search == null ? this.em.createNamedQuery("getRoleIdsFromIdList", String.class) : this.em.createNamedQuery("getRoleIdsByNameContainingFromIdList", String.class).setParameter("search", (Object)search);
        query.setParameter("realm", (Object)realm.getId()).setParameter("ids", ids.collect(Collectors.toList()));
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(query, first, max).getResultStream()).map(g -> this.session.roles().getRoleById(realm, g));
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("getClientRoles", RoleEntity.class);
        query.setParameter("client", (Object)client.getId());
        return this.getRolesStream((TypedQuery<RoleEntity>)query, client.getRealm(), first, max);
    }

    protected Stream<RoleModel> getRolesStream(TypedQuery<RoleEntity> query, RealmModel realm, Integer first, Integer max) {
        Stream results = PaginationUtils.paginateQuery(query, first, max).getResultStream();
        return StreamsUtil.closing(results.map(role -> new RoleAdapter(this.session, realm, this.em, (RoleEntity)role)));
    }

    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("searchForClientRoles", RoleEntity.class);
        query.setParameter("client", (Object)client.getId());
        return this.searchForRoles((TypedQuery<RoleEntity>)query, client.getRealm(), search, first, max);
    }

    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("searchForRealmRoles", RoleEntity.class);
        query.setParameter("realm", (Object)realm.getId());
        return this.searchForRoles((TypedQuery<RoleEntity>)query, realm, search, first, max);
    }

    protected Stream<RoleModel> searchForRoles(TypedQuery<RoleEntity> query, RealmModel realm, String search, Integer first, Integer max) {
        query.setParameter("search", (Object)("%" + search.trim().toLowerCase() + "%"));
        Stream results = PaginationUtils.paginateQuery(query, first, max).getResultStream();
        return StreamsUtil.closing(results.map(role -> new RoleAdapter(this.session, realm, this.em, (RoleEntity)role)));
    }

    public boolean removeRole(RoleModel role) {
        RealmModel realm;
        if (role.getContainer() instanceof RealmModel) {
            realm = (RealmModel)role.getContainer();
        } else if (role.getContainer() instanceof ClientModel) {
            realm = ((ClientModel)role.getContainer()).getRealm();
        } else {
            throw new IllegalStateException("RoleModel's container isn not instance of either RealmModel or ClientModel");
        }
        this.session.users().preRemove(realm, role);
        RoleEntity roleEntity = (RoleEntity)this.em.getReference(RoleEntity.class, (Object)role.getId());
        if (roleEntity == null || !roleEntity.getRealmId().equals(realm.getId())) {
            throw new ModelException("Role not found or trying to remove role from incorrect realm");
        }
        String compositeRoleTable = JpaUtils.getTableNameForNativeQuery("COMPOSITE_ROLE", this.em);
        this.em.createNativeQuery("delete from " + compositeRoleTable + " where CHILD_ROLE = :role").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.createNamedQuery("deleteClientScopeRoleMappingByRole").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.flush();
        this.em.remove((Object)roleEntity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)this.roleRemovedEvent(role));
        this.em.flush();
        return true;
    }

    public RoleContainerModel.RoleRemovedEvent roleRemovedEvent(final RoleModel role) {
        return new RoleContainerModel.RoleRemovedEvent(){

            public RoleModel getRole() {
                return role;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        };
    }

    public void removeRoles(RealmModel realm) {
        realm.getRolesStream().forEach(this::removeRole);
    }

    public void removeRoles(ClientModel client) {
        client.getRolesStream().forEach(this::removeRole);
    }

    public RoleModel getRoleById(RealmModel realm, String id) {
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!realm.getId().equals(entity.getRealmId())) {
            return null;
        }
        RoleAdapter adapter = new RoleAdapter(this.session, realm, this.em, entity);
        return adapter;
    }

    public GroupModel getGroupById(RealmModel realm, String id) {
        GroupEntity groupEntity = (GroupEntity)this.em.find(GroupEntity.class, (Object)id);
        if (groupEntity == null) {
            return null;
        }
        if (!groupEntity.getRealm().equals(realm.getId())) {
            return null;
        }
        GroupAdapter adapter = new GroupAdapter(realm, this.em, groupEntity);
        return adapter;
    }

    public void moveGroup(final RealmModel realm, GroupModel group, GroupModel toParent) {
        if (toParent != null && group.getId().equals(toParent.getId())) {
            return;
        }
        if (group.getParentId() != null) {
            group.getParent().removeChild(group);
        }
        GroupModel previousParent = group.getParent();
        group.setParent(toParent);
        if (toParent != null) {
            toParent.addChild(group);
        } else {
            this.session.groups().addTopLevelGroup(realm, group);
        }
        this.em.flush();
        final String newPath = KeycloakModelUtils.buildGroupPath((GroupModel)group);
        final String previousPath = KeycloakModelUtils.buildGroupPath((GroupModel)group, (GroupModel)previousParent);
        GroupModel.GroupPathChangeEvent event = new GroupModel.GroupPathChangeEvent(){

            public RealmModel getRealm() {
                return realm;
            }

            public String getNewPath() {
                return newPath;
            }

            public String getPreviousPath() {
                return previousPath;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        };
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)event);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm) {
        return StreamsUtil.closing((Stream)this.em.createNamedQuery("getGroupIdsByRealm", String.class).setParameter("realm", (Object)realm.getId()).getResultStream()).map(g -> this.session.groups().getGroupById(realm, g));
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        if (search == null || search.isEmpty()) {
            return this.getGroupsStream(realm, ids, first, max);
        }
        TypedQuery query = this.em.createNamedQuery("getGroupIdsByNameContainingFromIdList", String.class).setParameter("realm", (Object)realm.getId()).setParameter("search", (Object)search).setParameter("ids", ids.collect(Collectors.toList()));
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(query, first, max).getResultStream()).map(g -> this.session.groups().getGroupById(realm, g));
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, Integer first, Integer max) {
        if (first == null && max == null) {
            return this.getGroupsStream(realm, ids);
        }
        TypedQuery query = this.em.createNamedQuery("getGroupIdsFromIdList", String.class).setParameter("realm", (Object)realm.getId()).setParameter("ids", ids.collect(Collectors.toList()));
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(query, first, max).getResultStream()).map(g -> this.session.groups().getGroupById(realm, g));
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids) {
        return ids.map(id -> this.session.groups().getGroupById(realm, id)).sorted(GroupModel.COMPARE_BY_NAME);
    }

    public Long getGroupsCount(RealmModel realm, Stream<String> ids, String search) {
        TypedQuery query = search != null && !search.isEmpty() ? this.em.createNamedQuery("getGroupCountByNameContainingFromIdList", Long.class).setParameter("search", (Object)search) : this.em.createNamedQuery("getGroupIdsFromIdList", Long.class);
        return (Long)query.setParameter("realm", (Object)realm.getId()).setParameter("ids", ids.collect(Collectors.toList())).getSingleResult();
    }

    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        if (Objects.equals(onlyTopGroups, Boolean.TRUE)) {
            return (Long)this.em.createNamedQuery("getTopLevelGroupCount", Long.class).setParameter("realm", (Object)realm.getId()).setParameter("parent", (Object)GroupEntity.TOP_PARENT_ID).getSingleResult();
        }
        return (Long)this.em.createNamedQuery("getGroupCount", Long.class).setParameter("realm", (Object)realm.getId()).getSingleResult();
    }

    public long getClientsCount(RealmModel realm) {
        Long res = (Long)this.em.createNamedQuery("getRealmClientsCount", Long.class).setParameter("realm", (Object)realm.getId()).getSingleResult();
        return res == null ? 0L : res;
    }

    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        return this.searchForGroupByNameStream(realm, search, false, null, null).count();
    }

    public Stream<GroupModel> getGroupsByRoleStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        TypedQuery query = this.em.createNamedQuery("groupsInRole", GroupEntity.class);
        query.setParameter("roleId", (Object)role.getId());
        Stream results = PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultStream();
        return StreamsUtil.closing(results.map(g -> new GroupAdapter(realm, this.em, (GroupEntity)g)).sorted(GroupModel.COMPARE_BY_NAME));
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm) {
        return this.getTopLevelGroupsStream(realm, null, null);
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm, Integer first, Integer max) {
        TypedQuery groupsQuery = this.em.createNamedQuery("getTopLevelGroupIds", String.class).setParameter("realm", (Object)realm.getId()).setParameter("parent", (Object)GroupEntity.TOP_PARENT_ID);
        return StreamsUtil.closing(PaginationUtils.paginateQuery(groupsQuery, first, max).getResultStream().map(arg_0 -> ((RealmModel)realm).getGroupById(arg_0)).filter(Objects::nonNull).sorted(GroupModel.COMPARE_BY_NAME));
    }

    public boolean removeGroup(final RealmModel realm, final GroupModel group) {
        if (group == null) {
            return false;
        }
        GroupModel.GroupRemovedEvent event = new GroupModel.GroupRemovedEvent(){

            public RealmModel getRealm() {
                return realm;
            }

            public GroupModel getGroup() {
                return group;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        };
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)event);
        this.session.users().preRemove(realm, group);
        realm.removeDefaultGroup(group);
        group.getSubGroupsStream().forEach(arg_0 -> ((RealmModel)realm).removeGroup(arg_0));
        GroupEntity groupEntity = (GroupEntity)this.em.find(GroupEntity.class, (Object)group.getId(), LockModeType.PESSIMISTIC_WRITE);
        if (groupEntity == null || !groupEntity.getRealm().equals(realm.getId())) {
            return false;
        }
        this.em.createNamedQuery("deleteGroupRoleMappingsByGroup").setParameter("group", (Object)groupEntity).executeUpdate();
        this.em.remove((Object)groupEntity);
        return true;
    }

    public GroupModel createGroup(RealmModel realm, String id, String name, GroupModel toParent) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        } else if (GroupEntity.TOP_PARENT_ID.equals(id)) {
            throw new ModelException("The ID of the new group is equals to the tag used for top level groups");
        }
        GroupEntity groupEntity = new GroupEntity();
        groupEntity.setId(id);
        groupEntity.setName(name);
        groupEntity.setRealm(realm.getId());
        groupEntity.setParentId(toParent == null ? GroupEntity.TOP_PARENT_ID : toParent.getId());
        this.em.persist((Object)groupEntity);
        this.em.flush();
        return new GroupAdapter(realm, this.em, groupEntity);
    }

    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        subGroup.setParent(null);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.em.createNamedQuery("deleteGroupRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
        String clientScopeMapping = JpaUtils.getTableNameForNativeQuery("SCOPE_MAPPING", this.em);
        this.em.createNativeQuery("delete from " + clientScopeMapping + " where ROLE_ID = :role").setParameter("role", (Object)role.getId()).executeUpdate();
    }

    public ClientModel addClient(RealmModel realm, String clientId) {
        return this.addClient(realm, KeycloakModelUtils.generateId(), clientId);
    }

    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        if (clientId == null) {
            clientId = id;
        }
        logger.tracef("addClient(%s, %s, %s)%s", new Object[]{realm, id, clientId, StackUtil.getShortStackTrace()});
        ClientEntity entity = new ClientEntity();
        entity.setId(id);
        entity.setClientId(clientId);
        entity.setEnabled(true);
        entity.setStandardFlowEnabled(true);
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        ClientAdapter resource = new ClientAdapter(realm, this.em, this.session, entity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)((ClientModel.ClientCreationEvent)() -> resource));
        return resource;
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm) {
        return this.getClientsStream(realm, null, null);
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        TypedQuery query = this.em.createNamedQuery("getClientIdsByRealm", String.class);
        query.setParameter("realm", (Object)realm.getId());
        Stream clients = PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultStream();
        return StreamsUtil.closing(clients.map(id -> new ClientModelLazyDelegate.WithId(this.session, realm, id)));
    }

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getAlwaysDisplayInConsoleClients", String.class);
        query.setParameter("realm", (Object)realm.getId());
        Stream clientStream = query.getResultStream();
        return StreamsUtil.closing(clientStream.map(c -> this.session.clients().getClientById(realm, c)).filter(Objects::nonNull));
    }

    public ClientModel getClientById(RealmModel realm, String id) {
        logger.tracef("getClientById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        ClientEntity client = (ClientEntity)this.em.find(ClientEntity.class, (Object)id);
        if (client == null || !realm.getId().equals(client.getRealmId())) {
            return null;
        }
        ClientAdapter adapter = new ClientAdapter(realm, this.em, this.session, client);
        return adapter;
    }

    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        logger.tracef("getClientByClientId(%s, %s)%s", (Object)realm, (Object)clientId, StackUtil.getShortStackTrace());
        TypedQuery query = this.em.createNamedQuery("findClientIdByClientId", String.class);
        query.setParameter("clientId", (Object)clientId);
        query.setParameter("realm", (Object)realm.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        String id = (String)results.get(0);
        return this.session.clients().getClientById(realm, id);
    }

    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        TypedQuery query = this.em.createNamedQuery("searchClientsByClientId", String.class);
        query.setParameter("clientId", (Object)clientId);
        query.setParameter("realm", (Object)realm.getId());
        Stream results = PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultStream();
        return StreamsUtil.closing(results.map(id -> new ClientModelLazyDelegate.WithId(this.session, realm, id)));
    }

    public Stream<ClientModel> searchClientsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        Map<String, String> filteredAttributes = this.clientSearchableAttributes == null ? attributes : attributes.entrySet().stream().filter(m -> this.clientSearchableAttributes.contains(m.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(ClientEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        for (Map.Entry<String, String> entry : filteredAttributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Join attributeJoin = root.join("attributes");
            Predicate attrNamePredicate = builder.equal((Expression)attributeJoin.get("name"), (Object)key);
            Predicate attrValuePredicate = builder.equal((Expression)attributeJoin.get("value"), (Object)value);
            predicates.add(builder.and((Expression)attrNamePredicate, (Expression)attrValuePredicate));
        }
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        queryBuilder.where((Expression)finalPredicate).orderBy(new Order[]{builder.asc((Expression)root.get("clientId"))});
        TypedQuery query = this.em.createQuery(queryBuilder);
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultStream()).map(id -> this.session.clients().getClientById(realm, id));
    }

    public void removeClients(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getClientIdsByRealm", String.class);
        query.setParameter("realm", (Object)realm.getId());
        List clients = query.getResultList();
        for (String client : clients) {
            this.removeClient(realm, client);
        }
    }

    public boolean removeClient(RealmModel realm, String id) {
        logger.tracef("removeClient(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        final ClientModel client = this.getClientById(realm, id);
        if (client == null) {
            return false;
        }
        this.session.users().preRemove(realm, client);
        this.session.roles().removeRoles(client);
        ClientEntity clientEntity = (ClientEntity)this.em.find(ClientEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new ClientModel.ClientRemovedEvent(){

            public ClientModel getClient() {
                return client;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        });
        int countRemoved = this.em.createNamedQuery("deleteClientScopeClientMappingByClient").setParameter("clientId", (Object)clientEntity.getId()).executeUpdate();
        this.em.remove((Object)clientEntity);
        try {
            this.em.flush();
        }
        catch (RuntimeException e) {
            logger.errorv("Unable to delete client entity: {0} from realm {1}", (Object)client.getClientId(), (Object)realm.getName());
            throw e;
        }
        return true;
    }

    public ClientScopeModel getClientScopeById(RealmModel realm, String id) {
        ClientScopeEntity clientScope = (ClientScopeEntity)this.em.find(ClientScopeEntity.class, (Object)id);
        if (clientScope == null || !realm.getId().equals(clientScope.getRealmId())) {
            return null;
        }
        ClientScopeAdapter adapter = new ClientScopeAdapter(realm, this.em, this.session, clientScope);
        return adapter;
    }

    public Stream<ClientScopeModel> getClientScopesStream(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getClientScopeIds", String.class);
        query.setParameter("realm", (Object)realm.getId());
        Stream scopes = query.getResultStream();
        return StreamsUtil.closing(scopes.map(arg_0 -> ((RealmModel)realm).getClientScopeById(arg_0)));
    }

    public ClientScopeModel addClientScope(RealmModel realm, String id, String name) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        ClientScopeEntity entity = new ClientScopeEntity();
        entity.setId(id);
        name = KeycloakModelUtils.convertClientScopeName((String)name);
        entity.setName(name);
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        return new ClientScopeAdapter(realm, this.em, this.session, entity);
    }

    public boolean removeClientScope(RealmModel realm, String id) {
        if (id == null) {
            return false;
        }
        final ClientScopeModel clientScope = this.getClientScopeById(realm, id);
        if (clientScope == null) {
            return false;
        }
        this.session.users().preRemove(clientScope);
        realm.removeDefaultClientScope(clientScope);
        ClientScopeEntity clientScopeEntity = (ClientScopeEntity)this.em.find(ClientScopeEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        this.em.createNamedQuery("deleteClientScopeClientMappingByClientScope").setParameter("clientScopeId", (Object)clientScope.getId()).executeUpdate();
        this.em.createNamedQuery("deleteClientScopeRoleMappingByClientScope").setParameter("clientScope", (Object)clientScopeEntity).executeUpdate();
        this.em.remove((Object)clientScopeEntity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new ClientScopeModel.ClientScopeRemovedEvent(){

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }

            public ClientScopeModel getClientScope() {
                return clientScope;
            }
        });
        this.em.flush();
        return true;
    }

    public void removeClientScopes(RealmModel realm) {
        realm.getClientScopesStream().map(ClientScopeModel::getId).forEach(id -> this.removeClientScope(realm, (String)id));
    }

    public void addClientScopes(RealmModel realm, ClientModel client, Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        String clientProtocol = client.getProtocol() == null ? "openid-connect" : client.getProtocol();
        Map<String, ClientScopeModel> existingClientScopes = this.getClientScopes(realm, client, true);
        existingClientScopes.putAll(this.getClientScopes(realm, client, false));
        clientScopes.stream().filter(clientScope -> !existingClientScopes.containsKey(clientScope.getName())).filter(clientScope -> Objects.equals(clientScope.getProtocol(), clientProtocol)).forEach(clientScope -> {
            ClientScopeClientMappingEntity entity = new ClientScopeClientMappingEntity();
            entity.setClientScopeId(clientScope.getId());
            entity.setClientId(client.getId());
            entity.setDefaultScope(defaultScope);
            this.em.persist((Object)entity);
            this.em.flush();
            this.em.detach((Object)entity);
        });
    }

    public void removeClientScope(RealmModel realm, ClientModel client, ClientScopeModel clientScope) {
        this.em.createNamedQuery("deleteClientScopeClientMapping").setParameter("clientScopeId", (Object)clientScope.getId()).setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.flush();
    }

    public Map<String, ClientScopeModel> getClientScopes(RealmModel realm, ClientModel client, boolean defaultScope) {
        String clientProtocol = client.getProtocol() == null ? "openid-connect" : client.getProtocol();
        TypedQuery query = this.em.createNamedQuery("clientScopeClientMappingIdsByClient", String.class);
        query.setParameter("clientId", (Object)client.getId());
        query.setParameter("defaultScope", (Object)defaultScope);
        return StreamsUtil.closing((Stream)query.getResultStream()).map(clientScopeId -> this.session.clientScopes().getClientScopeById(realm, clientScopeId)).filter(Objects::nonNull).filter(clientScope -> Objects.equals(clientScope.getProtocol(), clientProtocol)).collect(Collectors.toMap(ClientScopeModel::getName, Function.identity()));
    }

    public Stream<GroupModel> searchForGroupByNameStream(RealmModel realm, String search, Boolean exact, Integer first, Integer max) {
        TypedQuery query = Boolean.TRUE.equals(exact) ? this.em.createNamedQuery("getGroupIdsByName", String.class) : this.em.createNamedQuery("getGroupIdsByNameContaining", String.class);
        query.setParameter("realm", (Object)realm.getId()).setParameter("search", (Object)search);
        Stream groups = PaginationUtils.paginateQuery(query, first, max).getResultStream();
        return StreamsUtil.closing(groups.map(id -> {
            GroupModel groupById = this.session.groups().getGroupById(realm, id);
            while (Objects.nonNull(groupById.getParentId())) {
                groupById = this.session.groups().getGroupById(realm, groupById.getParentId());
            }
            return groupById;
        }).sorted(GroupModel.COMPARE_BY_NAME).distinct());
    }

    public Stream<GroupModel> searchGroupsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        Map<String, String> filteredAttributes = this.groupSearchableAttributes == null || this.groupSearchableAttributes.isEmpty() ? attributes : attributes.entrySet().stream().filter(m -> this.groupSearchableAttributes.contains(m.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(GroupEntity.class);
        Root root = queryBuilder.from(GroupEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)realm.getId()));
        for (Map.Entry<String, String> entry : filteredAttributes.entrySet()) {
            String key = entry.getKey();
            if (key == null || key.isEmpty()) continue;
            String value = entry.getValue();
            Join attributeJoin = root.join("attributes");
            Predicate attrNamePredicate = builder.equal((Expression)attributeJoin.get("name"), (Object)key);
            Predicate attrValuePredicate = builder.equal((Expression)attributeJoin.get("value"), (Object)value);
            predicates.add(builder.and((Expression)attrNamePredicate, (Expression)attrValuePredicate));
        }
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        queryBuilder.where((Expression)finalPredicate).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.em.createQuery(queryBuilder);
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultStream()).map(g -> this.session.groups().getGroupById(realm, g.getId()));
    }

    public void removeExpiredClientInitialAccess() {
        int currentTime = Time.currentTime();
        this.em.createNamedQuery("removeExpiredClientInitialAccess").setParameter("currentTime", (Object)currentTime).executeUpdate();
    }

    private RealmLocalizationTextsEntity getRealmLocalizationTextsEntity(String locale, String realmId) {
        RealmLocalizationTextsEntity.RealmLocalizationTextEntityKey key = new RealmLocalizationTextsEntity.RealmLocalizationTextEntityKey();
        key.setRealmId(realmId);
        key.setLocale(locale);
        return (RealmLocalizationTextsEntity)this.em.find(RealmLocalizationTextsEntity.class, (Object)key);
    }

    public boolean updateLocalizationText(RealmModel realm, String locale, String key, String text) {
        RealmLocalizationTextsEntity entity = this.getRealmLocalizationTextsEntity(locale, realm.getId());
        if (entity != null && entity.getTexts() != null && entity.getTexts().containsKey(key)) {
            entity.getTexts().put(key, text);
            this.em.persist((Object)entity);
            return true;
        }
        return false;
    }

    public void saveLocalizationText(RealmModel realm, String locale, String key, String text) {
        RealmLocalizationTextsEntity entity = this.getRealmLocalizationTextsEntity(locale, realm.getId());
        if (entity == null) {
            entity = new RealmLocalizationTextsEntity();
            entity.setRealmId(realm.getId());
            entity.setLocale(locale);
            entity.setTexts(new HashMap<String, String>());
        }
        entity.getTexts().put(key, text);
        this.em.persist((Object)entity);
    }

    public void saveLocalizationTexts(RealmModel realm, String locale, Map<String, String> localizationTexts) {
        RealmLocalizationTextsEntity entity = new RealmLocalizationTextsEntity();
        entity.setTexts(localizationTexts);
        entity.setLocale(locale);
        entity.setRealmId(realm.getId());
        this.em.merge((Object)entity);
    }

    public boolean deleteLocalizationTextsByLocale(RealmModel realm, String locale) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaDelete criteriaDelete = builder.createCriteriaDelete(RealmLocalizationTextsEntity.class);
        Root root = criteriaDelete.from(RealmLocalizationTextsEntity.class);
        criteriaDelete.where((Expression)builder.and((Expression)builder.equal((Expression)root.get("realmId"), (Object)realm.getId()), (Expression)builder.equal((Expression)root.get("locale"), (Object)locale)));
        int linesUpdated = this.em.createQuery(criteriaDelete).executeUpdate();
        return linesUpdated == 1;
    }

    public String getLocalizationTextsById(RealmModel realm, String locale, String key) {
        RealmLocalizationTextsEntity entity = this.getRealmLocalizationTextsEntity(locale, realm.getId());
        if (entity != null && entity.getTexts() != null && entity.getTexts().containsKey(key)) {
            return entity.getTexts().get(key);
        }
        return null;
    }

    public boolean deleteLocalizationText(RealmModel realm, String locale, String key) {
        RealmLocalizationTextsEntity entity = this.getRealmLocalizationTextsEntity(locale, realm.getId());
        if (entity != null && entity.getTexts() != null && entity.getTexts().containsKey(key)) {
            entity.getTexts().remove(key);
            this.em.persist((Object)entity);
            return true;
        }
        return false;
    }

    public Set<String> getClientSearchableAttributes() {
        return this.clientSearchableAttributes;
    }
}

