/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.authorization;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.hotRod.authorization.HotRodResourceEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntityNonIndexed;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;

public class HotRodResourceEntityDelegate
extends HotRodResourceEntity.AbstractHotRodResourceEntity
implements MapResourceEntity {
    private final HotRodResourceEntity hotRodEntity;
    private final DeepCloner cloner;

    public HotRodResourceEntityDelegate() {
        this.cloner = DeepCloner.DUMB_CLONER;
        this.hotRodEntity = new HotRodResourceEntity();
    }

    public HotRodResourceEntityDelegate(HotRodResourceEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public HotRodResourceEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodResourceEntity();
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodResourceEntityDelegate)) {
            return false;
        }
        HotRodResourceEntityDelegate other = (HotRodResourceEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getDisplayName(), other.getDisplayName()) && Objects.equals(this.getIconUri(), other.getIconUri()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getOwner(), other.getOwner()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getResourceServerId(), other.getResourceServerId()) && Objects.equals(this.getScopeIds(), other.getScopeIds()) && Objects.equals(this.getType(), other.getType()) && Objects.equals(this.getUris(), other.getUris()) && Objects.equals(this.isOwnerManagedAccess(), other.isOwnerManagedAccess());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodResourceEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodResourceEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodResourceEntity e1 = (HotRodResourceEntity)o1;
        HotRodResourceEntity e2 = (HotRodResourceEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.realmId, e2.realmId) && Objects.equals(e1.name, e2.name) && Objects.equals(e1.nameLowercase, e2.nameLowercase) && Objects.equals(e1.displayName, e2.displayName) && Objects.equals(e1.uris, e2.uris) && Objects.equals(e1.type, e2.type) && Objects.equals(e1.iconUri, e2.iconUri) && Objects.equals(e1.owner, e2.owner) && Objects.equals(e1.ownerManagedAccess, e2.ownerManagedAccess) && Objects.equals(e1.resourceServerId, e2.resourceServerId) && Objects.equals(e1.scopeIds, e2.scopeIds) && Objects.equals(e1.attributes, e2.attributes);
    }

    public static int entityHashCode(HotRodResourceEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public <V> V deepClone(V obj) {
        return (V)this.cloner.from(obj);
    }

    public void removeAttribute(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public void setAttribute(String p0, List<String> p1) {
        LinkedList<String> linkedList = p1 = p1 == null ? null : new LinkedList<String>(p1);
        if (p1 != null) {
            p1.removeIf(UndefinedValuesUtils::isUndefined);
        }
        boolean valueUndefined = UndefinedValuesUtils.isUndefined(p1);
        if (this.hotRodEntity.attributes == null && !valueUndefined) {
            this.hotRodEntity.attributes = new HashSet<HotRodAttributeEntityNonIndexed>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.attributes.add(new HotRodAttributeEntityNonIndexed(p0, p1)));
    }

    public Map<String, List<String>> getAttributes() {
        return this.hotRodEntity.attributes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.attributes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setAttributes(Map<String, List<String>> p0) {
        Map<String, List<String>> map = p0 = p0 == null ? null : (Map<String, List<String>>)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodAttributeEntityNonIndexed> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodAttributeEntityNonIndexedFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.attributes, migrated);
        this.hotRodEntity.attributes = migrated;
    }

    public List<String> getAttribute(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setDisplayName(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.displayName, migrated);
        this.hotRodEntity.displayName = migrated;
    }

    public String getDisplayName() {
        return this.hotRodEntity.displayName == null ? null : this.hotRodEntity.displayName;
    }

    public String getIconUri() {
        return this.hotRodEntity.iconUri == null ? null : this.hotRodEntity.iconUri;
    }

    public void setIconUri(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.iconUri, migrated);
        this.hotRodEntity.iconUri = migrated;
    }

    public String getName() {
        return this.hotRodEntity.name == null ? null : this.hotRodEntity.name;
    }

    public void setOwner(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.owner, migrated);
        this.hotRodEntity.owner = migrated;
    }

    public String getOwner() {
        return this.hotRodEntity.owner == null ? null : this.hotRodEntity.owner;
    }

    public void setOwnerManagedAccess(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.ownerManagedAccess, migrated);
        this.hotRodEntity.ownerManagedAccess = migrated;
    }

    public Boolean isOwnerManagedAccess() {
        return this.hotRodEntity.ownerManagedAccess == null ? null : this.hotRodEntity.ownerManagedAccess;
    }

    public void setRealmId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.realmId, migrated);
        this.hotRodEntity.realmId = migrated;
    }

    public String getRealmId() {
        return this.hotRodEntity.realmId == null ? null : this.hotRodEntity.realmId;
    }

    public String getResourceServerId() {
        return this.hotRodEntity.resourceServerId == null ? null : this.hotRodEntity.resourceServerId;
    }

    public void setResourceServerId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.resourceServerId, migrated);
        this.hotRodEntity.resourceServerId = migrated;
    }

    public void setScopeIds(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.scopeIds, migrated);
        this.hotRodEntity.scopeIds = migrated;
    }

    public Set<String> getScopeIds() {
        return this.hotRodEntity.scopeIds == null ? null : this.hotRodEntity.scopeIds;
    }

    public String getType() {
        return this.hotRodEntity.type == null ? null : this.hotRodEntity.type;
    }

    public void setType(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.type, migrated);
        this.hotRodEntity.type = migrated;
    }

    public Set<String> getUris() {
        return this.hotRodEntity.uris == null ? null : this.hotRodEntity.uris;
    }

    public void setUris(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.uris, migrated);
        this.hotRodEntity.uris = migrated;
    }

    @Override
    public HotRodResourceEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

