/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.Collections;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PermissionService;
import org.keycloak.authorization.admin.PolicyService;
import org.keycloak.authorization.admin.ResourceSetService;
import org.keycloak.authorization.admin.ScopeService;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ResourceServerService {
    private final AuthorizationProvider authorization;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    private final KeycloakSession session;
    private ResourceServer resourceServer;
    private final ClientModel client;

    public ResourceServerService(AuthorizationProvider authorization, ResourceServer resourceServer, ClientModel client, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.authorization = authorization;
        this.session = authorization.getKeycloakSession();
        this.client = client;
        this.resourceServer = resourceServer;
        this.auth = auth;
        this.adminEvent = adminEvent;
    }

    public ResourceServer create(boolean newClient) {
        this.auth.realm().requireManageAuthorization();
        UserModel serviceAccount = this.session.users().getServiceAccount(this.client);
        if (serviceAccount == null) {
            throw new RuntimeException("Client does not have a service account.");
        }
        if (this.resourceServer == null) {
            this.resourceServer = RepresentationToModel.createResourceServer((ClientModel)this.client, (KeycloakSession)this.session, (boolean)true);
            this.createDefaultPermission(this.createDefaultResource(), this.createDefaultPolicy());
            this.audit(ModelToRepresentation.toRepresentation((ResourceServer)this.resourceServer, (ClientModel)this.client), OperationType.CREATE, (UriInfo)this.session.getContext().getUri(), newClient);
        }
        return this.resourceServer;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(ResourceServerRepresentation server) {
        this.auth.realm().requireManageAuthorization();
        this.resourceServer.setAllowRemoteResourceManagement(server.isAllowRemoteResourceManagement());
        this.resourceServer.setPolicyEnforcementMode(server.getPolicyEnforcementMode());
        this.resourceServer.setDecisionStrategy(server.getDecisionStrategy());
        this.audit(ModelToRepresentation.toRepresentation((ResourceServer)this.resourceServer, (ClientModel)this.client), OperationType.UPDATE, (UriInfo)this.session.getContext().getUri(), false);
        return Response.noContent().build();
    }

    public void delete() {
        this.auth.realm().requireManageAuthorization();
        ResourceServerRepresentation rep = ModelToRepresentation.toRepresentation((ResourceServer)this.resourceServer, (ClientModel)this.client);
        this.authorization.getStoreFactory().getResourceServerStore().delete(this.client);
        this.audit(rep, OperationType.DELETE, (UriInfo)this.session.getContext().getUri(), false);
    }

    @GET
    @Produces(value={"application/json"})
    public Response findById() {
        this.auth.realm().requireViewAuthorization();
        return Response.ok((Object)ModelToRepresentation.toRepresentation((ResourceServer)this.resourceServer, (ClientModel)this.client)).build();
    }

    @Path(value="/settings")
    @GET
    @Produces(value={"application/json"})
    public Response exportSettings() {
        this.auth.realm().requireManageAuthorization();
        return Response.ok((Object)ModelToRepresentation.toResourceServerRepresentation((KeycloakSession)this.session, (ClientModel)this.client)).build();
    }

    @Path(value="/import")
    @POST
    @Consumes(value={"application/json"})
    public Response importSettings(ResourceServerRepresentation rep) {
        this.auth.realm().requireManageAuthorization();
        rep.setClientId(this.client.getId());
        this.resourceServer = RepresentationToModel.toModel((ResourceServerRepresentation)rep, (AuthorizationProvider)this.authorization, (ClientModel)this.client);
        this.audit(ModelToRepresentation.toRepresentation((ResourceServer)this.resourceServer, (ClientModel)this.client), OperationType.UPDATE, (UriInfo)this.session.getContext().getUri(), false);
        return Response.noContent().build();
    }

    @Path(value="/resource")
    public ResourceSetService getResourceSetResource() {
        ResourceSetService resource = new ResourceSetService(this.session, this.resourceServer, this.authorization, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="/scope")
    public ScopeService getScopeResource() {
        ScopeService resource = new ScopeService(this.session, this.resourceServer, this.authorization, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="/policy")
    public PolicyService getPolicyResource() {
        PolicyService resource = new PolicyService(this.resourceServer, this.authorization, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="/permission")
    public Object getPermissionTypeResource() {
        this.auth.realm().requireViewAuthorization();
        PermissionService resource = new PermissionService(this.resourceServer, this.authorization, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    private void createDefaultPermission(ResourceRepresentation resource, PolicyRepresentation policy) {
        ResourcePermissionRepresentation defaultPermission = new ResourcePermissionRepresentation();
        defaultPermission.setName("Default Permission");
        defaultPermission.setDescription("A permission that applies to the default resource type");
        defaultPermission.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        defaultPermission.setLogic(Logic.POSITIVE);
        defaultPermission.setResourceType(resource.getType());
        defaultPermission.addPolicy(new String[]{policy.getName()});
        this.getPolicyResource().create((AbstractPolicyRepresentation)defaultPermission);
    }

    private PolicyRepresentation createDefaultPolicy() {
        PolicyRepresentation defaultPolicy = new PolicyRepresentation();
        defaultPolicy.setName("Default Policy");
        defaultPolicy.setDescription("A policy that grants access only for users within this realm");
        defaultPolicy.setType("js");
        defaultPolicy.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        defaultPolicy.setLogic(Logic.POSITIVE);
        HashMap<String, String> defaultPolicyConfig = new HashMap<String, String>();
        defaultPolicyConfig.put("code", "// by default, grants any permission associated with this policy\n$evaluation.grant();\n");
        defaultPolicy.setConfig(defaultPolicyConfig);
        this.session.setAttribute("ALLOW_CREATE_POLICY", (Object)true);
        this.getPolicyResource().create((AbstractPolicyRepresentation)defaultPolicy);
        return defaultPolicy;
    }

    private ResourceRepresentation createDefaultResource() {
        ResourceRepresentation defaultResource = new ResourceRepresentation();
        defaultResource.setName("Default Resource");
        defaultResource.setUris(Collections.singleton("/*"));
        defaultResource.setType("urn:" + this.client.getClientId() + ":resources:default");
        this.getResourceSetResource().create(defaultResource);
        return defaultResource;
    }

    private void audit(ResourceServerRepresentation rep, OperationType operation, UriInfo uriInfo, boolean newClient) {
        if (newClient) {
            this.adminEvent.resource(ResourceType.AUTHORIZATION_RESOURCE_SERVER).operation(operation).resourcePath(uriInfo, this.client.getId()).representation(rep).success();
        } else {
            this.adminEvent.resource(ResourceType.AUTHORIZATION_RESOURCE_SERVER).operation(operation).resourcePath(uriInfo).representation(rep).success();
        }
    }
}

