/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.component.SubComponentFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ComponentTypeRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.utils.LockObjectsForModification;

public class ComponentResource {
    protected static final Logger logger = Logger.getLogger(ComponentResource.class);
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public ComponentResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent.resource(ResourceType.COMPONENT);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<ComponentRepresentation> getComponents(@QueryParam(value="parent") String parent, @QueryParam(value="type") String type, @QueryParam(value="name") String name) {
        this.auth.realm().requireViewRealm();
        Stream components = parent == null && type == null ? this.realm.getComponentsStream() : (type == null ? this.realm.getComponentsStream(parent) : (parent == null ? this.realm.getComponentsStream(this.realm.getId(), type) : this.realm.getComponentsStream(parent, type)));
        return components.filter(component -> Objects.isNull(name) || Objects.equals(component.getName(), name)).map(component -> {
            try {
                return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (ComponentModel)component, (boolean)false);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get component list for component model" + component.getName() + "of realm " + this.realm.getName()));
                return ModelToRepresentation.toRepresentationWithoutConfig((ComponentModel)component);
            }
        });
    }

    @POST
    @Consumes(value={"application/json"})
    public Response create(ComponentRepresentation rep) {
        this.auth.realm().requireManageRealm();
        return (Response)KeycloakModelUtils.runJobInRetriableTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), kcSession -> {
            RealmModel realmModel = (RealmModel)LockObjectsForModification.lockRealmsForModification((KeycloakSession)kcSession, () -> kcSession.realms().getRealm(this.realm.getId()));
            try {
                ComponentModel model = RepresentationToModel.toModel((KeycloakSession)kcSession, (ComponentRepresentation)rep);
                if (model.getParentId() == null) {
                    model.setParentId(realmModel.getId());
                }
                model = realmModel.addComponentModel(model);
                this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)kcSession.getContext().getUri(), model.getId()).representation(StripSecretsUtils.strip((KeycloakSession)kcSession, (ComponentRepresentation)rep)).success();
                return Response.created((URI)kcSession.getContext().getUri().getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
            }
            catch (ComponentValidationException e) {
                return this.localizedErrorResponse(e);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException((Throwable)e);
            }
        }, (int)10, (int)100);
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @NoCache
    public ComponentRepresentation getComponent(@PathParam(value="id") String id) {
        this.auth.realm().requireViewRealm();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        ComponentRepresentation rep = ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (ComponentModel)model, (boolean)false);
        return rep;
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public Response updateComponent(@PathParam(value="id") String id, ComponentRepresentation rep) {
        this.auth.realm().requireManageRealm();
        return (Response)KeycloakModelUtils.runJobInRetriableTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), kcSession -> {
            RealmModel realmModel = (RealmModel)LockObjectsForModification.lockRealmsForModification((KeycloakSession)kcSession, () -> kcSession.realms().getRealm(this.realm.getId()));
            try {
                ComponentModel model = realmModel.getComponent(id);
                if (model == null) {
                    throw new NotFoundException("Could not find component");
                }
                RepresentationToModel.updateComponent((KeycloakSession)kcSession, (ComponentRepresentation)rep, (ComponentModel)model, (boolean)false);
                this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)kcSession.getContext().getUri()).representation(StripSecretsUtils.strip((KeycloakSession)kcSession, (ComponentRepresentation)rep)).success();
                realmModel.updateComponent(model);
                return Response.noContent().build();
            }
            catch (ComponentValidationException e) {
                return this.localizedErrorResponse(e);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException();
            }
        }, (int)10, (int)100);
    }

    @DELETE
    @Path(value="{id}")
    public void removeComponent(@PathParam(value="id") String id) {
        this.auth.realm().requireManageRealm();
        KeycloakModelUtils.runJobInRetriableTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), kcSession -> {
            RealmModel realmModel = (RealmModel)LockObjectsForModification.lockRealmsForModification((KeycloakSession)kcSession, () -> kcSession.realms().getRealm(this.realm.getId()));
            ComponentModel model = realmModel.getComponent(id);
            if (model == null) {
                throw new NotFoundException("Could not find component");
            }
            this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)kcSession.getContext().getUri()).success();
            realmModel.removeComponent(model);
            return null;
        }, (int)10, (int)100);
    }

    private Response localizedErrorResponse(ComponentValidationException cve) {
        Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale(), "admin-messages", "messages");
        Object[] localizedParameters = cve.getParameters() == null ? null : Arrays.asList(cve.getParameters()).stream().map(parameter -> {
            if (parameter instanceof String) {
                String paramStr = (String)parameter;
                return messages.getProperty(paramStr, paramStr);
            }
            return parameter;
        }).toArray();
        String message = MessageFormat.format(messages.getProperty(cve.getMessage(), cve.getMessage()), localizedParameters);
        return ErrorResponse.error(message, Response.Status.BAD_REQUEST);
    }

    @GET
    @Path(value="{id}/sub-component-types")
    @Produces(value={"application/json"})
    @NoCache
    public Stream<ComponentTypeRepresentation> getSubcomponentConfig(@PathParam(value="id") String parentId, @QueryParam(value="type") String subtype) {
        Class<?> providerClass;
        this.auth.realm().requireViewRealm();
        ComponentModel parent = this.realm.getComponent(parentId);
        if (parent == null) {
            throw new NotFoundException("Could not find parent component");
        }
        if (subtype == null) {
            throw new BadRequestException("must specify a subtype");
        }
        try {
            providerClass = Class.forName(subtype);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(providerClass).filter(ComponentFactory.class::isInstance).map(factory -> this.toComponentTypeRepresentation((ProviderFactory)factory, parent));
    }

    private ComponentTypeRepresentation toComponentTypeRepresentation(ProviderFactory factory, ComponentModel parent) {
        Map metadata;
        List props;
        ComponentTypeRepresentation rep = new ComponentTypeRepresentation();
        rep.setId(factory.getId());
        ComponentFactory componentFactory = (ComponentFactory)factory;
        rep.setHelpText(componentFactory.getHelpText());
        if (factory instanceof SubComponentFactory) {
            props = ((SubComponentFactory)factory).getConfigProperties(this.realm, parent);
            metadata = ((SubComponentFactory)factory).getTypeMetadata(this.realm, parent);
        } else {
            props = componentFactory.getConfigProperties();
            metadata = componentFactory.getTypeMetadata();
        }
        List propReps = ModelToRepresentation.toRepresentation((List)props);
        rep.setProperties(propReps);
        rep.setMetadata(metadata);
        return rep;
    }
}

