/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.GroupResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.utils.SearchQueryUtils;

public class GroupsResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;

    public GroupsResource(RealmModel realm, KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.GROUP);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<GroupRepresentation> getGroups(@QueryParam(value="search") String search, @QueryParam(value="q") String searchQuery, @QueryParam(value="exact") @DefaultValue(value="false") Boolean exact, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.auth.groups().requireList();
        if (Objects.nonNull(searchQuery)) {
            Map<String, String> attributes = SearchQueryUtils.getFields(searchQuery);
            return ModelToRepresentation.searchGroupsByAttributes((KeycloakSession)this.session, (RealmModel)this.realm, (!briefRepresentation ? 1 : 0) != 0, attributes, (Integer)firstResult, (Integer)maxResults);
        }
        if (Objects.nonNull(search)) {
            return ModelToRepresentation.searchForGroupByName((KeycloakSession)this.session, (RealmModel)this.realm, (!briefRepresentation ? 1 : 0) != 0, (String)search.trim(), (Boolean)exact, (Integer)firstResult, (Integer)maxResults);
        }
        if (Objects.nonNull(firstResult) && Objects.nonNull(maxResults)) {
            return ModelToRepresentation.toGroupHierarchy((RealmModel)this.realm, (!briefRepresentation ? 1 : 0) != 0, (Integer)firstResult, (Integer)maxResults);
        }
        return ModelToRepresentation.toGroupHierarchy((RealmModel)this.realm, (!briefRepresentation ? 1 : 0) != 0);
    }

    @Path(value="{id}")
    public GroupResource getGroupById(@PathParam(value="id") String id) {
        GroupModel group = this.realm.getGroupById(id);
        if (group == null) {
            throw new NotFoundException("Could not find group by id");
        }
        GroupResource resource = new GroupResource(this.realm, group, this.session, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @GET
    @NoCache
    @Path(value="count")
    @Produces(value={"application/json"})
    public Map<String, Long> getGroupCount(@QueryParam(value="search") String search, @QueryParam(value="top") @DefaultValue(value="false") boolean onlyTopGroups) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        Long results = Objects.nonNull(search) ? this.realm.getGroupsCountByNameContaining(search) : this.realm.getGroupsCount(Boolean.valueOf(onlyTopGroups));
        map.put("count", results);
        return map;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addTopLevelGroup(GroupRepresentation rep) {
        this.auth.groups().requireManage();
        Response.ResponseBuilder builder = Response.status((int)204);
        String groupName = rep.getName();
        if (ObjectUtil.isBlank((CharSequence)groupName)) {
            return ErrorResponse.error("Group name is missing", Response.Status.BAD_REQUEST);
        }
        try {
            if (rep.getId() != null) {
                GroupModel child = this.realm.getGroupById(rep.getId());
                if (child == null) {
                    throw new NotFoundException("Could not find child by id");
                }
                this.realm.moveGroup(child, null);
                this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri());
            } else {
                GroupModel child = this.realm.createGroup(groupName);
                GroupResource.updateGroup(rep, child, this.realm, this.session);
                URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(child.getId()).build(new Object[0]);
                builder.status(201).location(uri);
                rep.setId(child.getId());
                this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), child.getId());
            }
        }
        catch (ModelDuplicateException mde) {
            return ErrorResponse.exists("Top level group named '" + groupName + "' already exists.");
        }
        this.adminEvent.representation(rep).success();
        return builder.build();
    }
}

