/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.x509.AbstractClientCertificateFromHttpHeadersLookupFactory;
import org.keycloak.services.x509.NginxProxySslClientCertificateLookup;
import org.keycloak.services.x509.NginxProxyTrustedClientCertificateLookup;
import org.keycloak.services.x509.X509ClientCertificateLookup;

public class NginxProxySslClientCertificateLookupFactory
extends AbstractClientCertificateFromHttpHeadersLookupFactory {
    private static final Logger logger = Logger.getLogger(NginxProxySslClientCertificateLookupFactory.class);
    private static final String PROVIDER = "nginx";
    protected static final String TRUST_PROXY_VERIFICATION = "trust-proxy-verification";
    protected boolean trustProxyVerification = false;

    @Override
    public void init(Config.Scope config) {
        super.init(config);
        this.trustProxyVerification = config.getBoolean(TRUST_PROXY_VERIFICATION, Boolean.valueOf(false));
        logger.tracev("{0}: ''{1}''", (Object)TRUST_PROXY_VERIFICATION, (Object)this.trustProxyVerification);
    }

    public X509ClientCertificateLookup create(KeycloakSession session) {
        if (this.trustProxyVerification) {
            return new NginxProxyTrustedClientCertificateLookup(this.sslClientCertHttpHeader, this.sslChainHttpHeaderPrefix, this.certificateChainLength);
        }
        return new NginxProxySslClientCertificateLookup(this.sslClientCertHttpHeader, this.sslChainHttpHeaderPrefix, this.certificateChainLength, session);
    }

    public String getId() {
        return PROVIDER;
    }
}

