/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.federation.sssd.SSSDFederationProvider;
import org.keycloak.federation.sssd.api.Sssd;
import org.keycloak.federation.sssd.impl.PAMAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;

public class SSSDFederationProviderFactory
implements UserStorageProviderFactory<SSSDFederationProvider>,
EnvironmentDependentProviderFactory {
    private static final String PROVIDER_NAME = "sssd";
    private static final Logger logger = Logger.getLogger(SSSDFederationProvider.class);

    public String getId() {
        return PROVIDER_NAME;
    }

    public SSSDFederationProvider create(KeycloakSession session, ComponentModel model) {
        return new SSSDFederationProvider(session, new UserStorageProviderModel(model), this);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    protected PAMAuthenticator createPAMAuthenticator(String username, String ... factors) {
        return new PAMAuthenticator(username, factors);
    }

    public boolean isSupported() {
        return Sssd.isAvailable();
    }
}

