/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClearRealmCacheResource {
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;

    public ClearRealmCacheResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
    }

    @POST
    public void clearRealmCache() {
        this.auth.realm().requireManageRealm();
        CacheRealmProvider cache = (CacheRealmProvider)this.session.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            cache.clear();
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }
}

