/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.multicast.MultiPublishOp;
import java.time.Duration;

public class MultiBroadcaster {
    public static <T> Multi<T> publish(Multi<T> upstream, int numberOfSubscribers, boolean cancelWhenNoOneIsListening, Duration delayAfterLastDeparture) {
        if (numberOfSubscribers > 0) {
            return MultiBroadcaster.createPublishWithSubscribersThreshold(upstream, numberOfSubscribers, cancelWhenNoOneIsListening, delayAfterLastDeparture);
        }
        return MultiBroadcaster.createPublishImmediate(upstream, cancelWhenNoOneIsListening, delayAfterLastDeparture);
    }

    private static <T> Multi<T> createPublishImmediate(Multi<T> upstream, boolean cancelWhenNoOneIsListening, Duration delayAfterLastDeparture) {
        if (cancelWhenNoOneIsListening) {
            if (delayAfterLastDeparture != null) {
                return Infrastructure.onMultiCreation(MultiPublishOp.create(upstream).referenceCount(1, delayAfterLastDeparture));
            }
            return Infrastructure.onMultiCreation(MultiPublishOp.create(upstream).referenceCount());
        }
        return Infrastructure.onMultiCreation(MultiPublishOp.create(upstream).connectAfter(1));
    }

    private static <T> Multi<T> createPublishWithSubscribersThreshold(Multi<T> upstream, int numberOfSubscribers, boolean cancelWhenNoOneIsListening, Duration delayAfterLastDeparture) {
        if (cancelWhenNoOneIsListening) {
            if (delayAfterLastDeparture != null) {
                return Infrastructure.onMultiCreation(MultiPublishOp.create(upstream).referenceCount(numberOfSubscribers, delayAfterLastDeparture));
            }
            return Infrastructure.onMultiCreation(MultiPublishOp.create(upstream).referenceCount(numberOfSubscribers, null));
        }
        return Infrastructure.onMultiCreation(MultiPublishOp.create(upstream).connectAfter(numberOfSubscribers));
    }

    private MultiBroadcaster() {
    }
}

