/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageList;
import twitter4j.DirectMessageListImpl;
import twitter4j.EntitiesParseUtil;
import twitter4j.HTMLEntity;
import twitter4j.HashtagEntity;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.MediaEntity;
import twitter4j.MediaEntityJSONImpl;
import twitter4j.ParseUtil;
import twitter4j.SymbolEntity;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponseImpl;
import twitter4j.URLEntity;
import twitter4j.User;
import twitter4j.UserMentionEntity;
import twitter4j.conf.Configuration;

final class DirectMessageJSONImpl
extends TwitterResponseImpl
implements DirectMessage,
Serializable {
    private static final long serialVersionUID = 7092906238192790921L;
    private long id;
    private String text;
    private long senderId;
    private long recipientId;
    private Date createdAt;
    private UserMentionEntity[] userMentionEntities;
    private URLEntity[] urlEntities;
    private HashtagEntity[] hashtagEntities;
    private MediaEntity[] mediaEntities;
    private SymbolEntity[] symbolEntities;

    DirectMessageJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            JSONObject event = json.getJSONObject("event");
            this.init(event);
            if (conf.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
                TwitterObjectFactory.registerJSONObject(this, event);
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    DirectMessageJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            JSONObject attachment;
            JSONObject messageData;
            this.id = ParseUtil.getLong("id", json);
            if (!json.isNull("created_timestamp")) {
                this.createdAt = new Date(json.getLong("created_timestamp"));
                JSONObject messageCreate = json.getJSONObject("message_create");
                this.recipientId = ParseUtil.getLong("recipient_id", messageCreate.getJSONObject("target"));
                this.senderId = ParseUtil.getLong("sender_id", messageCreate);
                messageData = messageCreate.getJSONObject("message_data");
            } else {
                this.createdAt = ParseUtil.getDate("created_at", json);
                this.senderId = ParseUtil.getLong("sender_id", json);
                this.recipientId = ParseUtil.getLong("recipient_id", json);
                messageData = json;
            }
            if (!messageData.isNull("entities")) {
                JSONObject entities = messageData.getJSONObject("entities");
                this.userMentionEntities = EntitiesParseUtil.getUserMentions(entities);
                this.urlEntities = EntitiesParseUtil.getUrls(entities);
                this.hashtagEntities = EntitiesParseUtil.getHashtags(entities);
                this.symbolEntities = EntitiesParseUtil.getSymbols(entities);
            }
            this.userMentionEntities = this.userMentionEntities == null ? new UserMentionEntity[]{} : this.userMentionEntities;
            this.urlEntities = this.urlEntities == null ? new URLEntity[]{} : this.urlEntities;
            this.hashtagEntities = this.hashtagEntities == null ? new HashtagEntity[]{} : this.hashtagEntities;
            SymbolEntity[] symbolEntityArray = this.symbolEntities = this.symbolEntities == null ? new SymbolEntity[]{} : this.symbolEntities;
            if (!messageData.isNull("attachment") && !(attachment = messageData.getJSONObject("attachment")).isNull("media")) {
                this.mediaEntities = new MediaEntity[1];
                this.mediaEntities[0] = new MediaEntityJSONImpl(attachment.getJSONObject("media"));
            }
            this.mediaEntities = this.mediaEntities == null ? new MediaEntity[]{} : this.mediaEntities;
            this.text = HTMLEntity.unescapeAndSlideEntityIncdices(messageData.getString("text"), this.userMentionEntities, this.urlEntities, this.hashtagEntities, this.mediaEntities);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    static DirectMessageList createDirectMessageList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            DirectMessageListImpl directMessages;
            JSONArray list;
            if (conf.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            try {
                JSONObject jsonObject = res.asJSONObject();
                list = jsonObject.getJSONArray("events");
                directMessages = new DirectMessageListImpl(list.length(), jsonObject, res);
            }
            catch (TwitterException te) {
                if (te.getCause() != null && te.getCause() instanceof JSONException) {
                    list = res.asJSONArray();
                    int size = list.length();
                    directMessages = new DirectMessageListImpl(size, res);
                }
                throw te;
            }
            for (int i = 0; i < list.length(); ++i) {
                JSONObject json = list.getJSONObject(i);
                DirectMessageJSONImpl directMessage = new DirectMessageJSONImpl(json);
                directMessages.add(directMessage);
                if (!conf.isJSONStoreEnabled()) continue;
                TwitterObjectFactory.registerJSONObject(directMessage, json);
            }
            if (conf.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(directMessages, list);
            }
            return directMessages;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getRecipientId() {
        return this.recipientId;
    }

    @Override
    public long getSenderId() {
        return this.senderId;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public UserMentionEntity[] getUserMentionEntities() {
        return this.userMentionEntities;
    }

    @Override
    public URLEntity[] getURLEntities() {
        return this.urlEntities;
    }

    @Override
    public HashtagEntity[] getHashtagEntities() {
        return this.hashtagEntities;
    }

    @Override
    public MediaEntity[] getMediaEntities() {
        return this.mediaEntities;
    }

    @Override
    public SymbolEntity[] getSymbolEntities() {
        return this.symbolEntities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectMessageJSONImpl that = (DirectMessageJSONImpl)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.senderId != that.senderId) {
            return false;
        }
        if (this.recipientId != that.recipientId) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (!Arrays.equals(this.userMentionEntities, that.userMentionEntities)) {
            return false;
        }
        if (!Arrays.equals(this.urlEntities, that.urlEntities)) {
            return false;
        }
        if (!Arrays.equals(this.hashtagEntities, that.hashtagEntities)) {
            return false;
        }
        if (!Arrays.equals(this.mediaEntities, that.mediaEntities)) {
            return false;
        }
        return Arrays.equals(this.symbolEntities, that.symbolEntities);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (int)(this.senderId ^ this.senderId >>> 32);
        result = 31 * result + (int)(this.recipientId ^ this.recipientId >>> 32);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.userMentionEntities);
        result = 31 * result + Arrays.hashCode(this.urlEntities);
        result = 31 * result + Arrays.hashCode(this.hashtagEntities);
        result = 31 * result + Arrays.hashCode(this.mediaEntities);
        result = 31 * result + Arrays.hashCode(this.symbolEntities);
        return result;
    }

    public String toString() {
        return "DirectMessageJSONImpl{id=" + this.id + ", text='" + this.text + '\'' + ", senderId=" + this.senderId + ", recipientId=" + this.recipientId + ", createdAt=" + this.createdAt + ", userMentionEntities=" + Arrays.toString(this.userMentionEntities) + ", urlEntities=" + Arrays.toString(this.urlEntities) + ", hashtagEntities=" + Arrays.toString(this.hashtagEntities) + ", mediaEntities=" + Arrays.toString(this.mediaEntities) + ", symbolEntities=" + Arrays.toString(this.symbolEntities) + '}';
    }

    @Override
    public String getSenderScreenName() {
        throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to use this method due to the API changes.");
    }

    @Override
    public String getRecipientScreenName() {
        throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to use this method due to the API changes.");
    }

    @Override
    public User getSender() {
        throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to use this method due to the API changes.");
    }

    @Override
    public User getRecipient() {
        throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to use this method due to the API changes.");
    }
}

